/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;

public enum ClaimExpirationManager {
    INSTANCE;

    private static final int RUN_INTERVAL = 600000;
    private long lastRun = 0L;

    public void tick(MinecraftServer server) {
        long now = System.currentTimeMillis();
        if (now - this.lastRun > 600000L) {
            this.checkForIdleTeams(server, now);
            this.checkForTemporaryClaims(server, now);
            this.lastRun = now;
        }
    }

    private void checkForIdleTeams(MinecraftServer server, long now) {
        long max = (Long)FTBChunksWorldConfig.MAX_IDLE_DAYS_BEFORE_UNCLAIM.get() * 86400000L;
        if (max == 0L) {
            return;
        }
        ClaimedChunkManager manager = FTBChunksAPI.getManager();
        ArrayList expired = new ArrayList();
        FTBTeamsAPI.getManager().getTeams().stream().map(manager::getData).filter(data -> now - data.getLastLoginTime() > max).forEach(data -> {
            Collection<ClaimedChunk> chunks = data.getClaimedChunks();
            expired.addAll(chunks);
            FTBChunks.LOGGER.info("all chunk claims for team {} have expired due to team inactivity; unclaiming {} chunks", data, (Object)chunks.size());
        });
        if (!expired.isEmpty()) {
            CommandSourceStack sourceStack = server.m_129893_();
            HashMap<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> toSync = new HashMap<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>>();
            expired.forEach(c -> ClaimExpirationManager.unclaimChunk(now, c, toSync, sourceStack));
            ClaimExpirationManager.syncChunks(toSync, server, Util.f_137441_);
        }
    }

    private void checkForTemporaryClaims(MinecraftServer server, long now) {
        Map<UUID, List<ClaimedChunk>> chunkMap = FTBChunksAPI.getManager().getAllClaimedChunks().stream().collect(Collectors.groupingBy(cc -> cc.teamData.getTeamId()));
        chunkMap.forEach((teamId, chunks) -> {
            List<ClaimedChunk> expired = chunks.stream().filter(cc -> cc.hasExpired(now)).toList();
            if (!expired.isEmpty()) {
                FTBChunksTeamData teamData = expired.get((int)0).teamData;
                CommandSourceStack sourceStack = server.m_129893_();
                HashMap<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> toSync = new HashMap<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>>();
                expired.forEach(cc -> {
                    FTBChunks.LOGGER.info("un-forceloading chunk {} - expiry time {} passed", cc, (Object)cc.getForceLoadExpiryTime());
                    ClaimExpirationManager.unloadChunk(now, cc, toSync, sourceStack);
                });
                ClaimExpirationManager.syncChunks(toSync, server, teamData.getTeamId());
            }
        });
    }

    private static void unclaimChunk(long now, ClaimedChunk c, Map<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> toSync, CommandSourceStack sourceStack) {
        c.unclaim(sourceStack, false);
        toSync.computeIfAbsent((ResourceKey<Level>)c.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, c.pos.x, c.pos.z, null));
    }

    private static void unloadChunk(long now, ClaimedChunk c, Map<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> toSync, CommandSourceStack sourceStack) {
        c.unload(sourceStack);
        toSync.computeIfAbsent((ResourceKey<Level>)c.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, c.pos.x, c.pos.z, c));
    }

    private static void syncChunks(Map<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> toSync, MinecraftServer server, UUID teamId) {
        toSync.forEach((dimension, chunkPackets) -> {
            if (!chunkPackets.isEmpty()) {
                new SendManyChunksPacket((ResourceKey<Level>)dimension, teamId, (List<SendChunkPacket.SingleChunk>)chunkPackets).sendToAll(server);
            }
        });
    }
}

