/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import java.util.Comparator;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class FTBChunksAPI {
    public static final TagKey<Block> EDIT_WHITELIST_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("ftbchunks", "edit_whitelist"));
    public static final TagKey<Block> INTERACT_WHITELIST_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("ftbchunks", "interact_whitelist"));
    public static final TagKey<Item> RIGHT_CLICK_BLACKLIST_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("ftbchunks", "right_click_blacklist"));
    public static final TagKey<Item> RIGHT_CLICK_WHITELIST_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("ftbchunks", "right_click_whitelist"));
    public static final TagKey<EntityType<?>> ENTITY_INTERACT_WHITELIST_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("ftbchunks", "entity_interact_whitelist"));
    public static final TicketType<ChunkPos> FORCE_LOADED_TICKET = TicketType.m_9462_((String)"ftbchunks:force_loaded", Comparator.comparingLong(ChunkPos::m_45588_));
    public static ClaimedChunkManager manager;

    public static ClaimedChunkManager getManager() {
        if (manager == null) {
            throw new NullPointerException("FTB Chunks Manager hasn't been loaded yet!");
        }
        return manager;
    }

    public static boolean isManagerLoaded() {
        return manager != null;
    }

    public static ClaimResult claimAsPlayer(ServerPlayer player, ResourceKey<Level> dimension, ChunkPos pos, boolean checkOnly) {
        return FTBChunksAPI.getManager().getData(player).claim(player.m_20203_(), new ChunkDimPos(dimension, pos), checkOnly);
    }

    public static void syncPlayer(ServerPlayer player) {
        SendGeneralDataPacket.send(FTBChunksAPI.getManager().getData(player), player);
    }

    public static boolean isChunkForceLoaded(ResourceKey<Level> dimension, int x, int z) {
        return FTBChunksAPI.isManagerLoaded() && FTBChunksAPI.getManager().isChunkForceLoaded(dimension, x, z);
    }
}

