/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface IModuleInventory
extends IItemHandlerModifiable {
    public NonNullList<ItemStack> getInventory();

    public ModuleType[] acceptedModules();

    public boolean isModuleEnabled(ModuleType var1);

    public void toggleModuleState(ModuleType var1, boolean var2);

    default public BlockEntity getBlockEntity() {
        return (BlockEntity)this;
    }

    default public int getMaxNumberOfModules() {
        return this.acceptedModules().length;
    }

    default public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        BlockEntity be = this.getBlockEntity();
        if (!be.m_58904_().f_46443_) {
            if (!toggled) {
                this.toggleModuleState(module, true);
            }
            be.m_6596_();
            be.m_58904_().m_7260_(be.m_58899_(), be.m_58900_(), be.m_58900_(), 3);
        }
    }

    default public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        BlockEntity be = this.getBlockEntity();
        if (!be.m_58904_().f_46443_) {
            if (!toggled) {
                this.toggleModuleState(module, false);
            }
            be.m_6596_();
            be.m_58904_().m_7260_(be.m_58899_(), be.m_58900_(), be.m_58900_(), 3);
        }
    }

    default public boolean enableHack() {
        return false;
    }

    default public int fixSlotId(int id) {
        return id >= 100 ? id - 100 : id;
    }

    default public void dropAllModules() {
        BlockEntity be = this.getBlockEntity();
        Level level = be.m_58904_();
        BlockPos pos = be.m_58899_();
        for (ItemStack module : this.getInventory()) {
            if (!(module.m_41720_() instanceof ModuleItem)) continue;
            if (be instanceof LinkableBlockEntity) {
                LinkableBlockEntity linkable = (LinkableBlockEntity)be;
                linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)module.m_41720_()).getModuleType(), false), linkable);
            }
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)module);
        }
        this.getInventory().clear();
    }

    default public int getSlots() {
        return this.acceptedModules().length;
    }

    default public ItemStack getStackInSlot(int slot) {
        return this.getModuleInSlot(slot);
    }

    default public ItemStack getModuleInSlot(int slot) {
        return (slot = this.fixSlotId(slot)) < 0 || slot >= this.getSlots() ? ItemStack.f_41583_ : (ItemStack)this.getInventory().get(slot);
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getModuleInSlot(slot = this.fixSlotId(slot)).m_41777_();
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!simulate) {
            Item item = stack.m_41720_();
            if (item instanceof ModuleItem) {
                ModuleItem module = (ModuleItem)item;
                this.onModuleRemoved(stack, module.getModuleType(), false);
                BlockEntity blockEntity = this.getBlockEntity();
                if (blockEntity instanceof LinkableBlockEntity) {
                    LinkableBlockEntity be = (LinkableBlockEntity)blockEntity;
                    be.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)stack.m_41720_()).getModuleType(), false), be);
                }
            }
            return ((ItemStack)this.getInventory().set(slot, (Object)ItemStack.f_41583_)).m_41777_();
        }
        return stack.m_41777_();
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.getModuleInSlot(slot = this.fixSlotId(slot)).m_41619_()) {
            return stack;
        }
        int returnSize = 0;
        if (stack.m_41613_() > 1) {
            returnSize = stack.m_41613_() - 1;
        }
        if (!simulate) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            this.getInventory().set(slot, (Object)copy);
            Item item = stack.m_41720_();
            if (item instanceof ModuleItem) {
                ModuleItem module = (ModuleItem)item;
                this.onModuleInserted(stack, module.getModuleType(), false);
                BlockEntity blockEntity = this.getBlockEntity();
                if (blockEntity instanceof LinkableBlockEntity) {
                    LinkableBlockEntity be = (LinkableBlockEntity)blockEntity;
                    be.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleInserted(copy, (ModuleItem)copy.m_41720_(), false), be);
                }
            }
        }
        if (returnSize != 0) {
            ItemStack toReturn = stack.m_41777_();
            toReturn.m_41764_(returnSize);
            return toReturn;
        }
        return ItemStack.f_41583_;
    }

    default public void setStackInSlot(int slot, ItemStack stack) {
        Item item;
        ItemStack previous = this.getModuleInSlot(slot = this.fixSlotId(slot));
        if (!previous.m_41619_()) {
            this.onModuleRemoved(previous, ((ModuleItem)previous.m_41720_()).getModuleType(), false);
            item = this.getBlockEntity();
            if (item instanceof LinkableBlockEntity) {
                LinkableBlockEntity be = (LinkableBlockEntity)item;
                be.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)previous.m_41720_()).getModuleType(), false), be);
            }
        }
        this.getInventory().set(slot, (Object)stack);
        item = stack.m_41720_();
        if (item instanceof ModuleItem) {
            ModuleItem module = (ModuleItem)item;
            this.onModuleInserted(stack, module.getModuleType(), false);
            BlockEntity blockEntity = this.getBlockEntity();
            if (blockEntity instanceof LinkableBlockEntity) {
                LinkableBlockEntity be = (LinkableBlockEntity)blockEntity;
                be.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ModuleItem)stack.m_41720_(), false), be);
            }
        }
    }

    default public int getSlotLimit(int slot) {
        return 1;
    }

    default public boolean isItemValid(int slot, ItemStack stack) {
        ModuleItem module;
        Item item;
        return this.getModuleInSlot(slot = this.fixSlotId(slot)).m_41619_() && !stack.m_41619_() && (item = stack.m_41720_()) instanceof ModuleItem && this.acceptsModule((module = (ModuleItem)item).getModuleType()) && !this.hasModule(module.getModuleType());
    }

    default public boolean acceptsModule(ModuleType type) {
        for (ModuleType module : this.acceptedModules()) {
            if (module != type) continue;
            return true;
        }
        return false;
    }

    default public ArrayList<ModuleType> getInsertedModules() {
        ArrayList<ModuleType> modules = new ArrayList<ModuleType>();
        for (ItemStack stack : this.getInventory()) {
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ModuleItem)) continue;
            ModuleItem module = (ModuleItem)item;
            modules.add(module.getModuleType());
        }
        return modules;
    }

    default public ItemStack getModule(ModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            ModuleItem moduleItem;
            Item item;
            if (((ItemStack)modules.get(i)).m_41619_() || !((item = ((ItemStack)modules.get(i)).m_41720_()) instanceof ModuleItem) || (moduleItem = (ModuleItem)item).getModuleType() != module) continue;
            return (ItemStack)modules.get(i);
        }
        return ItemStack.f_41583_;
    }

    default public void insertModule(ItemStack module, boolean toggled) {
        Item item;
        if (module.m_41619_() || !((item = module.m_41720_()) instanceof ModuleItem)) {
            return;
        }
        ModuleItem moduleItem = (ModuleItem)item;
        NonNullList<ItemStack> modules = this.getInventory();
        if (!toggled) {
            for (int i = 0; i < modules.size(); ++i) {
                if (((ItemStack)modules.get(i)).m_41619_() || ((ItemStack)modules.get(i)).m_41720_() != moduleItem) continue;
                return;
            }
        }
        Predicate<ItemStack> predicate = toggled ? stack -> stack.m_41720_() == moduleItem : stack -> stack.m_41619_();
        for (int i = 0; i < modules.size(); ++i) {
            if (!predicate.test((ItemStack)modules.get(i))) continue;
            ItemStack toInsert = module.m_41777_();
            if (toggled) {
                this.toggleModuleState(moduleItem.getModuleType(), true);
                break;
            }
            modules.set(i, (Object)toInsert);
            this.onModuleInserted(toInsert, moduleItem.getModuleType(), toggled);
            break;
        }
    }

    default public void removeModule(ModuleType module, boolean toggled) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            ModuleItem moduleItem;
            Item item;
            if (((ItemStack)modules.get(i)).m_41619_() || !((item = ((ItemStack)modules.get(i)).m_41720_()) instanceof ModuleItem) || (moduleItem = (ModuleItem)item).getModuleType() != module) continue;
            if (toggled) {
                this.toggleModuleState(module, false);
                continue;
            }
            modules.set(i, (Object)ItemStack.f_41583_);
        }
    }

    default public boolean hasModule(ModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        if (module == null) {
            for (int i = 0; i < modules.size(); ++i) {
                if (!((ItemStack)modules.get(i)).m_41619_()) continue;
                return true;
            }
        } else {
            for (int i = 0; i < modules.size(); ++i) {
                ModuleItem moduleItem;
                Item item;
                if (((ItemStack)modules.get(i)).m_41619_() || !((item = ((ItemStack)modules.get(i)).m_41720_()) instanceof ModuleItem) || (moduleItem = (ModuleItem)item).getModuleType() != module) continue;
                return true;
            }
        }
        return false;
    }

    default public NonNullList<ItemStack> readModuleInventory(CompoundTag tag) {
        ListTag list = tag.m_128437_("Modules", 10);
        NonNullList modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag stackTag = list.m_128728_(i);
            byte slot = stackTag.m_128445_("ModuleSlot");
            if (slot < 0 || slot >= modules.size()) continue;
            modules.set((int)slot, (Object)ItemStack.m_41712_((CompoundTag)stackTag));
        }
        return modules;
    }

    default public EnumMap<ModuleType, Boolean> readModuleStates(CompoundTag tag) {
        EnumMap<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);
        List<ModuleType> acceptedModules = Arrays.asList(this.acceptedModules());
        for (ModuleType module : ModuleType.values()) {
            if (acceptedModules.contains((Object)module)) {
                String key = module.name().toLowerCase() + "Enabled";
                if (tag.m_128441_(key)) {
                    moduleStates.put(module, tag.m_128471_(key));
                    continue;
                }
                moduleStates.put(module, this.hasModule(module));
                continue;
            }
            moduleStates.put(module, false);
        }
        return moduleStates;
    }

    default public CompoundTag writeModuleInventory(CompoundTag tag) {
        ListTag list = new ListTag();
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).m_41619_()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128344_("ModuleSlot", (byte)i);
            ((ItemStack)modules.get(i)).m_41739_(stackTag);
            list.add((Object)stackTag);
        }
        tag.m_128365_("Modules", (Tag)list);
        return tag;
    }

    default public CompoundTag writeModuleStates(CompoundTag tag) {
        for (ModuleType module : this.acceptedModules()) {
            tag.m_128379_(module.name().toLowerCase() + "Enabled", this.isModuleEnabled(module));
        }
        return tag;
    }

    default public boolean isAllowed(Entity entity) {
        return this.isAllowed(entity.m_7755_().getString());
    }

    default public boolean isAllowed(String name) {
        if (!this.isModuleEnabled(ModuleType.ALLOWLIST)) {
            return false;
        }
        ItemStack stack = this.getModule(ModuleType.ALLOWLIST);
        if (stack.m_41782_() && stack.m_41783_().m_128471_("affectEveryone")) {
            return true;
        }
        return ModuleItem.doesModuleHaveTeamOf(stack, name, this.getBlockEntity().m_58904_()) || ModuleItem.getPlayersFromModule(stack).contains(name.toLowerCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isDenied(Entity entity) {
        String name;
        if (!this.isModuleEnabled(ModuleType.DENYLIST)) {
            return false;
        }
        ItemStack stack = this.getModule(ModuleType.DENYLIST);
        if (stack.m_41782_() && stack.m_41783_().m_128471_("affectEveryone")) {
            BlockEntity blockEntity = this.getBlockEntity();
            if (!(blockEntity instanceof IOwnable)) return true;
            IOwnable ownable = (IOwnable)blockEntity;
            if (!(entity instanceof Player)) return true;
            Player player = (Player)entity;
            if (!ownable.isOwnedBy(player)) {
                return true;
            }
        }
        if (ModuleItem.doesModuleHaveTeamOf(stack, name = entity.m_7755_().getString(), this.getBlockEntity().m_58904_())) return true;
        if (!ModuleItem.getPlayersFromModule(stack).contains(name.toLowerCase())) return false;
        return true;
    }
}

