/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public class RiftStabilizerBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape SHAPE_LOWER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
    private static final VoxelShape SHAPE_UPPER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0));

    public RiftStabilizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)this);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        RiftStabilizerBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RiftStabilizerBlockEntity && (be = (RiftStabilizerBlockEntity)blockEntity).isOwnedBy(player)) {
            if (!level.f_46443_) {
                if (be.isDisabled()) {
                    player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.RIFT_STABILIZER, pos));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        return pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(ctx) ? (BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_()) : null;
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos posAbove = pos.m_7494_();
        level.m_7731_(posAbove, DoublePlantBlock.m_182453_((LevelReader)level, (BlockPos)posAbove, (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER))), 3);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, posAbove, player));
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != half ? (BlockState)state.m_61124_((Property)POWERED, (Comparable)((Boolean)facingState.m_61143_((Property)POWERED))) : Blocks.f_50016_.m_49966_();
        }
        return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER : SHAPE_UPPER;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                DoublePlantBlock.m_52903_((Level)level, (BlockPos)pos, (BlockState)state, (Player)player);
            } else {
                RiftStabilizerBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity be, ItemStack stack) {
        super.m_6240_(level, player, pos, Blocks.f_50016_.m_49966_(), be, stack);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader level, BlockPos pos, Direction side) {
        return false;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        int n;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && state.m_61143_(HALF) == DoubleBlockHalf.LOWER && (blockEntity = level.m_7702_(pos)) instanceof RiftStabilizerBlockEntity) {
            RiftStabilizerBlockEntity be = (RiftStabilizerBlockEntity)blockEntity;
            n = 15 - (int)be.getLastTeleportDistance();
        } else {
            n = 0;
        }
        return n;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.m_6378_(state, level, pos, side);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        RiftStabilizerBlockEntity be;
        BlockEntity blockEntity;
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER && (blockEntity = level.m_7702_(pos)) instanceof RiftStabilizerBlockEntity && (be = (RiftStabilizerBlockEntity)blockEntity).isModuleEnabled(ModuleType.REDSTONE) && be.getLastTeleportationType() != null ? be.getComparatorOutputFunction().applyAsInt(be.getLastTeleportationType()) : 0;
    }

    public static RiftStabilizerBlockEntity getConnectedBlockEntity(Level level, BlockPos pos) {
        RiftStabilizerBlockEntity be;
        BlockState state = level.m_8055_(pos);
        BlockPos connectedPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        BlockEntity blockEntity = level.m_7702_(connectedPos);
        return blockEntity instanceof RiftStabilizerBlockEntity ? (be = (RiftStabilizerBlockEntity)blockEntity) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF, POWERED, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos lowerPos = pos.m_7495_();
        BlockState lowerState = level.m_8055_(lowerPos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER || lowerState.m_60713_((Block)this);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RiftStabilizerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? RiftStabilizerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.RIFT_STABILIZER_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker) : null;
    }
}

