/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class DisguisableDynamicBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<BlockState> DISGUISED_STATE = new ModelProperty();
    private final BakedModel oldModel;

    public DisguisableDynamicBakedModel(BakedModel oldModel) {
        this.oldModel = oldModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData modelData) {
        BakedModel model;
        Block block;
        BlockState disguisedState = (BlockState)modelData.getData(DISGUISED_STATE);
        if (disguisedState != null && (block = disguisedState.m_60734_()) != Blocks.f_50016_ && (model = Minecraft.m_91087_().m_91289_().m_110910_(disguisedState)) != null && model != this) {
            return model.getQuads(disguisedState, side, rand, modelData);
        }
        return this.oldModel.getQuads(state, side, rand, modelData);
    }

    public TextureAtlasSprite getParticleIcon(IModelData modelData) {
        BakedModel model;
        Block block;
        BlockState state = (BlockState)modelData.getData(DISGUISED_STATE);
        if (state != null && (block = state.m_60734_()) != Blocks.f_50016_ && (model = Minecraft.m_91087_().m_91289_().m_110910_(state)) != null && model != this) {
            return model.getParticleIcon(modelData);
        }
        return this.oldModel.getParticleIcon(modelData);
    }

    @Nonnull
    public IModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, IModelData modelData) {
        Optional<BlockState> disguisedState;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && blockEntity.m_58900_().m_60734_() instanceof DisguisableBlock && (disguisedState = DisguisableBlock.getDisguisedBlockState((BlockGetter)level, pos)).isPresent()) {
            modelData.setData(DISGUISED_STATE, (Object)disguisedState.get());
            return modelData;
        }
        modelData.setData(DISGUISED_STATE, (Object)Blocks.f_50016_.m_49966_());
        return modelData;
    }

    public TextureAtlasSprite m_6160_() {
        return this.oldModel.m_6160_();
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public boolean m_7541_() {
        return true;
    }

    public ItemOverrides m_7343_() {
        return null;
    }

    public boolean m_7547_() {
        return false;
    }
}

