/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.SetBriefcaseOwner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class BriefcaseSetupScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final TranslatableComponent setupTitle = Utils.localize("gui.securitycraft:briefcase.setupTitle", new Object[0]);
    private EditBox keycodeTextbox;
    private Button saveAndContinueButton;
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;

    public BriefcaseSetupScreen(Component title) {
        super(title);
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.f_96541_.f_91068_.m_90926_(true);
        this.saveAndContinueButton = new ExtendedButton(this.f_96543_ / 2 - 48, this.f_96544_ / 2 + 30 + 10, 100, 20, (Component)Utils.localize("gui.securitycraft:password.save", new Object[0]), this::saveAndContinueButtonClicked);
        this.m_142416_((GuiEventListener)this.saveAndContinueButton);
        this.saveAndContinueButton.f_93623_ = false;
        this.keycodeTextbox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 37, this.f_96544_ / 2 - 47, 77, 12, TextComponent.f_131282_);
        this.m_142416_((GuiEventListener)this.keycodeTextbox);
        this.keycodeTextbox.m_94199_(4);
        this.keycodeTextbox.m_94153_(s -> s.matches("[0-9]*"));
        this.keycodeTextbox.m_94151_(text -> {
            this.saveAndContinueButton.f_93623_ = text.length() == 4;
        });
        this.m_94718_((GuiEventListener)this.keycodeTextbox);
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        BriefcaseSetupScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)"CODE:", (int)(this.f_96543_ / 2 - 67), (int)(this.f_96544_ / 2 - 47 + 2), (int)0x404040);
        this.f_96547_.m_92889_(pose, (Component)this.setupTitle, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.setupTitle) / 2), (float)(this.topPos + 6), 0x404040);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private void saveAndContinueButtonClicked(Button button) {
        if (PlayerUtils.isHoldingItem((Player)Minecraft.m_91087_().f_91074_, SCContent.BRIEFCASE, null)) {
            ItemStack briefcase = PlayerUtils.getSelectedItemStack((Player)Minecraft.m_91087_().f_91074_, (Item)SCContent.BRIEFCASE.get());
            String passcode = this.keycodeTextbox.m_94155_();
            briefcase.m_41784_().m_128359_("passcode", passcode);
            if (!briefcase.m_41783_().m_128441_("owner")) {
                briefcase.m_41783_().m_128359_("owner", Minecraft.m_91087_().f_91074_.m_7755_().getString());
                briefcase.m_41783_().m_128359_("ownerUUID", Minecraft.m_91087_().f_91074_.m_142081_().toString());
            }
            SecurityCraft.channel.sendToServer((Object)new SetBriefcaseOwner(passcode));
            ClientHandler.displayBriefcasePasswordScreen(this.m_96636_());
        }
    }
}

