/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.network.server.SyncSSSSettingsOnServer;
import net.geforcemods.securitycraft.screen.components.SSSConnectionList;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class SonicSecuritySystemScreen
extends Screen
implements SSSConnectionList.ConnectionAccessor {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/sonic_security_system.png");
    private static final ResourceLocation STREAMER_ICONS = new ResourceLocation("textures/gui/stream_indicator.png");
    private static final TranslatableComponent SOUND_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.sound", new Object[0]);
    private static final int PLAYBACK_DELAY = 10;
    private final SonicSecuritySystemBlockEntity be;
    private int xSize = 300;
    private int ySize = 166;
    private Button recordingButton;
    private Button clearButton;
    private Button powerButton;
    private Button playButton;
    private TogglePictureButton soundButton;
    private SSSConnectionList<SonicSecuritySystemScreen> connectionList;
    private boolean playback = false;
    private int tickCount = 10;
    private int currentNote = 0;
    private boolean isOwner;

    public SonicSecuritySystemScreen(SonicSecuritySystemBlockEntity be) {
        super(be.m_7755_());
        this.be = be;
        this.isOwner = be.isOwnedBy((Player)Minecraft.m_91087_().f_91074_);
    }

    public void m_96624_() {
        if (this.playback) {
            ++this.tickCount;
            if (this.tickCount >= 10) {
                if (this.currentNote < this.be.getNumberOfNotes()) {
                    SonicSecuritySystemBlockEntity.NoteWrapper note = this.be.getRecordedNotes().get(this.currentNote++);
                    SoundEvent sound = NoteBlockInstrument.valueOf((String)note.instrumentName().toUpperCase()).m_61668_();
                    float pitch = (float)Math.pow(2.0, (double)(note.noteID() - 12) / 12.0);
                    this.tickCount = 0;
                    this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.be.m_58899_(), sound, SoundSource.RECORDS, 3.0f, pitch);
                } else if (this.currentNote >= this.be.getNumberOfNotes()) {
                    this.currentNote = 0;
                    this.playback = false;
                }
            }
        }
    }

    public void m_7856_() {
        super.m_7856_();
        boolean isActive = this.be.isActive();
        boolean hasNotes = this.be.getNumberOfNotes() > 0;
        int leftPos = (this.f_96543_ - this.xSize) / 2;
        int buttonX = leftPos + this.xSize - 155;
        this.powerButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(buttonX, this.f_96544_ / 2 - 59, 150, 20, this.getPowerString(this.be.isActive()), button -> {
            boolean toggledState = !this.be.isActive();
            boolean containsNotes = this.be.getNumberOfNotes() > 0;
            this.be.setActive(toggledState);
            SecurityCraft.channel.sendToServer((Object)new SyncSSSSettingsOnServer(this.be.m_58899_(), toggledState ? SyncSSSSettingsOnServer.DataType.POWER_ON : SyncSSSSettingsOnServer.DataType.POWER_OFF));
            this.powerButton.m_93666_(this.getPowerString(toggledState));
            if (!toggledState) {
                this.recordingButton.m_93666_(this.getRecordingString(false));
            }
            this.recordingButton.f_93623_ = toggledState;
            this.soundButton.f_93623_ = toggledState;
            this.playButton.f_93623_ = toggledState && containsNotes;
            this.clearButton.f_93623_ = toggledState && containsNotes;
        }));
        this.recordingButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(buttonX, this.f_96544_ / 2 - 32, 150, 20, this.getRecordingString(this.be.isRecording()), button -> {
            boolean recording = !this.be.isRecording();
            this.be.setRecording(recording);
            SecurityCraft.channel.sendToServer((Object)new SyncSSSSettingsOnServer(this.be.m_58899_(), recording ? SyncSSSSettingsOnServer.DataType.RECORDING_ON : SyncSSSSettingsOnServer.DataType.RECORDING_OFF));
            this.recordingButton.m_93666_(this.getRecordingString(this.be.isRecording()));
        }));
        this.playButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(buttonX, this.f_96544_ / 2 - 10, 150, 20, (Component)Utils.localize("gui.securitycraft:sonic_security_system.recording.play", new Object[0]), button -> {
            if (this.be.getNumberOfNotes() > 0) {
                this.playback = true;
            }
        }));
        this.clearButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(buttonX, this.f_96544_ / 2 + 12, 150, 20, (Component)Utils.localize("gui.securitycraft:sonic_security_system.recording.clear", new Object[0]), button -> {
            this.be.clearNotes();
            SecurityCraft.channel.sendToServer((Object)new SyncSSSSettingsOnServer(this.be.m_58899_(), SyncSSSSettingsOnServer.DataType.CLEAR_NOTES));
            this.playButton.f_93623_ = false;
            this.clearButton.f_93623_ = false;
        }));
        this.soundButton = (TogglePictureButton)this.m_142416_((GuiEventListener)new TogglePictureButton(buttonX + 130, this.f_96544_ / 2 + 52, 20, 20, STREAMER_ICONS, new int[]{0, 0}, new int[]{32, 48}, 2, 16, 16, 16, 16, 16, 64, 2, button -> {
            boolean toggledPing = !this.be.pings();
            this.be.setPings(toggledPing);
            SecurityCraft.channel.sendToServer((Object)new SyncSSSSettingsOnServer(this.be.m_58899_(), toggledPing ? SyncSSSSettingsOnServer.DataType.SOUND_ON : SyncSSSSettingsOnServer.DataType.SOUND_OFF));
        }));
        this.soundButton.setCurrentIndex(!this.be.pings() ? 1 : 0);
        this.connectionList = (SSSConnectionList)this.m_142416_((GuiEventListener)new SSSConnectionList<SonicSecuritySystemScreen>(this, this.f_96541_, 130, 120, this.powerButton.f_93621_, leftPos + 10));
        this.powerButton.f_93623_ = !this.be.isShutDown() && this.isOwner;
        this.recordingButton.f_93623_ = isActive && this.isOwner;
        this.soundButton.f_93623_ = isActive && this.isOwner;
        this.playButton.f_93623_ = isActive && hasNotes;
        this.clearButton.f_93623_ = isActive && hasNotes && this.isOwner;
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        int textWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        int soundTextLength = this.f_96547_.m_92852_((FormattedText)SOUND_TEXT);
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        SonicSecuritySystemScreen.m_93133_((PoseStack)pose, (int)startX, (int)startY, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)512, (int)512);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(pose, this.f_96539_, (float)(startX + this.xSize / 2 - textWidth / 2), (float)(startY + 6), 0x404040);
        this.f_96547_.m_92889_(pose, (Component)SOUND_TEXT, (float)(this.soundButton.f_93620_ - soundTextLength - 5), (float)(startY + 141), 0x404040);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.connectionList != null) {
            this.connectionList.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public Set<BlockPos> getPositions() {
        if (this.isOwner) {
            return this.be.getLinkedBlocks();
        }
        return Set.of();
    }

    @Override
    public void removePosition(BlockPos pos) {
        this.be.delink(pos, true);
        this.connectionList.refreshPositions();
        SecurityCraft.channel.sendToServer((Object)new SyncSSSSettingsOnServer(this.be.m_58899_(), SyncSSSSettingsOnServer.DataType.REMOVE_POS, pos));
    }

    private Component getRecordingString(boolean recording) {
        return recording ? Utils.localize("gui.securitycraft:sonic_security_system.stop_recording", new Object[0]) : Utils.localize("gui.securitycraft:sonic_security_system.start_recording", new Object[0]);
    }

    private Component getPowerString(boolean on) {
        return on ? Utils.localize("gui.securitycraft:sonic_security_system.power.on", new Object[0]) : Utils.localize("gui.securitycraft:sonic_security_system.power.off", new Object[0]);
    }
}

