/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class BlockUtils {
    private static final LazyOptional<IItemHandler> EMPTY_INVENTORY = LazyOptional.of(() -> EmptyHandler.INSTANCE);

    public static boolean isSideSolid(LevelReader level, BlockPos pos, Direction side) {
        return level.m_8055_(pos).m_60783_((BlockGetter)level, pos, side);
    }

    public static void updateAndNotify(Level level, BlockPos pos, Block block, int delay, boolean shouldUpdate) {
        if (shouldUpdate) {
            level.m_186460_(pos, block, delay);
        }
        level.m_46672_(pos, block);
    }

    public static int[] posToIntArray(BlockPos pos) {
        return new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()};
    }

    public static Explosion.BlockInteraction getExplosionMode() {
        return (Boolean)ConfigHandler.SERVER.mineExplosionsBreakBlocks.get() != false ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE;
    }

    public static boolean hasActiveSCBlockNextTo(Level level, BlockPos pos) {
        return SecurityCraftAPI.getRegisteredDoorActivators().stream().anyMatch(activator -> BlockUtils.hasActiveSCBlockNextTo(level, pos, level.m_7702_(pos), activator));
    }

    private static boolean hasActiveSCBlockNextTo(Level level, BlockPos pos, BlockEntity be, IDoorActivator activator) {
        for (Direction dir : Direction.values()) {
            IOwnable ownable;
            BlockEntity offsetBe;
            BlockPos offsetPos = pos.m_142300_(dir);
            BlockState offsetState = level.m_8055_(offsetPos);
            if (activator.getBlocks().contains(offsetState.m_60734_()) && activator.isPowering(level, offsetPos, offsetState, offsetBe = level.m_7702_(offsetPos), dir, 1) && (!(offsetBe instanceof IOwnable) || (ownable = (IOwnable)offsetBe).getOwner().owns((IOwnable)be))) {
                return true;
            }
            if (level.m_46681_(offsetPos, dir) != 15 || offsetState.m_60803_()) continue;
            for (Direction dirOffset : Direction.values()) {
                IOwnable ownable2;
                BlockEntity offsetBe2;
                if (dirOffset.m_122424_() == dir) continue;
                BlockPos newOffsetPos = offsetPos.m_142300_(dirOffset);
                offsetState = level.m_8055_(newOffsetPos);
                if (!activator.getBlocks().contains(offsetState.m_60734_()) || !activator.isPowering(level, newOffsetPos, offsetState, offsetBe2 = level.m_7702_(newOffsetPos), dirOffset, 2) || offsetBe2 instanceof IOwnable && !(ownable2 = (IOwnable)offsetBe2).getOwner().owns((IOwnable)be)) continue;
                return true;
            }
        }
        return false;
    }

    public static LazyOptional<?> getProtectedCapability(Direction side, BlockEntity be, Supplier<LazyOptional<?>> extractionPermittedHandler, Supplier<LazyOptional<?>> insertOnlyHandler) {
        if (side == null) {
            return EMPTY_INVENTORY;
        }
        BlockPos offsetPos = be.m_58899_().m_142300_(side);
        BlockState offsetState = be.m_58904_().m_8055_(offsetPos);
        for (IExtractionBlock extractionBlock : SecurityCraftAPI.getRegisteredExtractionBlocks()) {
            if (offsetState.m_60734_() != extractionBlock.getBlock()) continue;
            if (!extractionBlock.canExtract((IOwnable)be, be.m_58904_(), offsetPos, offsetState)) {
                return EMPTY_INVENTORY;
            }
            return extractionPermittedHandler.get();
        }
        return insertOnlyHandler.get();
    }

    public static void updateIndirectNeighbors(Level level, BlockPos pos, Block block) {
        BlockUtils.updateIndirectNeighbors(level, pos, block, Direction.values());
    }

    public static void updateIndirectNeighbors(Level level, BlockPos pos, Block block, Direction ... directions) {
        level.m_46672_(pos, block);
        for (Direction dir : directions) {
            level.m_46672_(pos.m_142300_(dir), block);
        }
    }

    public static void destroyInSequence(Block blockToDestroy, LevelAccessor level, BlockPos pos, Direction ... directions) {
        for (Direction direction : directions) {
            int i = 1;
            BlockPos modifiedPos = pos.m_5484_(direction, i);
            while (level.m_8055_(modifiedPos).m_60734_() == blockToDestroy) {
                level.m_46961_(modifiedPos, false);
                modifiedPos = pos.m_5484_(direction, ++i);
            }
        }
    }
}

