/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt.config;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.nio.file.Path;
import net.minecraft.world.level.storage.LevelResource;

public interface ConfigUtil {
    public static final Path ROOT_DIR = Platform.getGameFolder();
    public static final Path DEFAULT_CONFIG_DIR = ROOT_DIR.resolve("defaultconfigs");
    public static final Path CONFIG_DIR = Platform.getConfigFolder();
    public static final Path LOCAL_DIR = ROOT_DIR.resolve("local");
    public static final LevelResource SERVER_CONFIG_DIR = new LevelResource("serverconfig");

    public static void loadDefaulted(SNBTConfig config, Path configDir, String namespace) {
        ConfigUtil.loadDefaulted(config, configDir, namespace, config.key + ".snbt");
    }

    public static void loadDefaulted(SNBTConfig config, Path configDir, String namespace, String filename) {
        Path configPath = configDir.resolve(filename).toAbsolutePath();
        Path defaultPath = DEFAULT_CONFIG_DIR.resolve(namespace).resolve(filename);
        config.load(configPath, defaultPath, () -> new String[]{"Default config file that will be copied to " + ROOT_DIR.relativize(configPath) + " if it doesn't exist!", "Just copy any values you wish to override in here!"});
    }
}

