/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.ContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class WidgetContainerScreen<T extends Widget, X extends BaseContainer>
extends AbstractContainerScreen<X> {
    private static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("supermartijn642corelib", "textures/gui/slot.png");
    protected final X container;
    protected final T widget;
    private boolean initialized = false;
    private final boolean drawSlots;
    private final boolean isPauseScreen;

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots, isPauseScreen);
    }

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots);
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        super(container, ((BaseContainer)((Object)container)).player.m_150109_(), (Component)TextComponents.empty().get());
        this.widget = widget;
        this.container = container;
        this.drawSlots = drawSlots;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots) {
        this(widget, container, drawSlots, false);
    }

    public void m_7856_() {
        if (!this.initialized) {
            if (this.widget instanceof ContainerWidget) {
                ((ContainerWidget)this.widget).initialize(this.container);
            } else {
                this.widget.initialize();
            }
            this.initialized = true;
        }
        this.f_97726_ = this.widget.width();
        this.f_97727_ = this.widget.height();
        super.m_7856_();
    }

    public void m_7379_() {
        this.widget.discard();
        super.m_7379_();
    }

    protected void m_181908_() {
        this.widget.update();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        ItemStack cursorStack;
        this.m_7333_(poseStack);
        int offsetX = (this.f_96543_ - this.widget.width()) / 2;
        int offsetY = (this.f_96544_ - this.widget.height()) / 2;
        int offsetMouseX = mouseX - offsetX;
        int offsetMouseY = mouseY - offsetY;
        poseStack.m_85836_();
        poseStack.m_85837_((double)offsetX, (double)offsetY, 0.0);
        this.widget.setFocused(offsetMouseX >= 0 && offsetMouseX < this.widget.width() && offsetMouseY >= 0 && offsetMouseY < this.widget.height());
        this.widget.renderBackground(poseStack, offsetMouseX, offsetMouseY);
        if (this.drawSlots) {
            for (Slot slot : ((BaseContainer)((Object)this.container)).f_38839_) {
                ScreenUtils.bindTexture(SLOT_TEXTURE);
                ScreenUtils.drawTexture(poseStack, slot.f_40220_ - 1, slot.f_40221_ - 1, 18.0f, 18.0f);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.DrawBackground((AbstractContainerScreen)this, poseStack, mouseX, mouseY));
        this.widget.render(poseStack, offsetMouseX, offsetMouseY);
        this.f_97734_ = null;
        for (Slot slot : ((BaseContainer)((Object)this.container)).f_38839_) {
            if (!slot.m_6659_()) continue;
            RenderSystem.m_157191_().m_85836_();
            RenderSystem.m_157191_().m_85837_((double)offsetX, (double)offsetY, 0.0);
            this.m_97799_(poseStack, slot);
            RenderSystem.m_157191_().m_85849_();
            RenderSystem.m_157182_();
            if (!this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY)) continue;
            this.f_97734_ = slot;
            WidgetContainerScreen.renderSlotHighlight((PoseStack)poseStack, (int)slot.f_40220_, (int)slot.f_40221_, (int)this.m_93252_(), (int)this.getSlotColor(0));
        }
        this.widget.renderForeground(poseStack, offsetMouseX, offsetMouseY);
        this.m_7025_(poseStack, offsetMouseX, offsetMouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.DrawForeground((AbstractContainerScreen)this, poseStack, mouseX, mouseY));
        ItemStack itemStack = cursorStack = this.f_97711_.m_41619_() ? ((BaseContainer)this.f_97732_).m_142621_() : this.f_97711_;
        if (!cursorStack.m_41619_()) {
            int offset = this.f_97711_.m_41619_() ? 8 : 16;
            String s = null;
            if (!this.f_97711_.m_41619_() && this.f_97710_) {
                cursorStack = cursorStack.m_41777_();
                cursorStack.m_41764_(Mth.m_14167_((float)((float)cursorStack.m_41613_() / 2.0f)));
            } else if (this.f_97738_ && this.f_97737_.size() > 1) {
                cursorStack = cursorStack.m_41777_();
                cursorStack.m_41764_(this.f_97720_);
                if (cursorStack.m_41619_()) {
                    s = ChatFormatting.YELLOW + "0";
                }
            }
            this.m_97782_(cursorStack, mouseX - 8, mouseY - offset, s);
        }
        if (!this.f_97715_.m_41619_()) {
            float f = (float)(Util.m_137550_() - this.f_97714_) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.f_97715_ = ItemStack.f_41583_;
            }
            int j2 = this.f_97707_.f_40220_ - this.f_97712_;
            int k2 = this.f_97707_.f_40221_ - this.f_97713_;
            int j1 = this.f_97712_ + (int)((float)j2 * f);
            int k1 = this.f_97713_ + (int)((float)k2 * f);
            this.m_97782_(this.f_97715_, j1, k1, null);
        }
        this.widget.renderOverlay(poseStack, offsetMouseX, offsetMouseY);
        this.widget.renderTooltips(poseStack, offsetMouseX, offsetMouseY);
        poseStack.m_85849_();
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.f_96543_ - this.widget.width()) / 2;
        return this.widget.mousePressed((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.f_96544_ - this.widget.height()) / 2), button, false) || super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.f_96543_ - this.widget.width()) / 2;
        return this.widget.mouseReleased((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.f_96544_ - this.widget.height()) / 2), button, false) || super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int offsetY;
        int offsetX = (this.f_96543_ - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.f_96544_ - this.widget.height()) / 2), amount, false) || super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.widget.keyPressed(keyCode, false)) {
            return true;
        }
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.widget.keyReleased(keyCode, false) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char character, int modifiers) {
        return this.widget.charTyped(character, false) || super.m_5534_(character, modifiers);
    }

    public boolean m_7043_() {
        return this.isPauseScreen;
    }

    public Component m_142562_() {
        Component message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

