/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.Leaderboard;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MiscCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"kickme").requires((Predicate)FTBEConfig.KICKME)).executes(context -> MiscCommands.kickme(((CommandSourceStack)context.getSource()).m_81375_())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trashcan").requires((Predicate)FTBEConfig.TRASHCAN)).executes(context -> MiscCommands.trashcan(((CommandSourceStack)context.getSource()).m_81375_())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"enderchest").requires((Predicate)FTBEConfig.ENDER_CHEST)).executes(context -> MiscCommands.enderChest(((CommandSourceStack)context.getSource()).m_81375_(), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(context -> MiscCommands.enderChest(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        LiteralArgumentBuilder leaderboardCommand = Commands.m_82127_((String)"leaderboard");
        for (Leaderboard<?> leaderboard : Leaderboard.MAP.values()) {
            leaderboardCommand = (LiteralArgumentBuilder)leaderboardCommand.then(Commands.m_82127_((String)leaderboard.name).executes(context -> MiscCommands.leaderboard((CommandSourceStack)context.getSource(), leaderboard, false)));
        }
        dispatcher.register(leaderboardCommand);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"recording").requires((Predicate)FTBEConfig.REC)).executes(context -> MiscCommands.recording(((CommandSourceStack)context.getSource()).m_81375_())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"streaming").requires((Predicate)FTBEConfig.REC)).executes(context -> MiscCommands.streaming(((CommandSourceStack)context.getSource()).m_81375_())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hat").requires(FTBEConfig.HAT.enabledAndOp())).executes(context -> MiscCommands.hat(((CommandSourceStack)context.getSource()).m_81375_())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nickname").requires((Predicate)FTBEConfig.NICK)).executes(context -> MiscCommands.nickname(((CommandSourceStack)context.getSource()).m_81375_(), ""))).then(Commands.m_82129_((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).executes(context -> MiscCommands.nickname(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"nickname")))));
    }

    private static int enderChest(ServerPlayer player, @Nullable ServerPlayer target) {
        TranslatableComponent title = new TranslatableComponent("container.enderchest");
        if (target != null) {
            title.m_130946_(" \u00d7 ").m_7220_(target.m_5446_());
        }
        ServerPlayer t = target == null ? player : target;
        player.m_5893_((MenuProvider)new SimpleMenuProvider((i, inv, p) -> ChestMenu.m_39237_((int)i, (Inventory)inv, (Container)t.m_36327_()), (Component)title));
        return 1;
    }

    public static int kickme(ServerPlayer player) {
        player.f_8906_.m_9942_((Component)new TextComponent("You kicked yourself!"));
        return 1;
    }

    public static int trashcan(ServerPlayer player) {
        player.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("Trash Can");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                return ChestMenu.m_39258_((int)id, (Inventory)playerInventory);
            }
        });
        return 1;
    }

    public static <T extends Number> int leaderboard(CommandSourceStack source, Leaderboard<T> leaderboard, boolean reverse) {
        try {
            Files.list(FTBEWorldData.instance.mkdirs("playerdata")).filter(path -> path.toString().endsWith(".json")).map(Path::getFileName).map(path -> new GameProfile(UUID.fromString(path.toString().replace(".json", "")), null)).filter(profile -> !FTBEPlayerData.MAP.containsKey(profile.getId())).map(FTBEPlayerData::get).filter(Objects::nonNull).forEach(FTBEPlayerData::load);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        int self = -1;
        for (FTBEPlayerData playerData : FTBEPlayerData.MAP.values()) {
            ServerStatsCounter stats = source.m_81377_().m_6846_().m_11239_((Player)FakePlayerFactory.get((ServerLevel)source.m_81372_(), (GameProfile)new GameProfile(playerData.uuid, playerData.name)));
            Number num = (Number)leaderboard.valueGetter.apply(stats);
            if (!leaderboard.filter.test(num)) continue;
            list.add(Pair.of((Object)playerData, (Object)num));
        }
        if (reverse) {
            list.sort(Comparator.comparingDouble(pair -> ((Number)pair.getRight()).doubleValue()));
        } else {
            list.sort((pair1, pair2) -> Double.compare(((Number)pair2.getRight()).doubleValue(), ((Number)pair1.getRight()).doubleValue()));
        }
        if (source.m_81373_() instanceof ServerPlayer) {
            for (int i = 0; i < list.size(); ++i) {
                if (!((FTBEPlayerData)((Pair)list.get((int)i)).getLeft()).uuid.equals(source.m_81373_().m_142081_())) continue;
                self = list.size();
                break;
            }
        }
        source.m_81354_((Component)new TextComponent("== Leaderboard [" + leaderboard.name + "] ==").m_130940_(ChatFormatting.DARK_GREEN), false);
        if (list.isEmpty()) {
            source.m_81354_((Component)new TextComponent("No data!").m_130940_(ChatFormatting.GRAY), false);
            return 1;
        }
        for (int i = 0; i < Math.min(20, list.size()); ++i) {
            Pair pair3 = (Pair)list.get(i);
            Object num = String.valueOf(i + 1);
            if (i < 10) {
                num = "0" + (String)num;
            }
            TextComponent component = new TextComponent("");
            component.m_130940_(ChatFormatting.GRAY);
            if (i == 0) {
                component.m_7220_((Component)new TextComponent("#" + (String)num + " ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)13938487))));
            } else if (i == 1) {
                component.m_7220_((Component)new TextComponent("#" + (String)num + " ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xC0C0C0))));
            } else if (i == 2) {
                component.m_7220_((Component)new TextComponent("#" + (String)num + " ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)10451508))));
            } else {
                component.m_7220_((Component)new TextComponent("#" + (String)num + " "));
            }
            component.m_7220_((Component)new TextComponent(((FTBEPlayerData)pair3.getLeft()).name).m_130940_(i == self ? ChatFormatting.GREEN : ChatFormatting.YELLOW));
            component.m_7220_((Component)new TextComponent(": "));
            component.m_7220_((Component)new TextComponent(leaderboard.stringGetter.apply((Number)pair3.getRight())));
            source.m_81354_((Component)component, false);
        }
        return 1;
    }

    public static int recording(ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        data.recording = data.recording == 1 ? 0 : 1;
        data.save();
        player.refreshDisplayName();
        if (data.recording == 1) {
            player.f_8924_.m_6846_().m_11264_((Component)new TextComponent("").m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_(" is now recording!"), ChatType.CHAT, Util.f_137441_);
        } else {
            player.f_8924_.m_6846_().m_11264_((Component)new TextComponent("").m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_(" is no longer recording!"), ChatType.CHAT, Util.f_137441_);
        }
        data.sendTabName(player.f_8924_);
        return 1;
    }

    public static int streaming(ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        data.recording = data.recording == 2 ? 0 : 2;
        data.save();
        player.refreshDisplayName();
        if (data.recording == 2) {
            player.f_8924_.m_6846_().m_11264_((Component)new TextComponent("").m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_(" is now streaming!"), ChatType.CHAT, Util.f_137441_);
        } else {
            player.f_8924_.m_6846_().m_11264_((Component)new TextComponent("").m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_(" is no longer streaming!"), ChatType.CHAT, Util.f_137441_);
        }
        data.sendTabName(player.f_8924_);
        return 1;
    }

    public static int hat(ServerPlayer player) {
        ItemStack hstack = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack istack = player.m_6844_(EquipmentSlot.MAINHAND);
        player.m_8061_(EquipmentSlot.HEAD, istack);
        player.m_8061_(EquipmentSlot.MAINHAND, hstack);
        player.f_36095_.m_38946_();
        return 1;
    }

    public static int nickname(ServerPlayer player, String nick) {
        if (nick.length() > 30) {
            player.m_5661_((Component)new TextComponent("Nickname too long!"), false);
            return 0;
        }
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        data.nick = nick.trim();
        data.save();
        player.refreshDisplayName();
        if (data.nick.isEmpty()) {
            player.m_5661_((Component)new TextComponent("Nickname reset!"), false);
        } else {
            player.m_5661_((Component)new TextComponent("Nickname changed to '" + data.nick + "'"), false);
        }
        data.sendTabName(player.f_8924_);
        return 1;
    }
}

