/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.metadata.EntityProperties;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeEntityProperties;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.NullWorld;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

class ForgeEntity
implements Entity {
    private final WeakReference<net.minecraft.world.entity.Entity> entityRef;

    ForgeEntity(net.minecraft.world.entity.Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entityRef = new WeakReference<net.minecraft.world.entity.Entity>(entity);
    }

    @Override
    public BaseEntity getState() {
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)this.entityRef.get();
        if (entity == null || entity.m_20159_()) {
            return null;
        }
        ResourceLocation id = entity.m_6095_().getRegistryName();
        if (id == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        entity.m_20240_(tag);
        return new BaseEntity(EntityTypes.get(id.toString()), NBTConverter.fromNative(tag));
    }

    @Override
    public Location getLocation() {
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)this.entityRef.get();
        if (entity != null) {
            Vector3 position = Vector3.at(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            float yaw = entity.m_146908_();
            float pitch = entity.m_146909_();
            return new Location((Extent)ForgeAdapter.adapt((ServerLevel)entity.f_19853_), position, yaw, pitch);
        }
        return new Location(NullWorld.getInstance());
    }

    @Override
    public boolean setLocation(Location location) {
        return false;
    }

    @Override
    public Extent getExtent() {
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)this.entityRef.get();
        if (entity != null) {
            return ForgeAdapter.adapt((ServerLevel)entity.f_19853_);
        }
        return NullWorld.getInstance();
    }

    @Override
    public boolean remove() {
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)this.entityRef.get();
        if (entity != null) {
            entity.m_142687_(Entity.RemovalReason.KILLED);
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)this.entityRef.get();
        if (entity != null) {
            if (EntityProperties.class.isAssignableFrom(cls)) {
                return (T)new ForgeEntityProperties(entity);
            }
            return null;
        }
        return null;
    }
}

