/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

public record KeyValuePair(String key, String value) {
    public static final KeyValuePair EMPTY = KeyValuePair.parse("");
    public static final String SEPARATOR = "=";

    public KeyValuePair(String key, String value) {
        this.key = key.trim();
        this.value = value.trim();
    }

    public static KeyValuePair parse(String asString) {
        int sepStart = asString.indexOf(SEPARATOR);
        if (sepStart == -1) {
            return new KeyValuePair(asString, "");
        }
        int sepEnd = sepStart + SEPARATOR.length();
        String aKey = asString.substring(0, sepStart);
        String aValue = sepEnd >= asString.length() ? "" : asString.substring(sepEnd);
        return new KeyValuePair(aKey, aValue);
    }

    public boolean isEmpty() {
        return this.key().isEmpty() && this.value().isEmpty();
    }

    @Override
    public String toString() {
        return this.isEmpty() ? "" : this.key() + SEPARATOR + this.value();
    }
}

