/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui;

import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import com.mojang.blaze3d.vertex.PoseStack;
import flaxbeard.immersivepetroleum.client.gui.DerrickSettingsScreen;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.DerrickTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.gui.DerrickContainer;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidTank;

public class DerrickScreen
extends AbstractContainerScreen<DerrickContainer> {
    static final ResourceLocation GUI_TEXTURE = ResourceUtils.ip("textures/gui/derrick.png");
    Button cfgButton;
    final DerrickTileEntity tile;
    private List<InfoArea> areas;

    public DerrickScreen(DerrickContainer inventorySlotsIn, Inventory inv, Component title) {
        super((AbstractContainerMenu)inventorySlotsIn, inv, title);
        this.tile = (DerrickTileEntity)((DerrickContainer)this.f_97732_).tile;
        this.f_97726_ = 200;
        this.f_97727_ = 164;
    }

    protected void m_7856_() {
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.cfgButton = new Button(this.f_97735_ + 125, this.f_97736_ + 52, 50, 20, (Component)new TextComponent(I18n.m_118938_((String)"gui.immersivepetroleum.derrick.msg.config", (Object[])new Object[0])), button -> this.f_96541_.m_91152_((Screen)new DerrickSettingsScreen(this)), (button, matrix, mx, my) -> {
            if (!button.f_93623_) {
                this.m_169388_(matrix, List.of(new TextComponent(I18n.m_118938_((String)"gui.immersivepetroleum.derrick.msg.set_in_stone", (Object[])new Object[0]))), Optional.empty(), mx, my);
            }
        });
        this.m_142416_((GuiEventListener)this.cfgButton);
        this.areas = List.of(new FluidInfoArea((IFluidTank)this.tile.tank, new Rect2i(this.f_97735_ + 11, this.f_97736_ + 16, 16, 47), 200, 0, 20, 51, GUI_TEXTURE), new EnergyInfoArea(this.f_97735_ + 185, this.f_97736_ + 19, (IEnergyStorage)this.tile.energyStorage));
    }

    public void m_6305_(@Nonnull PoseStack matrix, int mx, int my, float partialTicks) {
        this.f_97731_ = this.f_97727_ - 40;
        this.m_7333_(matrix);
        super.m_6305_(matrix, mx, my, partialTicks);
        this.m_7025_(matrix, mx, my);
        ArrayList tooltip = new ArrayList();
        for (InfoArea area : this.areas) {
            area.fillTooltip(mx, my, tooltip);
        }
        if (!tooltip.isEmpty()) {
            this.m_169388_(matrix, tooltip, Optional.empty(), mx, my);
        }
    }

    protected void m_7027_(@Nonnull PoseStack matrix, int x, int y) {
        if (this.tile.m_58899_().m_123342_() <= 62) {
            this.drawInfoTextCenteredMultiLine(matrix, I18n.m_118938_((String)"gui.immersivepetroleum.derrick.msg.water_table", (Object[])new Object[0]), 0xEF0000);
            return;
        }
        WellTileEntity well = this.tile.getWell();
        if (well != null) {
            if (this.cfgButton.f_93623_ && well.wellPipeLength > 0) {
                this.cfgButton.f_93623_ = false;
            }
            if (well.wellPipeLength < well.getMaxPipeLength()) {
                if (this.tile.isRSDisabled()) {
                    this.drawInfoTextCentered(matrix, (Component)new TranslatableComponent("gui.immersivepetroleum.derrick.msg.disabled"), 0, 0xEF0000);
                    return;
                }
                if (this.tile.drilling) {
                    String str = String.format(Locale.ROOT, "(%d%%)", (int)((float)(100 * well.wellPipeLength) / (float)well.getMaxPipeLength()));
                    this.drawInfoText(matrix, (Component)new TranslatableComponent("gui.immersivepetroleum.derrick.msg.drilling", new Object[]{str}), 0);
                    return;
                }
                if (well.pipes <= 0 && !((DerrickContainer)this.f_97732_).m_38853_(0).m_6657_()) {
                    this.drawInfoTextCentered(matrix, (Component)new TranslatableComponent("gui.immersivepetroleum.derrick.msg.out_of_pipes"), 3, 0xEF0000);
                    return;
                }
                if (this.tile.tank.isEmpty()) {
                    int realPipeLength = this.tile.m_58899_().m_123342_() - 1 - well.m_58899_().m_123342_();
                    int concreteNeeded = DerrickTileEntity.CONCRETE.getAmount() * (realPipeLength - well.wellPipeLength);
                    if (concreteNeeded > 0) {
                        this.drawInfoText(matrix, (Component)new TranslatableComponent("gui.immersivepetroleum.derrick.msg.missing", new Object[]{Utils.fDecimal(concreteNeeded) + "mB"}), 0, 0xEF0000);
                        this.drawInfoText(matrix, DerrickTileEntity.CONCRETE.getDisplayName(), 1, 0xEF0000);
                        return;
                    }
                    int waterNeeded = DerrickTileEntity.WATER.getAmount() * (well.getMaxPipeLength() - well.wellPipeLength);
                    if (waterNeeded > 0) {
                        this.drawInfoText(matrix, (Component)new TranslatableComponent("gui.immersivepetroleum.derrick.msg.missing", new Object[]{Utils.fDecimal(waterNeeded) + "mB"}), 0, 0xEF0000);
                        this.drawInfoText(matrix, DerrickTileEntity.WATER.getDisplayName(), 1, 0xEF0000);
                        return;
                    }
                }
            } else if (this.tile.spilling) {
                this.drawInfoTextCenteredMultiLine(matrix, I18n.m_118938_((String)"gui.immersivepetroleum.derrick.msg.safety_valve", (Object[])new Object[0]), 0xEF0000);
            } else {
                this.drawInfoTextCenteredMultiLine(matrix, I18n.m_118938_((String)"gui.immersivepetroleum.derrick.msg.completed", (Object[])new Object[0]), 0xFF9900);
            }
        }
    }

    private void drawInfoText(PoseStack matrix, Component text, int line) {
        this.drawInfoText(matrix, text, line, 0xFF9900);
    }

    private void drawInfoText(PoseStack matrix, Component text, int line, int color) {
        this.f_96547_.m_92889_(matrix, text, 60.0f, (float)(10 + 9 * line), color);
    }

    private void drawInfoTextCentered(PoseStack matrix, Component text, int line) {
        this.drawInfoTextCentered(matrix, text, line, 0xFF9900);
    }

    private void drawInfoTextCentered(PoseStack matrix, Component text, int line, int color) {
        int strWidth = this.f_96547_.m_92895_(text.getString());
        this.f_96547_.m_92889_(matrix, text, 118.5f - (float)strWidth / 2.0f, (float)(10 + 9 * line), color);
    }

    private void drawInfoTextCenteredMultiLine(PoseStack matrix, String text, int color) {
        String[] lines = text.split("<br>");
        for (int i = 0; i < Math.min(lines.length, 4); ++i) {
            this.drawInfoTextCentered(matrix, (Component)new TextComponent(lines[i].length() > 25 ? lines[i].substring(0, 25) : lines[i]), i, color);
        }
    }

    protected void m_7286_(@Nonnull PoseStack matrix, float partialTicks, int mx, int my) {
        MCUtil.bindTexture(GUI_TEXTURE);
        this.m_93228_(matrix, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (InfoArea area : this.areas) {
            area.draw(matrix);
        }
    }
}

