/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import flaxbeard.immersivepetroleum.api.crafting.HighPressureRefineryRecipe;
import flaxbeard.immersivepetroleum.common.IPMenuTypes;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPClientTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPServerTickableTile;
import flaxbeard.immersivepetroleum.common.gui.IPMenuProvider;
import flaxbeard.immersivepetroleum.common.multiblocks.HydroTreaterMultiblock;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class HydrotreaterTileEntity
extends PoweredMultiblockBlockEntity<HydrotreaterTileEntity, HighPressureRefineryRecipe>
implements IPServerTickableTile,
IPClientTickableTile,
IPMenuProvider<HydrotreaterTileEntity>,
IEBlockInterfaces.IBlockBounds {
    public static final int TANK_INPUT_A = 0;
    public static final int TANK_INPUT_B = 1;
    public static final int TANK_OUTPUT = 2;
    public static final BlockPos Fluid_IN_A = new BlockPos(1, 0, 3);
    public static final BlockPos Fluid_IN_B = new BlockPos(2, 2, 1);
    public static final BlockPos Fluid_OUT = new BlockPos(0, 1, 2);
    public static final BlockPos Item_OUT = new BlockPos(0, 0, 2);
    public static final Set<PoweredMultiblockBlockEntity.MultiblockFace> Energy_IN = ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 2, 3, RelativeBlockFace.UP));
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(0, 1, 3));
    public final FluidTank[] tanks = new FluidTank[]{new FluidTank(12000), new FluidTank(12000), new FluidTank(12000)};
    private final MultiblockCapability<IFluidHandler> inputAHandler = MultiblockCapability.make((Object)this, be -> be.inputAHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidInput(new IFluidTank[]{this.tanks[0]}));
    private final MultiblockCapability<IFluidHandler> inputBHandler = MultiblockCapability.make((Object)this, be -> be.inputBHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidInput(new IFluidTank[]{this.tanks[1]}));
    private final MultiblockCapability<IFluidHandler> outputHandler = MultiblockCapability.make((Object)this, be -> be.outputHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidOutput(new IFluidTank[]{this.tanks[2]}));
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(HydrotreaterTileEntity::getShape);

    public HydrotreaterTileEntity(BlockEntityType<HydrotreaterTileEntity> type, BlockPos pWorldPosition, BlockState pBlockState) {
        super((IETemplateMultiblock)HydroTreaterMultiblock.INSTANCE, 8000, true, type, pWorldPosition, pBlockState);
        this.tanks[0].setValidator(fs -> HighPressureRefineryRecipe.hasRecipeWithInput(fs, true));
        this.tanks[1].setValidator(fs -> HighPressureRefineryRecipe.hasRecipeWithSecondaryInput(fs, true));
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.m_128469_("tank0"));
        this.tanks[1].readFromNBT(nbt.m_128469_("tank1"));
        this.tanks[2].readFromNBT(nbt.m_128469_("tank2"));
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128365_("tank0", (Tag)this.tanks[0].writeToNBT(new CompoundTag()));
        nbt.m_128365_("tank1", (Tag)this.tanks[1].writeToNBT(new CompoundTag()));
        nbt.m_128365_("tank2", (Tag)this.tanks[2].writeToNBT(new CompoundTag()));
    }

    protected HighPressureRefineryRecipe getRecipeForId(Level level, ResourceLocation id) {
        return HighPressureRefineryRecipe.recipes.get(id);
    }

    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return Energy_IN;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    public HighPressureRefineryRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return null;
    }

    public int[] getOutputTanks() {
        return new int[]{2};
    }

    public boolean additionalCanProcessCheck(MultiblockProcess<HighPressureRefineryRecipe> process) {
        int outputAmount = 0;
        for (FluidStack outputFluid : ((HighPressureRefineryRecipe)process.getRecipe(this.f_58857_)).getFluidOutputs()) {
            outputAmount += outputFluid.getAmount();
        }
        return this.tanks[2].getCapacity() >= this.tanks[2].getFluidAmount() + outputAmount;
    }

    public void doProcessOutput(ItemStack output) {
        IItemHandler handler;
        if (output == null || output.m_41619_()) {
            return;
        }
        Direction outputdir = this.getIsMirrored() ? this.getFacing().m_122427_() : this.getFacing().m_122428_();
        BlockPos outputpos = this.getBlockPosForPos(Item_OUT).m_142300_(outputdir);
        BlockEntity te = this.f_58857_.m_7702_(outputpos);
        if (te != null && (handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputdir.m_122424_()).orElse(null)) != null) {
            output = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)output, (boolean)false);
        }
        if (!output.m_41619_()) {
            Direction facing;
            double x = (double)outputpos.m_123341_() + 0.5;
            double y = (double)outputpos.m_123342_() + 0.25;
            double z = (double)outputpos.m_123343_() + 0.5;
            Direction direction = facing = this.getIsMirrored() ? this.getFacing().m_122424_() : this.getFacing();
            if (facing != Direction.EAST && facing != Direction.WEST) {
                x = (double)outputpos.m_123341_() + (facing == Direction.SOUTH ? 0.15 : 0.85);
            }
            if (facing != Direction.NORTH && facing != Direction.SOUTH) {
                z = (double)outputpos.m_123343_() + (facing == Direction.WEST ? 0.15 : 0.85);
            }
            ItemEntity ei = new ItemEntity(this.f_58857_, x, y, z, output.m_41777_());
            ei.m_20334_(0.075 * (double)outputdir.m_122429_(), 0.025, 0.075 * (double)outputdir.m_122431_());
            this.f_58857_.m_7967_((Entity)ei);
        }
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(MultiblockProcess<HighPressureRefineryRecipe> process) {
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        HighPressureRefineryRecipe recipe;
        boolean update = false;
        if (!(this.isRSDisabled() || this.energyStorage.getEnergyStored() <= 0 || this.processQueue.size() >= this.getProcessQueueMaxLength() || this.tanks[0].getFluidAmount() <= 0 && this.tanks[1].getFluidAmount() <= 0 || (recipe = HighPressureRefineryRecipe.findRecipe(this.tanks[0].getFluid(), this.tanks[1].getFluid())) == null || this.energyStorage.getEnergyStored() < recipe.getTotalProcessEnergy() || this.tanks[0].getFluidAmount() < recipe.getInputFluid().getAmount() || recipe.getSecondaryInputFluid() != null && this.tanks[1].getFluidAmount() < recipe.getSecondaryInputFluid().getAmount())) {
            int[] inputAmounts;
            int[] inputs;
            if (recipe.getSecondaryInputFluid() != null) {
                inputs = new int[]{0, 1};
                inputAmounts = new int[]{recipe.getInputFluid().getAmount(), recipe.getSecondaryInputFluid().getAmount()};
            } else {
                inputs = new int[]{0};
                inputAmounts = new int[]{recipe.getInputFluid().getAmount()};
            }
            MultiblockProcessInMachine process = new MultiblockProcessInMachine((MultiblockRecipe)recipe, this::getRecipeForId, new int[0]).setInputTanks(inputs).setInputAmounts(inputAmounts);
            if (this.addProcessToQueue((MultiblockProcess)process, true)) {
                this.addProcessToQueue((MultiblockProcess)process, false);
                update = true;
            }
        }
        if (!this.processQueue.isEmpty()) {
            update = true;
        }
        super.tickServer();
        if (this.tanks[2].getFluidAmount() > 0) {
            BlockPos outPos = this.getBlockPosForPos(Fluid_OUT).m_7494_();
            update |= FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)outPos, (Direction)Direction.DOWN).map(output -> {
                boolean ret = false;
                FluidStack target = this.tanks[2].getFluid();
                int accepted = output.fill(target = FluidHelper.copyFluid(target, Math.min(target.getAmount(), 1000)), IFluidHandler.FluidAction.SIMULATE);
                if (accepted > 0) {
                    int drained = output.fill(FluidHelper.copyFluid(target, Math.min(target.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
                    this.tanks[2].drain(new FluidStack(target.getFluid(), drained), IFluidHandler.FluidAction.EXECUTE);
                    ret = true;
                }
                return ret;
            }).orElse(false).booleanValue();
        }
        if (update) {
            this.updateMasterBlock(null, true);
        }
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(MultiblockProcess<HighPressureRefineryRecipe> process) {
        return 1.0f;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.posInMultiblock.equals((Object)Fluid_IN_A) && (side == null || side == this.getFacing().m_122424_())) {
                return this.inputAHandler.getAndCast();
            }
            if (this.posInMultiblock.equals((Object)Fluid_IN_B) && (side == null || side == Direction.UP)) {
                return this.inputBHandler.getAndCast();
            }
            if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || side == Direction.UP)) {
                return this.outputHandler.getAndCast();
            }
        }
        return super.getCapability(capability, side);
    }

    public HydrotreaterTileEntity getGuiMaster() {
        return (HydrotreaterTileEntity)this.master();
    }

    @Override
    @Nonnull
    public IPMenuProvider.BEContainerIP<? super HydrotreaterTileEntity, ?> getContainerTypeIP() {
        return IPMenuTypes.HYDROTREATER;
    }

    public boolean canUseGui(@Nonnull Player player) {
        return this.formed;
    }

    @Nonnull
    public VoxelShape getBlockBounds(CollisionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        int x = posInMultiblock.m_123341_();
        int y = posInMultiblock.m_123342_();
        int z = posInMultiblock.m_123343_();
        ArrayList<AABB> main = new ArrayList<AABB>();
        if (y == 0 && (x != 0 || z != 2) && (z != 3 || x != 1 && x != 2)) {
            main.add(new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (y == 0 && x == 0 && z == 3) {
            main.add(new AABB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
            main.add(new AABB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875));
        } else if (y == 1 && x == 0 && z == 3) {
            main.add(new AABB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        }
        if (x == 0) {
            if (y == 0) {
                if (z == 0) {
                    main.add(new AABB(0.125, 0.75, 0.5, 1.0, 1.0, 1.0));
                    main.add(new AABB(0.25, 0.5, 0.75, 0.875, 0.75, 1.0));
                }
                if (z == 1) {
                    main.add(new AABB(0.125, 0.75, 0.0, 1.0, 1.0, 1.0));
                }
                if (z == 3) {
                    main.add(new AABB(0.125, 0.75, 0.0, 1.0, 1.0, 0.25));
                }
            }
            if (y == 1) {
                if (z == 0) {
                    main.add(new AABB(0.125, 0.0, 0.5, 1.0, 0.75, 1.0));
                }
                if (z == 1) {
                    main.add(new AABB(0.125, 0.0, 0.0, 1.0, 0.75, 1.0));
                }
                if (z == 3) {
                    main.add(new AABB(0.125, 0.0, 0.0, 1.0, 0.75, 0.25));
                }
            }
        }
        if (y == 0) {
            if (z == 0) {
                if (x == 1) {
                    main.add(new AABB(0.125, 0.3125, 0.0625, 0.375, 1.0, 0.3125));
                }
                if (x == 2) {
                    main.add(new AABB(0.625, 0.3125, 0.0625, 0.875, 1.0, 0.3125));
                }
            }
            if (z == 1) {
                if (x == 1) {
                    main.add(new AABB(0.125, 0.3125, 0.875, 0.375, 1.0, 1.0));
                }
                if (x == 2) {
                    main.add(new AABB(0.625, 0.3125, 0.875, 0.875, 1.0, 1.0));
                }
            }
            if (z == 2 && x == 2) {
                main.add(new AABB(0.625, 0.3125, 0.0, 0.875, 1.0, 0.125));
            }
        }
        if (main.isEmpty()) {
            main.add(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        return main;
    }
}

