/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.survey;

import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.common.util.survey.ISurveyInfo;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SurveyScan
implements ISurveyInfo {
    public static final String TAG_KEY = "islandscan";
    public static final int SCAN_RADIUS = 32;
    public static final int SCAN_SIZE = 65;
    private static final double sqrt2048 = Math.sqrt(2048.0);
    @Nullable
    private UUID uuid;
    private int x;
    private int z;
    private byte[] data;

    public SurveyScan(CompoundTag tag) {
        this.uuid = tag.m_128403_("uuid") ? tag.m_128342_("uuid") : null;
        this.x = tag.m_128451_("x");
        this.z = tag.m_128451_("z");
        this.data = tag.m_128463_("map");
    }

    public SurveyScan(Level world, BlockPos pos) {
        this.uuid = UUID.randomUUID();
        this.x = pos.m_123341_();
        this.z = pos.m_123343_();
        this.data = this.scanArea(world, pos);
    }

    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public CompoundTag writeToStack(ItemStack stack) {
        return this.writeToTag(stack.m_41698_(TAG_KEY));
    }

    @Override
    public CompoundTag writeToTag(CompoundTag tag) {
        tag.m_128362_("uuid", UUID.randomUUID());
        tag.m_128405_("x", this.x);
        tag.m_128405_("z", this.z);
        tag.m_128382_("map", this.data);
        return tag;
    }

    private byte[] scanArea(Level world, BlockPos pos) {
        ArrayList<ReservoirIsland> islandCache = new ArrayList<ReservoirIsland>();
        byte[] scanData = new byte[4225];
        int j = -32;
        int a = 0;
        while (j <= 32) {
            int i = -32;
            int b = 0;
            while (i <= 32) {
                int x = pos.m_123341_() - i;
                int z = pos.m_123343_() - j;
                int data = 0;
                double current = ReservoirHandler.getValueOf(world, x, z);
                if (current != -1.0) {
                    ReservoirIsland nearbyIsland;
                    Optional<ReservoirIsland> optional = islandCache.stream().filter(res -> res.contains(x, z)).findFirst();
                    ReservoirIsland reservoirIsland = nearbyIsland = optional.isPresent() ? optional.get() : null;
                    if (nearbyIsland == null && (nearbyIsland = ReservoirHandler.getIslandNoCache(world, new ColumnPos(x, z))) != null) {
                        islandCache.add(nearbyIsland);
                    }
                    if (nearbyIsland != null) {
                        data = (int)Mth.m_14008_((double)(255.0 * current), (double)0.0, (double)255.0);
                    }
                }
                int noise = 31 + (int)(127.0 * Math.random());
                double blend = Math.sqrt(i * i + j * j) / sqrt2048;
                int lerped = (int)Mth.m_14085_((double)data, (double)noise, (double)blend);
                scanData[a * 65 + b] = (byte)(lerped & 0xFF);
                ++i;
                ++b;
            }
            ++j;
            ++a;
        }
        return this.normalizeScanData(scanData);
    }

    private byte[] normalizeScanData(byte[] scanData) {
        int data;
        int i;
        int max = Integer.MIN_VALUE;
        for (i = 0; i < scanData.length; ++i) {
            data = scanData[i] & 0xFF;
            if (data <= max) continue;
            max = data;
        }
        for (i = 0; i < scanData.length; ++i) {
            data = scanData[i] & 0xFF;
            scanData[i] = (byte)(255.0f * ((float)data / (float)max));
        }
        return scanData;
    }
}

