/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import mod.chiselsandbits.platforms.core.dist.Dist;
import mod.chiselsandbits.platforms.core.dist.DistExecutor;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LanguageHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    private LanguageHandler() {
    }

    public static String format(String inputKey, Object ... args) {
        String key = inputKey.toLowerCase(Locale.US);
        String result = args.length == 0 ? new TranslatableComponent(key).m_6111_() : new TranslatableComponent(key, args).m_6111_();
        return result.isEmpty() ? key : result;
    }

    public static String translateKey(String key) {
        return LanguageCache.getInstance().translateKey(key.toLowerCase(Locale.US));
    }

    public static void loadLangPath(String path) {
        LanguageCache.getInstance().load(path);
    }

    private static class LanguageCache {
        private static LanguageCache instance;
        private Map<String, String> languageMap;

        private LanguageCache() {
            String fileLoc = "assets/chiselsandbits/lang/%s.json";
            this.load("assets/chiselsandbits/lang/%s.json");
        }

        private void load(String path) {
            InputStream is;
            String defaultLocale = "en_us";
            String locale = (String)DistExecutor.unsafeCallWhenOn(Dist.CLIENT, () -> () -> Minecraft.m_91087_() == null || Minecraft.m_91087_().f_91066_ == null ? "en_us" : Minecraft.m_91087_().f_91066_.f_92075_);
            if (locale == null) {
                locale = "en_us";
            }
            if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, locale))) == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, "en_us"));
            }
            try {
                this.languageMap = (Map)new Gson().fromJson((Reader)new InputStreamReader(Objects.requireNonNull(is), StandardCharsets.UTF_8), new TypeToken<Map<String, String>>(){}.getType());
                is.close();
            }
            catch (IOException | NullPointerException e) {
                LOGGER.error("Could not load language.", (Throwable)e);
            }
        }

        private static LanguageCache getInstance() {
            return instance == null ? (instance = new LanguageCache()) : instance;
        }

        private String translateKey(String key) {
            boolean isMCloaded = false;
            if (isMCloaded) {
                return Language.m_128107_().m_6834_(key);
            }
            String res = this.languageMap.get(key);
            return res == null ? key : res;
        }
    }
}

