/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.Nullable;

public class ClientTeamManager {
    public static ClientTeamManager INSTANCE;
    public boolean invalid = false;
    private final UUID id;
    public final Map<UUID, ClientTeam> teamMap;
    public final Map<UUID, KnownClientPlayer> knownPlayers;
    public ClientTeam selfTeam;
    public KnownClientPlayer selfKnownPlayer;

    public ClientTeamManager(UUID i) {
        this.id = i;
        this.teamMap = new HashMap<UUID, ClientTeam>();
        this.knownPlayers = new HashMap<UUID, KnownClientPlayer>();
    }

    public ClientTeamManager(FriendlyByteBuf buffer, long now) {
        this(buffer.m_130259_());
        int ts = buffer.m_130242_();
        for (int i = 0; i < ts; ++i) {
            ClientTeam t = new ClientTeam(this, buffer, now);
            this.teamMap.put(t.getId(), t);
        }
        int ps = buffer.m_130242_();
        for (int i = 0; i < ps; ++i) {
            KnownClientPlayer knownClientPlayer = new KnownClientPlayer(buffer);
            this.knownPlayers.put(knownClientPlayer.uuid, knownClientPlayer);
        }
    }

    public UUID getId() {
        return this.id;
    }

    public void write(FriendlyByteBuf buffer, long now) {
        buffer.m_130077_(this.getId());
        buffer.m_130130_(this.teamMap.size());
        for (ClientTeam t : this.teamMap.values()) {
            t.write(buffer, now);
        }
        buffer.m_130130_(this.knownPlayers.size());
        for (KnownClientPlayer knownClientPlayer : this.knownPlayers.values()) {
            knownClientPlayer.write(buffer);
        }
    }

    public void init(UUID self, List<TeamMessage> messages) {
        this.selfTeam = this.teamMap.get(self);
        this.selfTeam.addMessages(messages);
        UUID userId = Minecraft.m_91087_().m_91094_().m_92548_().getId();
        this.selfKnownPlayer = this.knownPlayers.get(userId);
        if (this.selfKnownPlayer == null) {
            FTBTeams.LOGGER.warn("Local player id {} was not found in the known players list [{}]! FTB Teams will not be able to function correctly!", (Object)userId, (Object)String.join((CharSequence)",", this.knownPlayers.keySet().stream().map(UUID::toString).toList()));
        }
    }

    @Nullable
    public KnownClientPlayer getKnownPlayer(UUID id) {
        return this.knownPlayers.get(id);
    }

    @Nullable
    public ClientTeam getTeam(UUID id) {
        return this.teamMap.get(id);
    }

    public Component getName(@Nullable UUID id) {
        if (id == null || id.equals(Util.f_137441_)) {
            return new TextComponent("System").m_130940_(ChatFormatting.LIGHT_PURPLE);
        }
        KnownClientPlayer p = this.knownPlayers.get(id);
        return new TextComponent(p == null ? "Unknown" : p.name).m_130940_(ChatFormatting.YELLOW);
    }
}

