/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftbteams.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TeamProperties {
    public final Map<TeamProperty, TeamPropertyValue> map = new LinkedHashMap<TeamProperty, TeamPropertyValue>();

    public TeamProperties collect() {
        this.map.clear();
        ((Consumer)TeamEvent.COLLECT_PROPERTIES.invoker()).accept(new TeamCollectPropertiesEvent(prop -> this.map.put((TeamProperty)prop, new TeamPropertyValue(prop, prop.defaultValue))));
        return this;
    }

    public TeamProperties copy() {
        TeamProperties p = new TeamProperties();
        this.map.forEach((key, value) -> p.map.put((TeamProperty)key, value.copy()));
        return p;
    }

    public TeamProperties updateFrom(TeamProperties properties) {
        properties.map.forEach((key, value) -> this.set((TeamProperty)key, value.value));
        return this;
    }

    public <T> T get(TeamProperty<T> key) {
        TeamPropertyValue v = this.map.get(key);
        return v == null ? key.defaultValue : v.value;
    }

    public <T> void set(TeamProperty<T> key, T value) {
        this.map.computeIfAbsent(key, (Function<TeamProperty, TeamPropertyValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(dev.ftb.mods.ftbteams.property.TeamProperty<T> ), (Ldev/ftb/mods/ftbteams/property/TeamProperty;)Ldev/ftb/mods/ftbteams/property/TeamPropertyValue;)()).value = value;
    }

    public void read(FriendlyByteBuf buffer) {
        int p = buffer.m_130242_();
        this.map.clear();
        for (int i = 0; i < p; ++i) {
            TeamProperty tp = TeamPropertyType.MAP.get((Object)buffer.m_130136_((int)Short.MAX_VALUE)).deserializer.apply(buffer.m_130281_(), buffer);
            this.map.put(tp, new TeamPropertyValue(tp, tp.readValue(buffer)));
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.map.size());
        this.map.forEach((key, value) -> {
            TeamPropertyType.write(buffer, key);
            key.writeValue(buffer, value.value);
        });
    }

    public void read(CompoundTag tag) {
        tag.m_128431_().forEach(key -> {
            TeamPropertyValue<?> property = this.findValue((String)key);
            if (property != null) {
                Optional optional = property.key.fromNBT(tag.m_128423_(key));
                property.value = optional.isPresent() ? optional.get() : property.key.defaultValue;
            }
        });
    }

    @Nullable
    private TeamPropertyValue<?> findValue(String key) {
        ResourceLocation id = new ResourceLocation(key);
        return this.map.entrySet().stream().filter(entry -> ((TeamProperty)entry.getKey()).id.equals((Object)id)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public CompoundTag write(CompoundTag tag) {
        this.map.forEach((key, value) -> tag.m_128365_(key.id.toString(), key.toNBT(value.value)));
        return tag;
    }
}

