/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.EntityBearNeutral;
import dev.itsmeow.betteranimalsplus.common.entity.EntityDeer;
import dev.itsmeow.betteranimalsplus.common.entity.EntityPheasant;
import dev.itsmeow.betteranimalsplus.common.entity.ai.EntityAIEatBerries;
import dev.itsmeow.betteranimalsplus.common.entity.ai.FollowParentGoalButNotStupid;
import dev.itsmeow.betteranimalsplus.common.entity.ai.HungerNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.util.IDropHead;
import dev.itsmeow.betteranimalsplus.common.entity.util.IHaveHunger;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModLootTables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityBear
extends Animal
implements IDropHead<EntityBear>,
IHaveHunger<EntityBear> {
    private static final EntityDataAccessor<Boolean> IS_STANDING = SynchedEntityData.m_135353_(EntityBear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float clientSideStandAnimation0;
    private float clientSideStandAnimation;
    private int warningSoundTicks;
    private int hunger;

    public EntityBear(EntityType<? extends EntityBear> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BearMeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new BearPanicGoal());
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoalButNotStupid(this, 1.25, e -> !(e instanceof EntityBearNeutral)));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIEatBerries((PathfinderMob)this, 1.0, 12, 2));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new BearHurtByTargetGoal());
        this.f_21346_.m_25352_(2, (Goal)new AttackPlayerGoal());
        this.f_21346_.m_25352_(2, new HungerNearestAttackableTargetGoal<Salmon, EntityBear>(this, Salmon.class, 90, true, true, e -> true));
        this.f_21346_.m_25352_(3, new HungerNearestAttackableTargetGoal<EntityDeer, EntityBear>(this, EntityDeer.class, 90, true, true, e -> true));
        this.f_21346_.m_25352_(4, new HungerNearestAttackableTargetGoal<Pig, EntityBear>(this, Pig.class, 90, true, true, e -> true));
        this.f_21346_.m_25352_(5, new HungerNearestAttackableTargetGoal<Chicken, EntityBear>(this, Chicken.class, 90, true, true, e -> true));
        this.f_21346_.m_25352_(6, new HungerNearestAttackableTargetGoal<Rabbit, EntityBear>(this, Rabbit.class, 90, true, true, e -> true));
        this.f_21346_.m_25352_(5, new HungerNearestAttackableTargetGoal<EntityPheasant, EntityBear>(this, EntityPheasant.class, 90, true, true, e -> true));
        this.f_21346_.m_25352_(3, new HungerNearestAttackableTargetGoal<Fox, EntityBear>(this, Fox.class, 90, true, true, e -> true));
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new GroundPathNavigation((Mob)this, worldIn){

            protected void m_7636_() {
                boolean flag;
                Vec3 vector3d = this.m_7475_();
                this.f_26505_ = this.f_26494_.m_20205_() > 0.75f ? this.f_26494_.m_20205_() / 2.0f : 0.75f - this.f_26494_.m_20205_() / 2.0f;
                BlockPos vector3i = this.f_26496_.m_77400_();
                double d0 = Math.abs(this.f_26494_.m_20185_() - ((double)vector3i.m_123341_() + (double)(this.f_26494_.m_20205_() + 1.0f) / 2.0));
                double d1 = Math.abs(this.f_26494_.m_20186_() - (double)vector3i.m_123342_());
                double d2 = Math.abs(this.f_26494_.m_20189_() - ((double)vector3i.m_123343_() + (double)(this.f_26494_.m_20205_() + 1.0f) / 2.0));
                boolean bl = flag = d0 <= (double)this.f_26505_ && d2 <= (double)this.f_26505_ && d1 < 1.0;
                if (flag || this.f_26494_.m_21481_(this.f_26496_.m_77401_().f_77282_) && this.shouldTargetNextNodeInDirection(vector3d)) {
                    this.f_26496_.m_77374_();
                }
                this.m_6481_(vector3d);
            }

            private boolean shouldTargetNextNodeInDirection(Vec3 currentPosition) {
                Vec3 vector3d3;
                if (this.f_26496_.m_77399_() + 1 >= this.f_26496_.m_77398_()) {
                    return false;
                }
                Vec3 vector3d = Vec3.m_82539_((Vec3i)this.f_26496_.m_77400_());
                if (!currentPosition.m_82509_((Position)vector3d, 2.0)) {
                    return false;
                }
                Vec3 vector3d1 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77396_(this.f_26496_.m_77399_() + 1));
                Vec3 vector3d2 = vector3d1.m_82546_(vector3d);
                return vector3d2.m_82526_(vector3d3 = currentPosition.m_82546_(vector3d)) > 0.0;
            }
        };
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.writeHunger(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readHunger(compound);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_13156_) || stack.m_41720_().m_41472_() && stack.m_41720_().m_41473_().m_38746_();
    }

    public boolean isPeaceful() {
        return this.f_19853_.m_46791_() == Difficulty.PEACEFUL;
    }

    public double m_20204_() {
        return 0.6;
    }

    protected ResourceLocation m_7582_() {
        return ModLootTables.BEAR_BROWN;
    }

    protected void m_7625_(DamageSource damageSource, boolean bl) {
        super.m_7625_(damageSource, bl);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 20 == 0) {
            this.incrementHunger();
        }
        if (this.f_19853_.f_46443_) {
            if (this.clientSideStandAnimation != this.clientSideStandAnimation0) {
                this.m_6210_();
            }
            this.clientSideStandAnimation0 = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? Mth.m_14036_((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : Mth.m_14036_((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(IS_STANDING);
    }

    public void setStanding(boolean standing) {
        this.f_19804_.m_135381_(IS_STANDING, (Object)standing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStandingAnimationScale(float p_189795_1_) {
        return Mth.m_14179_((float)p_189795_1_, (float)this.clientSideStandAnimation0, (float)this.clientSideStandAnimation) / 6.0f;
    }

    protected float m_6108_() {
        return 0.97f;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        if (this.clientSideStandAnimation > 0.0f) {
            float f = this.clientSideStandAnimation / 6.0f;
            float f1 = 1.0f + f;
            return super.m_6972_(poseIn).m_20390_(1.0f, f1);
        }
        return super.m_6972_(poseIn);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_(SoundEvents.f_12285_, 1.0f, 1.0f);
            this.warningSoundTicks = 40;
        }
    }

    protected SoundEvent m_7515_() {
        return this.m_6162_() ? SoundEvents.f_12281_ : SoundEvents.f_12280_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12283_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12282_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_STANDING, (Object)false);
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source == DamageSource.f_19325_;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.doHeadDrop();
    }

    public boolean m_6785_(double range) {
        return this.despawn(range);
    }

    @Override
    public EntityBear getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<? extends EntityBear> getContainer() {
        return ModEntities.BROWN_BEAR;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)this.getContainer().getEntityType().m_20615_((Level)world);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        this.setInitialHunger();
        if (spawnDataIn instanceof GroupData) {
            this.m_146762_(-24000);
        } else {
            spawnDataIn = new GroupData();
        }
        return spawnDataIn;
    }

    class BearMeleeAttackGoal
    extends MeleeAttackGoal {
        public BearMeleeAttackGoal() {
            super((PathfinderMob)EntityBear.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
                EntityBear.this.setStanding(false);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    EntityBear.this.setStanding(false);
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    EntityBear.this.setStanding(true);
                    EntityBear.this.playWarningSound();
                }
            } else {
                this.m_25563_();
                EntityBear.this.setStanding(false);
            }
        }

        public void m_8041_() {
            EntityBear.this.setStanding(false);
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 8.0f + attackTarget.m_20205_();
        }
    }

    class BearPanicGoal
    extends PanicGoal {
        public BearPanicGoal() {
            super((PathfinderMob)EntityBear.this, 2.0);
        }

        public boolean m_8036_() {
            return (EntityBear.this.m_6162_() || EntityBear.this.m_6060_()) && super.m_8036_();
        }
    }

    class BearHurtByTargetGoal
    extends HurtByTargetGoal {
        public BearHurtByTargetGoal() {
            super((PathfinderMob)EntityBear.this, new Class[0]);
        }

        public void m_8056_() {
            super.m_8056_();
            if (EntityBear.this.m_6162_()) {
                this.m_26047_();
                this.m_8041_();
            }
        }

        protected void m_5766_(Mob mobIn, LivingEntity targetIn) {
            if (!(!(mobIn instanceof EntityBear) || mobIn.m_6162_() || targetIn instanceof Player && ((EntityBear)mobIn).isPeaceful())) {
                super.m_5766_(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        public AttackPlayerGoal() {
            super((Mob)EntityBear.this, Player.class, 0, true, true, null);
        }

        public boolean m_8036_() {
            if (EntityBear.this.isPeaceful() || EntityBear.this.m_6162_()) {
                return false;
            }
            if (super.m_8036_()) {
                for (EntityBear bear : EntityBear.this.f_19853_.m_45976_(EntityBear.class, EntityBear.this.m_142469_().m_82377_(8.0, 4.0, 8.0))) {
                    if (!bear.m_6162_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }

    static class GroupData
    implements SpawnGroupData {
        private GroupData() {
        }
    }
}

