/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import mtr.BlockEntityTypes;
import mtr.Items;
import mtr.MTR;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.IBlock;
import mtr.data.LiftInstructions;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import mtr.mappings.TickableMapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockLiftButtons
extends BlockDirectionalMapper
implements EntityBlockMapper {
    public static final BooleanProperty UNLOCKED = BooleanProperty.m_61465_((String)"unlocked");

    public BlockLiftButtons() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult hit) {
        InteractionResult result = IBlock.checkHoldingBrush(world, player, () -> {
            boolean unlocked = (Boolean)IBlock.getStatePropertySafe(state, UNLOCKED) == false;
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)UNLOCKED, (Comparable)Boolean.valueOf(unlocked)));
            player.m_5661_((Component)(unlocked ? Text.translatable("gui.mtr.lift_buttons_unlocked", new Object[0]) : Text.translatable("gui.mtr.lift_buttons_locked", new Object[0])), true);
        });
        if (world.f_46443_ || result == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_21055_(Items.LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.m_21055_(Items.LIFT_BUTTONS_LINK_REMOVER.get())) {
            return InteractionResult.PASS;
        }
        boolean unlocked = (Boolean)IBlock.getStatePropertySafe(state, UNLOCKED);
        if (unlocked) {
            double y = hit.m_82450_().f_82480_;
            LiftInstructions.addInstruction(world, pos, y - Math.floor(y) > 0.25);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_();
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext collisionContext) {
        return IBlock.getVoxelShapeByDirection(4.0, 0.0, 0.0, 12.0, 16.0, 1.0, (Direction)IBlock.getStatePropertySafe(state, f_54117_));
    }

    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityLiftButtons(pos, state);
    }

    @Override
    public <T extends BlockEntityMapper> void tick(Level world, BlockPos pos, T blockEntity) {
        TileEntityLiftButtons.tick(world, pos, blockEntity);
    }

    @Override
    public BlockEntityType<? extends BlockEntityMapper> getType() {
        return BlockEntityTypes.LIFT_BUTTONS_1_TILE_ENTITY.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, UNLOCKED});
    }

    public static class TileEntityLiftButtons
    extends BlockEntityClientSerializableMapper
    implements TickableMapper {
        private final Set<BlockPos> trackPositions = new HashSet<BlockPos>();
        private static final String KEY_TRACK_FLOOR_POS = "track_floor_pos";
        private static final int UPDATE_INTERVAL = 60;

        public TileEntityLiftButtons(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.LIFT_BUTTONS_1_TILE_ENTITY.get(), pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.trackPositions.clear();
            for (long position : compoundTag.m_128467_(KEY_TRACK_FLOOR_POS)) {
                this.trackPositions.add(BlockPos.m_122022_((long)position));
            }
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            ArrayList trackPositionsList = new ArrayList();
            this.trackPositions.forEach(position -> trackPositionsList.add(position.m_121878_()));
            compoundTag.m_128428_(KEY_TRACK_FLOOR_POS, trackPositionsList);
        }

        @Override
        public void tick() {
            TileEntityLiftButtons.tick(this.f_58857_, this.f_58858_, this);
        }

        public void registerFloor(BlockPos pos, boolean isAdd) {
            if (isAdd) {
                this.trackPositions.add(pos);
            } else {
                this.trackPositions.remove(pos);
            }
            this.m_6596_();
            this.syncData();
        }

        public void forEachTrackPosition(Level world, BiConsumer<BlockPos, BlockLiftTrackFloor.TileEntityLiftTrackFloor> callback) {
            HashSet trackPositionsToRemove = new HashSet();
            this.trackPositions.forEach(trackPosition -> {
                BlockEntity blockEntity = world.m_7702_(trackPosition);
                if (blockEntity instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor) {
                    if (callback != null) {
                        callback.accept((BlockPos)trackPosition, (BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity);
                    }
                } else {
                    trackPositionsToRemove.add(trackPosition);
                }
            });
            trackPositionsToRemove.forEach(this.trackPositions::remove);
        }

        public static <T extends BlockEntityMapper> void tick(Level world, BlockPos pos, T blockEntity) {
            if (world != null && world.m_5788_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 16.0, entity -> true) != null && blockEntity instanceof TileEntityLiftButtons && !world.f_46443_ && MTR.isGameTickInterval(60, (int)pos.m_121878_())) {
                ((TileEntityLiftButtons)blockEntity).forEachTrackPosition(world, null);
                blockEntity.m_6596_();
                ((TileEntityLiftButtons)blockEntity).syncData();
            }
        }
    }
}

