/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.IBlock;
import mtr.mappings.BlockDirectionalMapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockRubbishBin
extends BlockDirectionalMapper {
    public static final int MAX_LEVEL = 15;
    public static final IntegerProperty FILLED = IntegerProperty.m_61631_((String)"filled", (int)0, (int)15);

    public BlockRubbishBin(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FILLED, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return IBlock.getVoxelShapeByDirection(2.0, 0.0, 0.0, 14.0, 16.0, 4.5, (Direction)state.m_61143_((Property)f_54117_));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> world.m_46597_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Integer.valueOf(0))), () -> {
            int currentLevel = (Integer)IBlock.getStatePropertySafe(state, FILLED);
            if (!player.m_21205_().m_41619_() && currentLevel < 15) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Integer.valueOf(currentLevel + 1)));
                if (!player.m_7500_()) {
                    player.m_21205_().m_41774_(1);
                }
            }
        });
    }

    @Override
    public void randomTick(BlockState state, ServerLevel world, BlockPos pos) {
        int newLevel = (Integer)IBlock.getStatePropertySafe(state, FILLED) - 1;
        if (newLevel >= 0) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Integer.valueOf(newLevel)));
        }
    }

    public boolean m_6724_(BlockState blockState) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, FILLED});
    }
}

