/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.BlockEntityTypes;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityMapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockStationNameEntrance
extends BlockStationNameBase
implements IBlock {
    public static final IntegerProperty STYLE = IntegerProperty.m_61631_((String)"propagate_property", (int)0, (int)5);

    public BlockStationNameEntrance(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            world.m_46597_(pos, (BlockState)state.m_61122_((Property)STYLE));
            this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, f_54117_)).m_122427_(), (Property)STYLE, 1);
            this.propagate(world, pos, ((Direction)IBlock.getStatePropertySafe(state, f_54117_)).m_122428_(), (Property)STYLE, 1);
        });
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        return world.m_8055_(pos.m_142300_(facing)).m_60767_().m_76333_();
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction side = ctx.m_43719_();
        if (side != Direction.UP && side != Direction.DOWN) {
            return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)side.m_122424_());
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (direction.m_122424_() == ((Direction)IBlock.getStatePropertySafe(state, f_54117_)).m_122424_() && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        boolean tall = (Integer)IBlock.getStatePropertySafe(state, STYLE) % 2 == 1;
        return IBlock.getVoxelShapeByDirection(0.0, tall ? 0.0 : 4.0, 0.0, 16.0, tall ? 16.0 : 12.0, 1.0, (Direction)IBlock.getStatePropertySafe(state, f_54117_));
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityStationNameEntrance(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, STYLE});
    }

    public static class TileEntityStationNameEntrance
    extends BlockStationNameBase.TileEntityStationNameBase {
        public TileEntityStationNameEntrance(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.STATION_NAME_ENTRANCE_TILE_ENTITY.get(), pos, state, 0.0f, 0.00625f, false);
        }

        @Override
        public int getColor(BlockState state) {
            switch ((Integer)IBlock.getStatePropertySafe(state, BlockStationNameBase.COLOR)) {
                case 1: {
                    return -5592406;
                }
                case 2: {
                    return -16777216;
                }
            }
            return -1;
        }
    }
}

