/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.SoundEvents;
import mtr.block.IBlock;
import mtr.data.TicketSystem;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.Utilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockTicketBarrier
extends BlockDirectionalMapper {
    private final boolean isEntrance;
    public static final EnumProperty<TicketSystem.EnumTicketBarrierOpen> OPEN = EnumProperty.m_61587_((String)"open", TicketSystem.EnumTicketBarrierOpen.class);

    public BlockTicketBarrier(boolean isEntrance) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60953_(state -> 5).m_60955_());
        this.isEntrance = isEntrance;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.f_46443_ && entity instanceof Player) {
            Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
            Vec3 playerPosRotated = entity.m_20182_().m_82492_((double)pos.m_123341_() + 0.5, 0.0, (double)pos.m_123343_() + 0.5).m_82524_((float)Math.toRadians(facing.m_122435_()));
            TicketSystem.EnumTicketBarrierOpen open = IBlock.getStatePropertySafe(state, OPEN);
            if (open.isOpen() && playerPosRotated.f_82481_ > 0.0) {
                world.m_46597_(pos, (BlockState)state.m_61124_(OPEN, (Comparable)((Object)TicketSystem.EnumTicketBarrierOpen.CLOSED)));
            } else if (!open.isOpen() && playerPosRotated.f_82481_ < 0.0) {
                TicketSystem.EnumTicketBarrierOpen newOpen = TicketSystem.passThrough(world, pos, (Player)entity, this.isEntrance, !this.isEntrance, SoundEvents.TICKET_BARRIER, SoundEvents.TICKET_BARRIER_CONCESSIONARY, SoundEvents.TICKET_BARRIER, SoundEvents.TICKET_BARRIER_CONCESSIONARY, null, false);
                world.m_46597_(pos, (BlockState)state.m_61124_(OPEN, (Comparable)((Object)newOpen)));
                if (newOpen != TicketSystem.EnumTicketBarrierOpen.CLOSED && !world.m_183326_().m_183582_(pos, (Object)this)) {
                    Utilities.scheduleBlockTick(world, pos, (Block)this, 40);
                }
            }
        }
    }

    @Override
    public void tick(BlockState state, ServerLevel world, BlockPos pos) {
        world.m_46597_(pos, (BlockState)state.m_61124_(OPEN, (Comparable)((Object)TicketSystem.EnumTicketBarrierOpen.CLOSED)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_())).m_61124_(OPEN, (Comparable)((Object)TicketSystem.EnumTicketBarrierOpen.CLOSED));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        return IBlock.getVoxelShapeByDirection(12.0, 0.0, 0.0, 16.0, 15.0, 16.0, facing);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        TicketSystem.EnumTicketBarrierOpen open = IBlock.getStatePropertySafe(state, OPEN);
        VoxelShape base = IBlock.getVoxelShapeByDirection(15.0, 0.0, 0.0, 16.0, 24.0, 16.0, facing);
        return open.isOpen() ? base : Shapes.m_83110_((VoxelShape)IBlock.getVoxelShapeByDirection(0.0, 0.0, 7.0, 16.0, 24.0, 9.0, facing), (VoxelShape)base);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, OPEN});
    }
}

