/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mtr.BlockEntityTypes;
import mtr.block.BlockTrainSensorBase;
import mtr.mappings.BlockEntityMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTrainAnnouncer
extends BlockTrainSensorBase {
    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityTrainAnnouncer(pos, state);
    }

    public static class TileEntityTrainAnnouncer
    extends BlockTrainSensorBase.TileEntityTrainSensorBase {
        private String message = "";
        private ResourceLocation soundId;
        private final Map<Player, Long> lastAnnouncedMillis = new HashMap<Player, Long>();
        private static final int ANNOUNCE_COOL_DOWN_MILLIS = 20000;
        private static final String KEY_MESSAGE = "message";
        private static final String KEY_SOUND_ID = "sound_id";

        public TileEntityTrainAnnouncer(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.TRAIN_ANNOUNCER_TILE_ENTITY.get(), pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.message = compoundTag.m_128461_(KEY_MESSAGE);
            String soundIdString = compoundTag.m_128461_(KEY_SOUND_ID);
            this.soundId = soundIdString.isEmpty() ? null : new ResourceLocation(soundIdString);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128359_(KEY_MESSAGE, this.message);
            compoundTag.m_128359_(KEY_SOUND_ID, this.getSoundIdString());
            super.writeCompoundTag(compoundTag);
        }

        @Override
        public void setData(Set<Long> filterRouteIds, boolean stoppedOnly, boolean movingOnly, int number, String ... strings) {
            if (strings.length >= 2) {
                this.message = strings[0];
                String soundIdString = strings[1];
                this.soundId = soundIdString.isEmpty() ? null : new ResourceLocation(soundIdString);
            }
            this.setData(filterRouteIds, stoppedOnly, movingOnly);
        }

        public String getMessage() {
            return this.message;
        }

        public String getSoundIdString() {
            return this.soundId == null ? "" : this.soundId.toString();
        }

        public void announce(Player player) {
            long currentMillis = System.currentTimeMillis();
            if (!(player == null || this.lastAnnouncedMillis.containsKey(player) && currentMillis - this.lastAnnouncedMillis.get(player) < 20000L)) {
                this.lastAnnouncedMillis.put(player, System.currentTimeMillis());
                PacketTrainDataGuiServer.announceS2C((ServerPlayer)player, this.message, this.soundId);
            }
        }
    }
}

