/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.client.ClientData;
import mtr.client.DoorAnimationType;
import mtr.client.DynamicTrainModel;
import mtr.client.DynamicTrainModelLegacy;
import mtr.client.ICustomResources;
import mtr.client.IResourcePackCreatorProperties;
import mtr.client.TrainClientRegistry;
import mtr.client.TrainProperties;
import mtr.data.EnumHelper;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelSimpleTrainBase;
import mtr.model.ModelTrainBase;
import mtr.render.JonModelTrainRenderer;
import mtr.render.RenderTrains;
import mtr.sound.JonTrainSound;
import mtr.sound.bve.BveTrainSound;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.lang3.StringUtils;

public class CustomResources
implements IResourcePackCreatorProperties,
ICustomResources {
    public static final Map<String, CustomSign> CUSTOM_SIGNS = new HashMap<String, CustomSign>();
    private static final List<Consumer<ResourceManager>> RELOAD_LISTENERS = new ArrayList<Consumer<ResourceManager>>();

    public static void reload(ResourceManager manager) {
        TrainClientRegistry.reset();
        RenderTrains.clearTextureAvailability();
        ClientData.DATA_CACHE.resetFonts();
        CUSTOM_SIGNS.clear();
        ArrayList customTrains = new ArrayList();
        CustomResources.readResource(manager, "mtr:mtr_custom_resources.json", jsonConfig -> {
            try {
                jsonConfig.get("custom_trains").getAsJsonObject().entrySet().forEach(entry -> {
                    try {
                        JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                        String name = CustomResources.getOrDefault(jsonObject, "name", (String)entry.getKey(), JsonElement::getAsString);
                        int color = CustomResources.getOrDefault(jsonObject, "color", 0, jsonElement -> CustomResources.colorStringToInt(jsonElement.getAsString()));
                        String trainId = "mtr_custom_train_" + (String)entry.getKey();
                        String baseTrainType = CustomResources.getOrDefault(jsonObject, "base_train_type", "", JsonElement::getAsString);
                        TrainProperties baseTrainProperties = TrainClientRegistry.getTrainProperties(baseTrainType);
                        String description = CustomResources.getOrDefault(jsonObject, "description", baseTrainProperties.description, JsonElement::getAsString);
                        String wikipediaArticle = CustomResources.getOrDefault(jsonObject, "wikipedia_article", baseTrainProperties.wikipediaArticle, JsonElement::getAsString);
                        JonModelTrainRenderer jonRendererOrDefault = baseTrainProperties.renderer instanceof JonModelTrainRenderer ? (JonModelTrainRenderer)baseTrainProperties.renderer : new JonModelTrainRenderer(null, "", "", "");
                        JonTrainSound jonSoundOrDefault = baseTrainProperties.sound instanceof JonTrainSound ? (JonTrainSound)baseTrainProperties.sound : new JonTrainSound("", new JonTrainSound.JonTrainSoundConfig(null, 0, 0.5f, false, false));
                        String baseBveSoundBaseId = baseTrainProperties.sound instanceof BveTrainSound ? ((BveTrainSound)baseTrainProperties.sound).config.baseName : "";
                        ModelSimpleTrainBase modelSimpleTrainBase = jonRendererOrDefault.model instanceof ModelSimpleTrainBase ? (ModelSimpleTrainBase)jonRendererOrDefault.model : null;
                        String textureId = CustomResources.getOrDefault(jsonObject, "texture_id", jonRendererOrDefault.textureId, JsonElement::getAsString);
                        String gangwayConnectionId = CustomResources.getOrDefault(jsonObject, "gangway_connection_id", jonRendererOrDefault.gangwayConnectionId, JsonElement::getAsString);
                        String trainBarrierId = CustomResources.getOrDefault(jsonObject, "train_barrier_id", jonRendererOrDefault.trainBarrierId, JsonElement::getAsString);
                        DoorAnimationType doorAnimationType = EnumHelper.valueOf(modelSimpleTrainBase == null ? DoorAnimationType.STANDARD : modelSimpleTrainBase.doorAnimationType, CustomResources.getOrDefault(jsonObject, "door_animation_type", "", JsonElement::getAsString));
                        boolean renderDoorOverlay = CustomResources.getOrDefault(jsonObject, "render_door_overlay", modelSimpleTrainBase != null, JsonElement::getAsBoolean);
                        float riderOffset = CustomResources.getOrDefault(jsonObject, "rider_offset", Float.valueOf(baseTrainProperties.riderOffset), JsonElement::getAsFloat).floatValue();
                        String bveSoundBaseId = CustomResources.getOrDefault(jsonObject, "bve_sound_base_id", baseBveSoundBaseId, JsonElement::getAsString);
                        int speedSoundCount = CustomResources.getOrDefault(jsonObject, "speed_sound_count", jonSoundOrDefault.config.speedSoundCount, JsonElement::getAsInt);
                        String speedSoundBaseId = CustomResources.getOrDefault(jsonObject, "speed_sound_base_id", jonSoundOrDefault.soundId, JsonElement::getAsString);
                        String doorSoundBaseId = CustomResources.getOrDefault(jsonObject, "door_sound_base_id", jonSoundOrDefault.config.doorSoundBaseId, JsonElement::getAsString);
                        float doorCloseSoundTime = CustomResources.getOrDefault(jsonObject, "door_close_sound_time", Float.valueOf(jonSoundOrDefault.config.doorCloseSoundTime), JsonElement::getAsFloat).floatValue();
                        boolean accelSoundAtCoast = CustomResources.getOrDefault(jsonObject, "accel_sound_at_coast", jonSoundOrDefault.config.useAccelerationSoundsWhenCoasting, JsonElement::getAsBoolean);
                        boolean constPlaybackSpeed = CustomResources.getOrDefault(jsonObject, "const_playback_speed", jonSoundOrDefault.config.constantPlaybackSpeed, JsonElement::getAsBoolean);
                        boolean useBveSound = StringUtils.isEmpty((CharSequence)bveSoundBaseId) ? false : (jsonObject.has("bve_sound_base_id") ? true : (jsonObject.has("speed_sound_base_id") ? false : baseTrainProperties.sound instanceof BveTrainSound));
                        if (!baseTrainProperties.baseTrainType.isEmpty()) {
                            ModelTrainBase model = modelSimpleTrainBase == null ? jonRendererOrDefault.model : (ModelTrainBase)modelSimpleTrainBase.createNew(doorAnimationType, renderDoorOverlay);
                            String soundBaseId = useBveSound ? bveSoundBaseId : speedSoundBaseId;
                            JonTrainSound.JonTrainSoundConfig soundConfig = useBveSound ? null : new JonTrainSound.JonTrainSoundConfig(doorSoundBaseId, speedSoundCount, doorCloseSoundTime, accelSoundAtCoast, constPlaybackSpeed);
                            TrainClientRegistry.register(trainId, baseTrainType, name, description, wikipediaArticle, model, textureId, color, gangwayConnectionId, trainBarrierId, riderOffset, riderOffset, baseTrainProperties.bogiePosition, baseTrainProperties.isJacobsBogie, soundBaseId, soundConfig);
                            customTrains.add(trainId);
                        }
                        if (jsonObject.has("model") && jsonObject.has("model_properties")) {
                            CustomResources.readResource(manager, jsonObject.get("model").getAsString(), jsonModel -> CustomResources.readResource(manager, jsonObject.get("model_properties").getAsString(), jsonProperties -> {
                                IResourcePackCreatorProperties.checkSchema(jsonProperties);
                                String newBaseTrainType = String.format("%s_%s_%s", jsonProperties.get("transport_mode").getAsString(), jsonProperties.get("length").getAsInt(), jsonProperties.get("width").getAsInt());
                                String gangwayConnectionId2 = gangwayConnectionId.isEmpty() ? (CustomResources.getOrDefault(jsonObject, "has_gangway_connection", true, JsonElement::getAsBoolean).booleanValue() ? "mtr:textures/entity/sp1900" : "") : gangwayConnectionId;
                                String newBaseTrainType2 = baseTrainType.startsWith("base_") ? baseTrainType.replace("base_", "train_") : newBaseTrainType;
                                boolean useLegacy = jsonProperties.has("parts_normal");
                                ModelTrainBase model = useLegacy ? new DynamicTrainModelLegacy((JsonObject)jsonModel, (JsonObject)jsonProperties, doorAnimationType) : new DynamicTrainModel((JsonObject)jsonModel, (JsonObject)jsonProperties, doorAnimationType);
                                String soundBaseId = useBveSound ? bveSoundBaseId : speedSoundBaseId;
                                JonTrainSound.JonTrainSoundConfig soundConfig = useBveSound ? null : new JonTrainSound.JonTrainSoundConfig(doorSoundBaseId, speedSoundCount, doorCloseSoundTime, accelSoundAtCoast, constPlaybackSpeed);
                                TrainClientRegistry.register(trainId, newBaseTrainType2.toLowerCase(Locale.ENGLISH), name, description, wikipediaArticle, model, textureId, color, gangwayConnectionId2, trainBarrierId, riderOffset, riderOffset, baseTrainProperties.bogiePosition, baseTrainProperties.isJacobsBogie, soundBaseId, soundConfig);
                                customTrains.add(trainId);
                            }));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                jsonConfig.get("custom_signs").getAsJsonObject().entrySet().forEach(entry -> {
                    try {
                        JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                        boolean flipTexture = CustomResources.getOrDefault(jsonObject, "flip_texture", false, JsonElement::getAsBoolean);
                        String customText = CustomResources.getOrDefault(jsonObject, "custom_text", "", JsonElement::getAsString);
                        boolean flipCustomText = CustomResources.getOrDefault(jsonObject, "flip_custom_text", false, JsonElement::getAsBoolean);
                        boolean small = CustomResources.getOrDefault(jsonObject, "small", false, JsonElement::getAsBoolean);
                        int backgroundColor = CustomResources.getOrDefault(jsonObject, "background_color", 0, jsonElement -> CustomResources.colorStringToInt(jsonElement.getAsString()));
                        CUSTOM_SIGNS.put("mtr_custom_sign_" + (String)entry.getKey(), new CustomSign(new ResourceLocation(jsonObject.get("texture_id").getAsString()), flipTexture, customText, flipCustomText, small, backgroundColor));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        RELOAD_LISTENERS.forEach(resourceManagerConsumer -> resourceManagerConsumer.accept(manager));
        System.out.println("Loaded " + customTrains.size() + " custom train(s)");
        customTrains.forEach(System.out::println);
        System.out.println("Loaded " + CUSTOM_SIGNS.size() + " custom sign(s)");
        CUSTOM_SIGNS.keySet().forEach(System.out::println);
    }

    public static int colorStringToInt(String string) {
        try {
            return Integer.parseInt(string.toUpperCase(Locale.ENGLISH).replaceAll("[^\\dA-F]", ""), 16);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private static void readResource(ResourceManager manager, String path, Consumer<JsonObject> callback) {
        try {
            UtilitiesClient.getResources(manager, new ResourceLocation(path)).forEach(resource -> {
                try (InputStream stream = Utilities.getInputStream(resource);){
                    callback.accept(new JsonParser().parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Utilities.closeResource(resource);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static <T> T getOrDefault(JsonObject jsonObject, String key, T defaultValue, Function<JsonElement, T> function) {
        if (jsonObject.has(key)) {
            return function.apply(jsonObject.get(key));
        }
        return defaultValue;
    }

    public static void registerReloadListener(Consumer<ResourceManager> listener) {
        RELOAD_LISTENERS.add(listener);
    }

    public static class CustomSign {
        public final ResourceLocation textureId;
        public final boolean flipTexture;
        public final String customText;
        public final boolean flipCustomText;
        public final boolean small;
        public final int backgroundColor;

        public CustomSign(ResourceLocation textureId, boolean flipTexture, String customText, boolean flipCustomText, boolean small, int backgroundColor) {
            this.textureId = textureId;
            this.flipTexture = flipTexture;
            this.customText = customText;
            this.flipCustomText = flipCustomText;
            this.small = small;
            this.backgroundColor = backgroundColor;
        }

        public boolean hasCustomText() {
            return !this.customText.isEmpty();
        }
    }
}

