/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import mtr.client.DoorAnimationType;
import mtr.client.DynamicTrainModel;
import mtr.client.DynamicTrainModelLegacy;
import mtr.client.ICustomResources;
import mtr.client.IResourcePackCreatorProperties;
import mtr.data.EnumHelper;
import mtr.data.IGui;
import mtr.data.TransportMode;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelTrainBase;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ResourcePackCreatorProperties
implements IResourcePackCreatorProperties,
ICustomResources,
IGui {
    private String customTrainId = "my_custom_train_id";
    private String modelFileName = "";
    private JsonObject modelObject = new JsonObject();
    private DynamicTrainModel model;
    private String propertiesFileName = "";
    private JsonObject propertiesObject = new JsonObject();
    private String textureFileName = "";
    private Path textureFilePath;
    private ResourceLocation texture;
    private final JsonObject customResourcesObject = new JsonObject();

    public ResourcePackCreatorProperties() {
        IResourcePackCreatorProperties.checkSchema(this.propertiesObject);
        ICustomResources.createCustomTrainSchema(this.customResourcesObject, this.customTrainId, "My Custom Train Name", "My Custom Train Description", "", "000000", "", "", DoorAnimationType.STANDARD.toString(), false, 0.0f);
    }

    public void loadModelFile(Path path) {
        ResourcePackCreatorProperties.readJson(path, (fileName, jsonObject) -> {
            this.modelFileName = fileName;
            jsonObject.remove("textures");
            this.modelObject = jsonObject;
            this.updateModel();
        });
    }

    public void loadPropertiesFile(Path path) {
        ResourcePackCreatorProperties.readJson(path, (fileName, jsonObject) -> {
            this.propertiesFileName = fileName;
            DynamicTrainModelLegacy.migrateOldSchema(jsonObject);
            IResourcePackCreatorProperties.checkSchema(jsonObject);
            this.propertiesObject = jsonObject;
            this.updateModel();
        });
    }

    public void loadTextureFile(Path path) {
        Minecraft minecraft = Minecraft.m_91087_();
        try {
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)Files.newInputStream(path, StandardOpenOption.READ));
            this.texture = minecraft.m_91097_().m_118490_("mtr", new DynamicTexture(nativeImage));
            this.textureFileName = path.getFileName().toString();
            this.textureFilePath = path;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void editCustomResourcesId(String id) {
        String name = this.getCustomTrainObject().get("name").getAsString();
        String description = this.getCustomTrainObject().get("description").getAsString();
        String wikipediaArticle = this.getCustomTrainObject().get("wikipedia_article").getAsString();
        String color = this.getCustomTrainObject().get("color").getAsString();
        String gangwayConnectionId = this.getCustomTrainObject().get("gangway_connection_id").getAsString();
        String trainBarrierId = this.getCustomTrainObject().get("train_barrier_id").getAsString();
        String doorAnimationType = this.getCustomTrainObject().get("door_animation_type").getAsString();
        float riderOffset = this.getCustomTrainObject().get("rider_offset").getAsFloat();
        this.customTrainId = id;
        ICustomResources.createCustomTrainSchema(this.customResourcesObject, id, name, description, wikipediaArticle, color, gangwayConnectionId, trainBarrierId, doorAnimationType, false, riderOffset);
    }

    public void editCustomResourcesName(String name) {
        this.getCustomTrainObject().addProperty("name", name);
    }

    public void editCustomResourcesColor(int color) {
        this.getCustomTrainObject().addProperty("color", Integer.toHexString(color & 0xFFFFFF).toUpperCase(Locale.ENGLISH));
    }

    public void editCustomResourcesGangwayConnectionId(String gangwayConnectionId) {
        this.getCustomTrainObject().addProperty("gangway_connection_id", gangwayConnectionId);
    }

    public void editCustomResourcesTrainBarrierId(String trainBarrierId) {
        this.getCustomTrainObject().addProperty("train_barrier_id", trainBarrierId);
    }

    public void editDoorAnimationType() {
        ResourcePackCreatorProperties.cycleEnumProperty((JsonObject)this.getCustomTrainObject(), (String)"door_animation_type", (Enum)DoorAnimationType.STANDARD, (Enum[])DoorAnimationType.values());
        this.updateModel();
    }

    public void editCustomResourcesRiderOffset(float riderOffset) {
        this.getCustomTrainObject().addProperty("rider_offset", (Number)Float.valueOf(riderOffset));
    }

    public void editTransportMode() {
        ResourcePackCreatorProperties.cycleEnumProperty((JsonObject)this.propertiesObject, (String)"transport_mode", (Enum)TransportMode.TRAIN, (Enum[])TransportMode.values());
        this.updateModel();
    }

    public void editLength(int length) {
        this.propertiesObject.addProperty("length", (Number)length);
        this.updateModel();
    }

    public void editWidth(int width) {
        this.propertiesObject.addProperty("width", (Number)width);
        this.updateModel();
    }

    public void editDoorMax(int doorMax) {
        this.propertiesObject.addProperty("door_max", (Number)doorMax);
        this.updateModel();
    }

    public void addPart(String partName) {
        JsonObject partsObject = new JsonObject();
        partsObject.addProperty("name", partName);
        partsObject.addProperty("stage", ModelTrainBase.RenderStage.EXTERIOR.toString());
        partsObject.addProperty("mirror", Boolean.valueOf(false));
        partsObject.addProperty("skip_rendering_if_too_far", Boolean.valueOf(false));
        partsObject.addProperty("door_offset", DoorOffset.NONE.toString());
        partsObject.addProperty("render_condition", RenderCondition.ALL.toString());
        JsonArray positionsArray = new JsonArray();
        JsonArray positionPairArray = new JsonArray();
        positionPairArray.add((Number)0);
        positionPairArray.add((Number)0);
        positionsArray.add((JsonElement)positionPairArray);
        partsObject.add("positions", (JsonElement)positionsArray);
        partsObject.addProperty("whitelisted_cars", "");
        partsObject.addProperty("blacklisted_cars", "");
        this.propertiesObject.getAsJsonArray("parts").add((JsonElement)partsObject);
        this.updateModel();
    }

    public void removePart(int index) {
        this.getPartFromIndex(index, partObject -> this.propertiesObject.getAsJsonArray("parts").remove(index));
        this.updateModel();
    }

    public void editPartRenderStage(int index) {
        this.getPartFromIndex(index, partObject -> ResourcePackCreatorProperties.cycleEnumProperty((JsonObject)partObject, (String)"stage", (Enum)ModelTrainBase.RenderStage.EXTERIOR, (Enum[])ModelTrainBase.RenderStage.values()));
        this.updateModel();
    }

    public void editPartMirror(int index, boolean mirror) {
        this.getPartFromIndex(index, partObject -> partObject.addProperty("mirror", Boolean.valueOf(mirror)));
        this.updateModel();
    }

    public void editPartSkipRenderingIfTooFar(int index, boolean mirror) {
        this.getPartFromIndex(index, partObject -> partObject.addProperty("skip_rendering_if_too_far", Boolean.valueOf(mirror)));
        this.updateModel();
    }

    public void editPartDoorOffset(int index) {
        this.getPartFromIndex(index, partObject -> ResourcePackCreatorProperties.cycleEnumProperty((JsonObject)partObject, (String)"door_offset", (Enum)DoorOffset.NONE, (Enum[])DoorOffset.values()));
        this.updateModel();
    }

    public void editPartRenderCondition(int index) {
        this.getPartFromIndex(index, partObject -> ResourcePackCreatorProperties.cycleEnumProperty((JsonObject)partObject, (String)"render_condition", (Enum)RenderCondition.ALL, (Enum[])RenderCondition.values()));
        this.updateModel();
    }

    public void editPartPositions(int index, String positions) {
        JsonArray positionsArray = new JsonArray();
        String[] positionsSplit = positions.replaceAll("[^\\d.,\\-]", "").split(",");
        for (int i = 1; i < positionsSplit.length; i += 2) {
            try {
                float x = Float.parseFloat(positionsSplit[i - 1]);
                float z = Float.parseFloat(positionsSplit[i]);
                JsonArray positionPairArray = new JsonArray();
                positionPairArray.add((Number)Float.valueOf(x));
                positionPairArray.add((Number)Float.valueOf(z));
                positionsArray.add((JsonElement)positionPairArray);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getPartFromIndex(index, partObject -> partObject.add("positions", (JsonElement)positionsArray));
        this.updateModel();
    }

    public void editPartWhitelistedCars(int index, String whitelistedCars) {
        this.getPartFromIndex(index, partObject -> partObject.addProperty("whitelisted_cars", ResourcePackCreatorProperties.formatCarExpression(whitelistedCars)));
        this.updateModel();
    }

    public void editPartBlacklistedCars(int index, String blacklistedCars) {
        this.getPartFromIndex(index, partObject -> partObject.addProperty("blacklisted_cars", ResourcePackCreatorProperties.formatCarExpression(blacklistedCars)));
        this.updateModel();
    }

    public void render(PoseStack matrices, int currentCar, int trainCars, boolean head1IsFront, float leftDoorValue, float rightDoorValue, boolean opening, int light) {
        if (this.model != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            MultiBufferSource.BufferSource immediate = minecraft.m_91269_().m_110104_();
            this.model.render(matrices, (MultiBufferSource)immediate, null, this.texture == null ? new ResourceLocation("mtr:textures/block/white.png") : this.texture, light, leftDoorValue, rightDoorValue, opening, currentCar, trainCars, head1IsFront, true, false, true, false);
            immediate.m_109911_();
        }
    }

    public JsonObject getCustomTrainObject() {
        return this.customResourcesObject.getAsJsonObject("custom_trains").getAsJsonObject(this.customTrainId);
    }

    public JsonArray getModelPartsArray() {
        return this.modelObject.has("outliner") ? this.modelObject.getAsJsonArray("outliner") : new JsonArray();
    }

    public String getTransportMode() {
        return this.propertiesObject.get("transport_mode").getAsString();
    }

    public int getLength() {
        return this.propertiesObject.get("length").getAsInt();
    }

    public int getWidth() {
        return this.propertiesObject.get("width").getAsInt();
    }

    public int getDoorMax() {
        return this.propertiesObject.get("door_max").getAsInt();
    }

    public String getDoorAnimationType() {
        return this.getCustomTrainObject().get("door_animation_type").getAsString();
    }

    public JsonArray getPropertiesPartsArray() {
        return this.propertiesObject.getAsJsonArray("parts");
    }

    public String getCustomTrainId() {
        return this.customTrainId;
    }

    public String getModelFileName() {
        return this.modelFileName;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public String getTextureFileName() {
        return this.textureFileName;
    }

    public void export() {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            File resourcePackDirectory = UtilitiesClient.getResourcePackDirectory(minecraft);
            FileOutputStream fileOutputStream = new FileOutputStream(String.format("%s/%s_%s.zip", resourcePackDirectory.toString(), this.customTrainId, ZonedDateTime.now(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("uuuu_MM_dd_HH_mm_ss"))));
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            this.writeToZip(zipOutputStream, "pack.mcmeta", "{\"pack\":{\"pack_format\":6,\"description\":\"Minecraft Transit Railway\\n" + this.getCustomTrainObject().get("name").getAsString() + "\"}}");
            this.writeToZip(zipOutputStream, String.format("assets/mtr/%s.json", "mtr_custom_resources"), this.customResourcesObject.toString());
            this.writeToZip(zipOutputStream, String.format("assets/mtr/%s/%s.bbmodel", this.customTrainId, this.customTrainId), this.modelObject.toString());
            this.writeToZip(zipOutputStream, String.format("assets/mtr/%s/%s.json", this.customTrainId, this.customTrainId), this.propertiesObject.toString());
            this.writeToZip(zipOutputStream, String.format("assets/mtr/%s/%s.png", this.customTrainId, this.customTrainId), Files.newInputStream(this.textureFilePath, new OpenOption[0]));
            zipOutputStream.close();
            fileOutputStream.close();
            Util.m_137581_().m_137644_(resourcePackDirectory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeToZip(ZipOutputStream zipOutputStream, String fileName, String content) throws IOException {
        this.writeToZip(zipOutputStream, fileName, new ByteArrayInputStream(content.getBytes()));
    }

    private void writeToZip(ZipOutputStream zipOutputStream, String fileName, InputStream inputStream) throws IOException {
        int length;
        zipOutputStream.putNextEntry(new ZipEntry(fileName));
        byte[] bytes = new byte[1024];
        while ((length = inputStream.read(bytes)) >= 0) {
            zipOutputStream.write(bytes, 0, length);
        }
        inputStream.close();
    }

    private void updateModel() {
        try {
            this.model = new DynamicTrainModel(this.modelObject, this.propertiesObject, EnumHelper.valueOf(DoorAnimationType.STANDARD, this.getCustomTrainObject().get("door_animation_type").getAsString()));
        }
        catch (Exception ignored) {
            this.model = null;
        }
    }

    private void getPartFromIndex(int index, Consumer<JsonObject> callback) {
        JsonArray jsonArray = this.propertiesObject.getAsJsonArray("parts");
        if (index >= 0 && index < jsonArray.size()) {
            callback.accept(jsonArray.get(index).getAsJsonObject());
        }
    }

    private static <T extends Enum<T>> void cycleEnumProperty(JsonObject jsonObject, String key, T defaultValue, T[] enumValues) {
        T enumValue = EnumHelper.valueOf(defaultValue, jsonObject.get(key).getAsString());
        jsonObject.addProperty(key, ((Enum)enumValues[(enumValue.ordinal() + 1) % enumValues.length]).toString());
    }

    private static void readJson(Path path, BiConsumer<String, JsonObject> jsonCallback) {
        try {
            jsonCallback.accept(path.getFileName().toString(), new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(path))).getAsJsonObject());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String formatCarExpression(String expression) {
        Matcher matcher = Pattern.compile("%\\d+(\\+\\d+)*|-?\\d+").matcher(expression);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            result.append(matcher.group()).append(",");
        }
        String resultString = result.toString();
        return resultString.endsWith(",") ? resultString.substring(0, resultString.length() - 1) : resultString;
    }

    public static enum DoorOffset {
        NONE,
        LEFT_POSITIVE,
        RIGHT_POSITIVE,
        LEFT_NEGATIVE,
        RIGHT_NEGATIVE;

    }

    public static enum RenderCondition {
        ALL,
        DOORS_OPEN,
        DOORS_CLOSED,
        DOOR_LEFT_OPEN,
        DOOR_RIGHT_OPEN,
        DOOR_LEFT_CLOSED,
        DOOR_RIGHT_CLOSED,
        MOVING_FORWARDS,
        MOVING_BACKWARDS;

    }
}

