/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.msgpack.value.Value;

public class MessagePackHelper {
    private final Map<String, Value> map;

    public MessagePackHelper(Map<String, Value> map) {
        this.map = map;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getOrDefault(key, defaultValue, value -> value.asBooleanValue().getBoolean());
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        return this.getOrDefault(key, defaultValue, value -> value.asIntegerValue().asInt());
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        return this.getOrDefault(key, defaultValue, value -> value.asIntegerValue().asLong());
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getOrDefault(key, Float.valueOf(defaultValue), value -> Float.valueOf(value.asFloatValue().toFloat())).floatValue();
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        return this.getOrDefault(key, defaultValue, value -> value.asFloatValue().toDouble());
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String defaultValue) {
        return this.getOrDefault(key, defaultValue, value -> value.asStringValue().asString());
    }

    public void iterateArrayValue(String key, Consumer<Value> consumer) {
        if (this.map.containsKey(key)) {
            this.map.get(key).asArrayValue().forEach(consumer);
        }
    }

    public void iterateMapValue(String key, Consumer<Map.Entry<Value, Value>> consumer) {
        if (this.map.containsKey(key)) {
            this.map.get(key).asMapValue().entrySet().forEach(consumer);
        }
    }

    private <T> T getOrDefault(String key, T defaultValue, Function<Value, T> function) {
        return this.map.containsKey(key) ? function.apply(this.map.get(key)) : defaultValue;
    }
}

