/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataModuleBase;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RailwayDataRailActionsModule
extends RailwayDataModuleBase {
    private final List<Rail.RailActions> railActions = new ArrayList<Rail.RailActions>();

    public RailwayDataRailActionsModule(RailwayData railwayData, Level world, Map<BlockPos, Map<BlockPos, Rail>> rails) {
        super(railwayData, world, rails);
    }

    public void tick() {
        if (!this.railActions.isEmpty() && this.railActions.get(0).build()) {
            this.railActions.remove(0);
            PacketTrainDataGuiServer.updateRailActionsS2C(this.world, this.railActions);
        }
    }

    public boolean markRailForBridge(Player player, BlockPos pos1, BlockPos pos2, int radius, BlockState state) {
        if (this.railwayData.containsRail(pos1, pos2)) {
            this.railActions.add(new Rail.RailActions(this.world, player, Rail.RailActionType.BRIDGE, (Rail)((Map)this.rails.get(pos1)).get(pos2), radius, 0, state));
            PacketTrainDataGuiServer.updateRailActionsS2C(this.world, this.railActions);
            return true;
        }
        return false;
    }

    public boolean markRailForTunnel(Player player, BlockPos pos1, BlockPos pos2, int radius, int height) {
        if (this.railwayData.containsRail(pos1, pos2)) {
            this.railActions.add(new Rail.RailActions(this.world, player, Rail.RailActionType.TUNNEL, (Rail)((Map)this.rails.get(pos1)).get(pos2), radius, height, null));
            PacketTrainDataGuiServer.updateRailActionsS2C(this.world, this.railActions);
            return true;
        }
        return false;
    }

    public boolean markRailForTunnelWall(Player player, BlockPos pos1, BlockPos pos2, int radius, int height, BlockState state) {
        if (this.railwayData.containsRail(pos1, pos2)) {
            this.railActions.add(new Rail.RailActions(this.world, player, Rail.RailActionType.TUNNEL_WALL, (Rail)((Map)this.rails.get(pos1)).get(pos2), radius + 1, height + 1, state));
            PacketTrainDataGuiServer.updateRailActionsS2C(this.world, this.railActions);
            return true;
        }
        return false;
    }

    public void removeRailAction(long id) {
        this.railActions.removeIf(railAction -> railAction.id == id);
        PacketTrainDataGuiServer.updateRailActionsS2C(this.world, this.railActions);
    }
}

