/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.math.NumberUtils;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public abstract class SavedRailBase
extends NameColorDataBase {
    protected int dwellTime;
    private final Set<BlockPos> positions;
    public static final int MAX_DWELL_TIME = 1200;
    private static final int DEFAULT_DWELL_TIME = 20;
    private static final String KEY_POS_1 = "pos_1";
    private static final String KEY_POS_2 = "pos_2";
    private static final String KEY_DWELL_TIME = "dwell_time";

    public SavedRailBase(long id, TransportMode transportMode, BlockPos pos1, BlockPos pos2) {
        super(id, transportMode);
        this.name = "1";
        this.positions = new HashSet<BlockPos>(2);
        this.positions.add(pos1);
        this.positions.add(pos2);
        this.dwellTime = transportMode.continuousMovement ? 1 : 20;
    }

    public SavedRailBase(TransportMode transportMode, BlockPos pos1, BlockPos pos2) {
        super(transportMode);
        this.name = "1";
        this.positions = new HashSet<BlockPos>(2);
        this.positions.add(pos1);
        this.positions.add(pos2);
        this.dwellTime = transportMode.continuousMovement ? 1 : 20;
    }

    public SavedRailBase(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.positions = new HashSet<BlockPos>(2);
        this.positions.add(BlockPos.m_122022_((long)messagePackHelper.getLong(KEY_POS_1)));
        this.positions.add(BlockPos.m_122022_((long)messagePackHelper.getLong(KEY_POS_2)));
        this.dwellTime = this.transportMode.continuousMovement ? 1 : messagePackHelper.getInt(KEY_DWELL_TIME);
    }

    @Deprecated
    public SavedRailBase(CompoundTag compoundTag) {
        super(compoundTag);
        this.positions = new HashSet<BlockPos>(2);
        this.positions.add(BlockPos.m_122022_((long)compoundTag.m_128454_(KEY_POS_1)));
        this.positions.add(BlockPos.m_122022_((long)compoundTag.m_128454_(KEY_POS_2)));
        this.dwellTime = this.transportMode.continuousMovement ? 1 : compoundTag.m_128451_(KEY_DWELL_TIME);
    }

    public SavedRailBase(FriendlyByteBuf packet) {
        super(packet);
        this.positions = new HashSet<BlockPos>(2);
        this.positions.add(packet.m_130135_());
        this.positions.add(packet.m_130135_());
        this.dwellTime = packet.readInt();
        this.dwellTime = this.transportMode.continuousMovement ? 1 : this.dwellTime;
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_POS_1).packLong(this.getPosition(0).m_121878_());
        messagePacker.packString(KEY_POS_2).packLong(this.getPosition(1).m_121878_());
        messagePacker.packString(KEY_DWELL_TIME).packInt(this.dwellTime);
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 3;
    }

    @Override
    public void writePacket(FriendlyByteBuf packet) {
        super.writePacket(packet);
        packet.m_130064_(this.getPosition(0));
        packet.m_130064_(this.getPosition(1));
        packet.writeInt(this.dwellTime);
    }

    @Override
    protected final boolean hasTransportMode() {
        return true;
    }

    public boolean containsPos(BlockPos pos) {
        return this.positions.contains(pos);
    }

    public BlockPos getMidPos() {
        return this.getMidPos(false);
    }

    public BlockPos getMidPos(boolean zeroY) {
        BlockPos pos = this.getPosition(0).m_141952_((Vec3i)this.getPosition(1));
        return new BlockPos(pos.m_123341_() / 2, zeroY ? 0 : pos.m_123342_() / 2, pos.m_123343_() / 2);
    }

    public Direction.Axis getAxis() {
        BlockPos difference = this.getPosition(0).m_141950_((Vec3i)this.getPosition(1));
        return Math.abs(difference.m_123341_()) > Math.abs(difference.m_123343_()) ? Direction.Axis.X : Direction.Axis.Z;
    }

    public boolean isInvalidSavedRail(Map<BlockPos, Map<BlockPos, Rail>> rails) {
        BlockPos pos2;
        BlockPos pos1 = this.getPosition(0);
        return SavedRailBase.isInvalidSavedRail(rails, pos1, pos2 = this.getPosition(1)) || SavedRailBase.isInvalidSavedRail(rails, pos2, pos1);
    }

    public boolean isCloseToSavedRail(BlockPos pos, int radius, int lower, int upper) {
        BlockPos pos1 = this.getPosition(0);
        BlockPos pos2 = this.getPosition(1);
        int x1 = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int y1 = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int z1 = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int x2 = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int y2 = Math.max(pos1.m_123342_(), pos2.m_123342_());
        int z2 = Math.max(pos1.m_123343_(), pos2.m_123343_());
        return new AABB((double)(x1 - radius), (double)(y1 - lower), (double)(z1 - radius), (double)(x2 + radius + 1), (double)(y2 + upper + 1), (double)(z2 + radius + 1)).m_82393_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public List<BlockPos> getOrderedPositions(BlockPos pos, boolean reverse) {
        BlockPos pos1 = this.getPosition(0);
        BlockPos pos2 = this.getPosition(1);
        double d1 = pos1.m_123331_((Vec3i)pos);
        double d2 = pos2.m_123331_((Vec3i)pos);
        ArrayList<BlockPos> orderedPositions = new ArrayList<BlockPos>();
        if (d2 > d1 == reverse) {
            orderedPositions.add(pos2);
            orderedPositions.add(pos1);
        } else {
            orderedPositions.add(pos1);
            orderedPositions.add(pos2);
        }
        return orderedPositions;
    }

    public BlockPos getOtherPosition(BlockPos pos) {
        BlockPos pos1 = this.getPosition(0);
        BlockPos pos2 = this.getPosition(1);
        return pos.equals((Object)pos1) ? pos2 : pos1;
    }

    public int getDwellTime() {
        if (this.dwellTime <= 0 || this.dwellTime > 1200) {
            this.dwellTime = 20;
        }
        return this.transportMode.continuousMovement ? 1 : this.dwellTime;
    }

    protected void writeDwellTimePacket(FriendlyByteBuf packet, int newDwellTime) {
        this.dwellTime = this.transportMode.continuousMovement ? 1 : (newDwellTime <= 0 || newDwellTime > 1200 ? 20 : newDwellTime);
        packet.writeInt(this.dwellTime);
    }

    private BlockPos getPosition(int index) {
        return this.positions.size() > index ? new ArrayList<BlockPos>(this.positions).get(index) : new BlockPos(0, 0, 0);
    }

    public static boolean isInvalidSavedRail(Map<BlockPos, Map<BlockPos, Rail>> rails, BlockPos pos1, BlockPos pos2) {
        return !RailwayData.containsRail(rails, pos1, pos2) || !rails.get((Object)pos1).get((Object)pos2).railType.hasSavedRail;
    }

    @Override
    public int compareTo(NameColorDataBase compare) {
        boolean thisIsNumber = NumberUtils.isParsable((String)this.name);
        boolean compareIsNumber = NumberUtils.isParsable((String)compare.name);
        if (thisIsNumber && compareIsNumber) {
            int floatCompare = Float.compare(Float.parseFloat(this.name), Float.parseFloat(compare.name));
            return floatCompare == 0 ? super.compareTo(compare) : floatCompare;
        }
        if (thisIsNumber) {
            return -1;
        }
        if (compareIsNumber) {
            return 1;
        }
        return super.compareTo(compare);
    }
}

