/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.Rail;
import mtr.data.RailwayData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.DyeColor;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public class SignalBlocks {
    private final Map<UUID, Set<SignalBlock>> railToSignalBlocks = new HashMap<UUID, Set<SignalBlock>>();
    public final List<SignalBlock> signalBlocks = new ArrayList<SignalBlock>();

    public long add(long id, DyeColor color, UUID rail) {
        ArrayList connectedSignalBlocks = new ArrayList();
        this.signalBlocks.forEach(signalBlock -> {
            if (signalBlock.color == color && signalBlock.isConnected(rail)) {
                connectedSignalBlocks.add(signalBlock);
            }
        });
        if (connectedSignalBlocks.isEmpty()) {
            SignalBlock newSignalBlock = new SignalBlock(id, color, rail);
            this.signalBlocks.add(newSignalBlock);
            this.writeCache();
            return newSignalBlock.id;
        }
        Collections.sort(connectedSignalBlocks);
        SignalBlock firstSignalBlock = (SignalBlock)connectedSignalBlocks.remove(0);
        firstSignalBlock.rails.add(rail);
        connectedSignalBlocks.forEach(signalBlock -> firstSignalBlock.rails.addAll(signalBlock.rails));
        this.signalBlocks.removeIf(connectedSignalBlocks::contains);
        this.writeCache();
        return 0L;
    }

    public long remove(long id, DyeColor color, UUID rail) {
        SignalBlock connectedSignalBlock = null;
        for (SignalBlock signalBlock : this.signalBlocks) {
            if (signalBlock.color != color || !signalBlock.isConnected(rail)) continue;
            connectedSignalBlock = signalBlock;
            break;
        }
        if (connectedSignalBlock != null) {
            this.signalBlocks.remove(connectedSignalBlock);
            connectedSignalBlock.rails.remove(rail);
            if (!connectedSignalBlock.rails.isEmpty()) {
                ArrayList<UUID> rails = new ArrayList<UUID>(connectedSignalBlock.rails);
                Collections.sort(rails);
                this.add(connectedSignalBlock.id, color, (UUID)rails.remove(0));
                long returnId = 0L;
                for (UUID existingRail : rails) {
                    long newId = this.add(id, color, existingRail);
                    if (newId == connectedSignalBlock.id) continue;
                    returnId = newId;
                }
                this.writeCache();
                return returnId;
            }
        }
        this.writeCache();
        return 0L;
    }

    public void occupy(UUID currentRail, List<Map<UUID, Long>> trainPositions, long trainId) {
        if (trainPositions.size() < 2) {
            return;
        }
        HashSet<UUID> railsToAdd = new HashSet<UUID>();
        railsToAdd.add(currentRail);
        if (this.railToSignalBlocks.containsKey(currentRail)) {
            this.railToSignalBlocks.get(currentRail).forEach(signalBlock -> {
                railsToAdd.addAll(signalBlock.rails);
                signalBlock.occupied = 2;
            });
        }
        for (Map<UUID, Long> trainPositionsMap : trainPositions) {
            if (!railsToAdd.stream().anyMatch(rail -> trainPositionsMap.containsKey(rail) && (Long)trainPositionsMap.get(rail) != trainId)) continue;
            return;
        }
        railsToAdd.forEach(rail -> ((Map)trainPositions.get(1)).put(rail, trainId));
    }

    public void resetOccupied() {
        this.signalBlocks.forEach(signalBlock -> {
            if (signalBlock.isOccupied()) {
                --signalBlock.occupied;
            }
        });
    }

    public List<SignalBlock> getSignalBlocksAtTrack(UUID rail) {
        if (this.railToSignalBlocks.containsKey(rail)) {
            ArrayList<SignalBlock> matchingSignalBlocks = new ArrayList<SignalBlock>((Collection)this.railToSignalBlocks.get(rail));
            matchingSignalBlocks.sort(Comparator.comparingInt(signalBlock -> signalBlock.color.ordinal()));
            return matchingSignalBlocks;
        }
        return new ArrayList<SignalBlock>();
    }

    public boolean isOccupied(UUID rail) {
        if (this.railToSignalBlocks.containsKey(rail)) {
            return this.railToSignalBlocks.get(rail).stream().anyMatch(SignalBlock::isOccupied);
        }
        return false;
    }

    public void getSignalBlockStatus(Map<Long, Boolean> signalBlockStatus, UUID rail) {
        if (this.railToSignalBlocks.containsKey(rail)) {
            this.railToSignalBlocks.get(rail).forEach(signalBlock -> signalBlockStatus.put(signalBlock.id, signalBlock.isOccupied()));
        }
    }

    public void writeSignalBlockStatus(Map<Long, Boolean> signalBlockStatus) {
        signalBlockStatus.forEach((id, occupied) -> this.signalBlocks.forEach(signalBlock -> {
            if (signalBlock.id == id) {
                signalBlock.occupied = occupied != false ? 2 : 0;
            }
        }));
    }

    public FriendlyByteBuf getValidationPacket(Map<BlockPos, Map<BlockPos, Rail>> rails) {
        ArrayList railsToRemove = new ArrayList();
        ArrayList colorsToRemove = new ArrayList();
        this.signalBlocks.forEach(signalBlock -> signalBlock.rails.forEach(rail -> {
            BlockPos pos2;
            BlockPos pos1 = BlockPos.m_122022_((long)rail.getLeastSignificantBits());
            if (!RailwayData.containsRail(rails, pos1, pos2 = BlockPos.m_122022_((long)rail.getMostSignificantBits()))) {
                railsToRemove.add(rail);
                colorsToRemove.add(signalBlock.color);
            }
        }));
        if (railsToRemove.isEmpty()) {
            return null;
        }
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeInt(railsToRemove.size());
        for (int i = 0; i < railsToRemove.size(); ++i) {
            DyeColor color = (DyeColor)colorsToRemove.get(i);
            UUID rail = (UUID)railsToRemove.get(i);
            packet.writeLong(this.remove(0L, color, rail));
            packet.writeInt(color.ordinal());
            packet.m_130077_(rail);
        }
        return packet;
    }

    public void writeCache() {
        this.railToSignalBlocks.clear();
        this.signalBlocks.forEach(signalBlock -> signalBlock.rails.forEach(rail -> {
            if (!this.railToSignalBlocks.containsKey(rail)) {
                this.railToSignalBlocks.put((UUID)rail, new HashSet());
            }
            this.railToSignalBlocks.get(rail).add((SignalBlock)signalBlock);
        }));
    }

    public static class SignalBlock
    extends NameColorDataBase {
        public final DyeColor color;
        private final Set<UUID> rails = new HashSet<UUID>();
        private int occupied = 0;
        private static final String KEY_COLOR = "color";
        private static final String KEY_RAILS = "rails";

        private SignalBlock(long id, DyeColor color, UUID rail) {
            super(id);
            this.color = color;
            this.rails.add(rail);
        }

        public SignalBlock(Map<String, Value> map) {
            super(map);
            DyeColor savedColor;
            MessagePackHelper messagePackHelper = new MessagePackHelper(map);
            try {
                savedColor = DyeColor.values()[messagePackHelper.getInt(KEY_COLOR)];
            }
            catch (Exception e) {
                e.printStackTrace();
                savedColor = DyeColor.RED;
            }
            this.color = savedColor;
            map.get(KEY_RAILS).asArrayValue().forEach(value -> this.rails.add(UUID.fromString(value.asStringValue().asString())));
        }

        @Deprecated
        public SignalBlock(CompoundTag compoundTag) {
            super(compoundTag);
            DyeColor savedColor;
            try {
                savedColor = DyeColor.values()[compoundTag.m_128451_(KEY_COLOR)];
            }
            catch (Exception e) {
                e.printStackTrace();
                savedColor = DyeColor.RED;
            }
            this.color = savedColor;
            CompoundTag compoundTagRails = compoundTag.m_128469_(KEY_RAILS);
            compoundTagRails.m_128431_().forEach(key -> this.rails.add(compoundTagRails.m_128342_(key)));
        }

        public SignalBlock(FriendlyByteBuf packet) {
            super(packet);
            DyeColor savedColor;
            try {
                savedColor = DyeColor.values()[packet.readInt()];
            }
            catch (Exception e) {
                e.printStackTrace();
                savedColor = DyeColor.RED;
            }
            this.color = savedColor;
            int railCount = packet.readInt();
            for (int i = 0; i < railCount; ++i) {
                this.rails.add(packet.m_130259_());
            }
        }

        @Override
        public void toMessagePack(MessagePacker messagePacker) throws IOException {
            super.toMessagePack(messagePacker);
            messagePacker.packString(KEY_COLOR).packInt(this.color.ordinal());
            messagePacker.packString(KEY_RAILS).packArrayHeader(this.rails.size());
            for (UUID rail : this.rails) {
                messagePacker.packString(rail.toString());
            }
        }

        @Override
        public int messagePackLength() {
            return super.messagePackLength() + 2;
        }

        @Override
        public void writePacket(FriendlyByteBuf packet) {
            super.writePacket(packet);
            packet.writeInt(this.color.ordinal());
            packet.writeInt(this.rails.size());
            this.rails.forEach(arg_0 -> ((FriendlyByteBuf)packet).m_130077_(arg_0));
        }

        @Override
        protected boolean hasTransportMode() {
            return false;
        }

        public boolean isOccupied() {
            return this.occupied > 0;
        }

        private boolean isConnected(UUID checkRail) {
            long checkPos1 = checkRail.getLeastSignificantBits();
            long checkPos2 = checkRail.getMostSignificantBits();
            return this.rails.stream().anyMatch(rail -> {
                long pos1 = rail.getLeastSignificantBits();
                long pos2 = rail.getMostSignificantBits();
                return checkPos1 == pos1 || checkPos1 == pos2 || checkPos2 == pos1 || checkPos2 == pos2;
            });
        }

        @Override
        public int compareTo(NameColorDataBase compare) {
            return Long.compare(this.id, compare.id);
        }
    }
}

