/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import mtr.TrigCache;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.BlockTrainAnnouncer;
import mtr.block.BlockTrainCargoLoader;
import mtr.block.BlockTrainCargoUnloader;
import mtr.block.BlockTrainRedstoneSensor;
import mtr.block.BlockTrainSensorBase;
import mtr.block.IBlock;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.RailwayData;
import mtr.data.ScheduleEntry;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Train;
import mtr.data.TrainDelay;
import mtr.data.VehicleRidingServer;
import mtr.mappings.Utilities;
import mtr.path.PathData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.msgpack.value.Value;

public class TrainServer
extends Train {
    private boolean canDeploy;
    private List<Map<UUID, Long>> trainPositions;
    private Map<Player, Set<TrainServer>> trainsInPlayerRange = new HashMap<Player, Set<TrainServer>>();
    private Map<Long, Map<BlockPos, TrainDelay>> trainDelays = new HashMap<Long, Map<BlockPos, TrainDelay>>();
    private long routeId;
    private int updateRailProgressCounter;
    private int manualCoolDown;
    private final List<Siding.TimeSegment> timeSegments;
    private static final int TRAIN_UPDATE_DISTANCE = 128;
    private static final int TICKS_TO_SEND_RAIL_PROGRESS = 40;

    public TrainServer(long id, long sidingId, float railLength, String trainId, String baseTrainType, int trainCars, List<PathData> path, List<Double> distances, int repeatIndex1, int repeatIndex2, float accelerationConstant, List<Siding.TimeSegment> timeSegments, boolean isManual, int maxManualSpeed, int manualToAutomaticTime) {
        super(id, sidingId, railLength, trainId, baseTrainType, trainCars, path, distances, repeatIndex1, repeatIndex2, accelerationConstant, isManual, maxManualSpeed, manualToAutomaticTime);
        this.timeSegments = timeSegments;
    }

    public TrainServer(long sidingId, float railLength, List<Siding.TimeSegment> timeSegments, List<PathData> path, List<Double> distances, int repeatIndex1, int repeatIndex2, float accelerationConstant, boolean isManual, int maxManualSpeed, int manualToAutomaticTime, Map<String, Value> map) {
        super(sidingId, railLength, path, distances, repeatIndex1, repeatIndex2, accelerationConstant, isManual, maxManualSpeed, manualToAutomaticTime, map);
        this.timeSegments = timeSegments;
    }

    @Deprecated
    public TrainServer(long sidingId, float railLength, List<Siding.TimeSegment> timeSegments, List<PathData> path, List<Double> distances, int repeatIndex1, int repeatIndex2, float accelerationConstant, boolean isManual, int maxManualSpeed, int manualToAutomaticTime, CompoundTag compoundTag) {
        super(sidingId, railLength, path, distances, repeatIndex1, repeatIndex2, accelerationConstant, isManual, maxManualSpeed, manualToAutomaticTime, compoundTag);
        this.timeSegments = timeSegments;
    }

    @Override
    protected void startUp(Level world, int trainCars, int trainSpacing, boolean isOppositeRail) {
        this.canDeploy = false;
        this.isOnRoute = true;
        this.elapsedDwellTicks = 0.0f;
        this.speed = 0.01f;
        if (isOppositeRail) {
            this.railProgress += (double)(trainCars * trainSpacing);
            this.reversed = !this.reversed;
        }
        this.nextStoppingIndex = this.getNextStoppingIndex();
        super.startUp(world, trainCars, trainSpacing, isOppositeRail);
    }

    @Override
    protected boolean openDoors() {
        if (this.isCurrentlyManual) {
            return this.doorTarget;
        }
        if (this.transportMode.continuousMovement) {
            int index = this.getIndex(this.railProgress, false);
            if (((PathData)this.path.get((int)index)).dwellTime > 0 && index > 0) {
                double doorValue1 = (this.railProgress - (Double)this.distances.get(index - 1)) * 0.5;
                double doorValue2 = ((Double)this.distances.get(index) - this.railProgress) * 0.5;
                return doorValue1 > 0.0 && (doorValue2 > doorValue1 || doorValue2 > 1.0);
            }
            return false;
        }
        int dwellTicks = ((PathData)this.path.get((int)this.nextStoppingIndex)).dwellTime * 10;
        float maxDoorMoveTime = Math.min(64, dwellTicks / 2 - 20);
        return this.elapsedDwellTicks >= 20.0f && this.elapsedDwellTicks < (float)(dwellTicks - 20) - maxDoorMoveTime;
    }

    @Override
    protected void simulateCar(Level world, int ridingCar, float ticksElapsed, double carX, double carY, double carZ, float carYaw, float carPitch, double prevCarX, double prevCarY, double prevCarZ, float prevCarYaw, float prevCarPitch, boolean doorLeftOpen, boolean doorRightOpen, double realSpacing) {
        VehicleRidingServer.mountRider(world, this.ridingEntities, this.id, this.routeId, carX, carY, carZ, realSpacing, this.width, carYaw, carPitch, doorLeftOpen || doorRightOpen, this.isManualAllowed || doorLeftOpen || doorRightOpen, ridingCar, PACKET_UPDATE_TRAIN_PASSENGERS, player -> !this.isManualAllowed || doorLeftOpen || doorRightOpen || Train.isHoldingKey(player), player -> {
            if (TrainServer.isHoldingKey(player)) {
                this.manualCoolDown = 0;
            }
        });
    }

    @Override
    protected boolean handlePositions(Level world, Vec3[] positions, float ticksElapsed) {
        AABB trainAABB = new AABB(positions[0], positions[positions.length - 1]).m_82400_(128.0);
        boolean[] playerNearby = new boolean[]{false};
        world.m_6907_().forEach(player -> {
            if (this.isPlayerRiding((Player)player) || trainAABB.m_82390_(player.m_20182_())) {
                if (!this.trainsInPlayerRange.containsKey(player)) {
                    this.trainsInPlayerRange.put((Player)player, new HashSet());
                }
                this.trainsInPlayerRange.get(player).add(this);
                playerNearby[0] = true;
            }
        });
        BlockPos frontPos = new BlockPos(positions[this.reversed ? positions.length - 1 : 0]);
        if (RailwayData.chunkLoaded(world, frontPos)) {
            this.checkBlock(frontPos, checkPos -> {
                if (RailwayData.chunkLoaded(world, checkPos)) {
                    BlockState state = world.m_8055_(checkPos);
                    Block block = state.m_60734_();
                    if (block instanceof BlockTrainRedstoneSensor && BlockTrainSensorBase.matchesFilter(world, checkPos, this.routeId, this.speed)) {
                        ((BlockTrainRedstoneSensor)block).power(world, state, (BlockPos)checkPos);
                    }
                    if ((block instanceof BlockTrainCargoLoader || block instanceof BlockTrainCargoUnloader) && BlockTrainSensorBase.matchesFilter(world, checkPos, this.routeId, this.speed)) {
                        for (Direction direction : Direction.values()) {
                            Container nearbyInventory = HopperBlockEntity.m_59390_((Level)world, (BlockPos)checkPos.m_142300_(direction));
                            if (nearbyInventory == null) continue;
                            if (block instanceof BlockTrainCargoLoader) {
                                TrainServer.transferItems(nearbyInventory, (Container)this.inventory);
                                continue;
                            }
                            TrainServer.transferItems((Container)this.inventory, nearbyInventory);
                        }
                    }
                }
            });
        }
        if (!this.ridingEntities.isEmpty() && RailwayData.chunkLoaded(world, frontPos)) {
            this.checkBlock(frontPos, checkPos -> {
                BlockEntity entity;
                if (RailwayData.chunkLoaded(world, checkPos) && world.m_8055_(checkPos).m_60734_() instanceof BlockTrainAnnouncer && (entity = world.m_7702_(checkPos)) instanceof BlockTrainAnnouncer.TileEntityTrainAnnouncer && ((BlockTrainAnnouncer.TileEntityTrainAnnouncer)entity).matchesFilter(this.routeId, this.speed)) {
                    this.ridingEntities.forEach(uuid -> ((BlockTrainAnnouncer.TileEntityTrainAnnouncer)entity).announce(world.m_46003_(uuid)));
                }
            });
        }
        return playerNearby[0];
    }

    @Override
    protected boolean canDeploy(Depot depot) {
        if (this.path.size() > 1 && depot != null) {
            depot.requestDeploy(this.sidingId, this);
        }
        return this.canDeploy;
    }

    @Override
    protected boolean isRailBlocked(int checkIndex) {
        if (!this.transportMode.continuousMovement && this.trainPositions != null && checkIndex < this.path.size()) {
            PathData pathData = (PathData)this.path.get(checkIndex);
            UUID railProduct = pathData.getRailProduct();
            for (Map<UUID, Long> trainPositionsMap : this.trainPositions) {
                if (!trainPositionsMap.containsKey(railProduct) || trainPositionsMap.get(railProduct) == this.id) continue;
                if (this.routeId != 0L) {
                    if (!this.trainDelays.containsKey(this.routeId)) {
                        this.trainDelays.put(this.routeId, new HashMap());
                    }
                    if (!this.trainDelays.get(this.routeId).containsKey(pathData.startingPos)) {
                        this.trainDelays.get(this.routeId).put(pathData.startingPos, new TrainDelay());
                    }
                    this.trainDelays.get(this.routeId).get(pathData.startingPos).delaying();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean skipScanBlocks(Level world, double trainX, double trainY, double trainZ) {
        return world.m_5788_(trainX, trainY, trainZ, 32.0, entity -> true) == null;
    }

    @Override
    protected boolean openDoors(Level world, Block block, BlockPos checkPos, int dwellTicks) {
        if (block instanceof BlockPSDAPGDoorBase) {
            for (int i = -1; i <= 1; ++i) {
                BlockPos doorPos = checkPos.m_6630_(i);
                BlockState state = world.m_8055_(doorPos);
                Block doorBlock = state.m_60734_();
                BlockEntity entity = world.m_7702_(doorPos);
                if (!(doorBlock instanceof BlockPSDAPGDoorBase) || !(entity instanceof BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase) || !((Boolean)IBlock.getStatePropertySafe(state, BlockPSDAPGDoorBase.UNLOCKED)).booleanValue()) continue;
                int doorStateValue = (int)Mth.m_14036_((float)(this.doorValue * 64.0f), (float)0.0f, (float)32.0f);
                ((BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase)entity).setOpen(doorStateValue);
                if (doorStateValue <= 0 || world.m_183326_().m_183582_(doorPos, (Object)doorBlock)) continue;
                Utilities.scheduleBlockTick(world, doorPos, doorBlock, dwellTicks);
            }
        }
        return false;
    }

    @Override
    protected double asin(double value) {
        return TrigCache.asin(value);
    }

    public boolean simulateTrain(Level world, float ticksElapsed, Depot depot, DataCache dataCache, List<Map<UUID, Long>> trainPositions, Map<Player, Set<TrainServer>> trainsInPlayerRange, Map<Long, List<ScheduleEntry>> schedulesForPlatform, Map<Long, Map<BlockPos, TrainDelay>> trainDelays) {
        this.trainPositions = trainPositions;
        this.trainsInPlayerRange = trainsInPlayerRange;
        this.trainDelays = trainDelays;
        int oldStoppingIndex = this.nextStoppingIndex;
        int oldPassengerCount = this.ridingEntities.size();
        boolean oldIsCurrentlyManual = this.isCurrentlyManual;
        boolean oldStopped = this.speed == 0.0f;
        boolean oldDoorOpen = this.doorTarget;
        this.simulateTrain(world, ticksElapsed, depot);
        int nextDepartureTicks = this.isOnRoute ? 0 : depot.getNextDepartureMillis();
        long currentMillis = System.currentTimeMillis() - (long)(this.elapsedDwellTicks * 50.0f) + (long)Math.max(0, nextDepartureTicks);
        double currentTime = -1.0;
        int startingIndex = 0;
        for (Siding.TimeSegment timeSegment : this.timeSegments) {
            if (RailwayData.isBetween(this.railProgress, timeSegment.startRailProgress, timeSegment.endRailProgress)) {
                currentTime = timeSegment.getTime(this.railProgress);
                break;
            }
            ++startingIndex;
        }
        if (currentTime >= 0.0) {
            float offsetTime = 0.0f;
            float offsetTimeTemp = 0.0f;
            boolean secondRound = false;
            Runnable addSchedule = null;
            this.routeId = 0L;
            for (int i = startingIndex; i < this.timeSegments.size() + (this.isRepeat() ? this.timeSegments.size() : 0); ++i) {
                Siding.TimeSegment timeSegment = this.timeSegments.get(i % this.timeSegments.size());
                if (timeSegment.savedRailBaseId != 0L) {
                    long platformId;
                    if (timeSegment.routeId == 0L) {
                        RailwayData.useRoutesAndStationsFromIndex(((PathData)this.path.get((int)this.getIndex((double)timeSegment.endRailProgress, (boolean)true))).stopIndex - 1, depot.routeIds, dataCache, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
                            timeSegment.routeId = thisRoute == null ? 0L : thisRoute.id;
                            timeSegment.currentStationIndex = currentStationIndex;
                        });
                    }
                    if (!schedulesForPlatform.containsKey(platformId = timeSegment.savedRailBaseId)) {
                        schedulesForPlatform.put(platformId, new ArrayList());
                    }
                    if (secondRound) {
                        offsetTime = offsetTimeTemp - timeSegment.endTime;
                        secondRound = false;
                    } else if (addSchedule != null) {
                        addSchedule.run();
                    }
                    if (this.isOnRoute || nextDepartureTicks >= 0) {
                        long arrivalMillis = currentMillis + (long)(((double)(timeSegment.endTime + offsetTime) - currentTime) * 50.0);
                        addSchedule = () -> ((List)schedulesForPlatform.get(platformId)).add(new ScheduleEntry(arrivalMillis, this.trainCars, timeSegment.routeId, timeSegment.currentStationIndex));
                        if (!this.isRepeat()) {
                            addSchedule.run();
                            addSchedule = null;
                        }
                    }
                    offsetTimeTemp = timeSegment.endTime;
                }
                if (this.routeId == 0L) {
                    this.routeId = timeSegment.routeId;
                }
                if (i != this.timeSegments.size() - 1) continue;
                secondRound = true;
            }
        }
        ++this.updateRailProgressCounter;
        if (this.updateRailProgressCounter == 40) {
            this.updateRailProgressCounter = 0;
        }
        if (this.isManualAllowed) {
            if (this.isOnRoute) {
                if (this.manualCoolDown >= this.manualToAutomaticTime * 10) {
                    if (this.isCurrentlyManual) {
                        int dwellTicks = this.nextStoppingIndex >= this.path.size() ? 0 : ((PathData)this.path.get((int)this.nextStoppingIndex)).dwellTime * 10;
                        this.elapsedDwellTicks = this.doorTarget ? (float)dwellTicks / 2.0f : (float)dwellTicks;
                    }
                    this.isCurrentlyManual = false;
                } else {
                    ++this.manualCoolDown;
                    this.isCurrentlyManual = true;
                }
            } else {
                this.manualCoolDown = 0;
                this.isCurrentlyManual = true;
            }
        } else {
            this.isCurrentlyManual = false;
        }
        return oldPassengerCount > this.ridingEntities.size() || oldStoppingIndex != this.nextStoppingIndex || oldIsCurrentlyManual != this.isCurrentlyManual || oldStopped && this.speed != 0.0f || oldDoorOpen != this.doorTarget;
    }

    public void writeTrainPositions(List<Map<UUID, Long>> trainPositions, SignalBlocks signalBlocks) {
        if (!this.path.isEmpty()) {
            int tailIndex;
            int headIndex = this.getIndex(0, this.spacing, true);
            for (int i = tailIndex = this.getIndex(this.trainCars, this.spacing, false); i <= headIndex; ++i) {
                PathData pathData = (PathData)this.path.get(i);
                if (i <= 0 || pathData.savedRailBaseId == this.sidingId || !pathData.rail.railType.hasSignal) continue;
                signalBlocks.occupy(pathData.getRailProduct(), trainPositions, this.id);
            }
        }
    }

    public void deployTrain() {
        this.canDeploy = true;
    }

    private int getNextStoppingIndex() {
        int headIndex;
        for (int i = headIndex = this.getIndex(0, 0, false); i < this.path.size(); ++i) {
            if (((PathData)this.path.get((int)i)).dwellTime <= 0) continue;
            return i;
        }
        return this.path.size() - 1;
    }

    private void checkBlock(BlockPos pos, Consumer<BlockPos> callback) {
        int checkRadius = (int)Math.floor(this.speed);
        for (int x = -checkRadius; x <= checkRadius; ++x) {
            for (int z = -checkRadius; z <= checkRadius; ++z) {
                for (int y = 0; y <= 3; ++y) {
                    callback.accept(pos.m_142082_(x, -y, z));
                }
            }
        }
    }

    private static void transferItems(Container inventoryFrom, Container inventoryTo) {
        for (int i = 0; i < inventoryFrom.m_6643_(); ++i) {
            if (inventoryFrom.m_8020_(i).m_41619_()) continue;
            ItemStack insertItem = new ItemStack((ItemLike)inventoryFrom.m_8020_(i).m_41720_(), 1);
            insertItem.m_41751_(inventoryFrom.m_8020_(i).m_41784_());
            ItemStack remainingStack = HopperBlockEntity.m_59326_(null, (Container)inventoryTo, (ItemStack)insertItem, null);
            if (!remainingStack.m_41619_()) continue;
            inventoryFrom.m_7407_(i, 1);
            return;
        }
    }
}

