/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.Registry;
import mtr.data.RailwayData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VehicleRidingServer {
    private static final float INNER_PADDING = 0.5f;
    private static final int BOX_PADDING = 3;

    public static void mountRider(Level world, Set<UUID> ridingEntities, long id, long routeId, double carX, double carY, double carZ, double length, double width, float carYaw, float carPitch, boolean doorOpen, boolean canMount, int percentageOffset, ResourceLocation packetId, Function<Player, Boolean> canRide, Consumer<Player> ridingCallback) {
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return;
        }
        double halfLength = length / 2.0;
        double halfWidth = width / 2.0;
        if (canMount) {
            double margin = halfLength + 3.0;
            world.m_6443_(Player.class, new AABB(carX + margin, carY + margin, carZ + margin, carX - margin, carY - margin, carZ - margin), player -> !player.m_5833_() && !ridingEntities.contains(player.m_142081_()) && railwayData.railwayDataCoolDownModule.canRide((Player)player) && (Boolean)canRide.apply((Player)player) != false).forEach(player -> {
                Vec3 positionRotated = player.m_20182_().m_82492_(carX, carY, carZ).m_82524_(-carYaw).m_82496_(-carPitch);
                if (Math.abs(positionRotated.f_82479_) < halfWidth + 0.5 && Math.abs(positionRotated.f_82480_) < 2.5 && Math.abs(positionRotated.f_82481_) <= halfLength && !railwayData.railwayDataCoolDownModule.shouldDismount((Player)player)) {
                    ridingEntities.add(player.m_142081_());
                    float percentageX = (float)(positionRotated.f_82479_ / width + 0.5);
                    float percentageZ = (float)(length == 0.0 ? 0.0 : positionRotated.f_82481_ / length + 0.5) + (float)percentageOffset;
                    FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                    packet.writeLong(id);
                    packet.writeFloat(percentageX);
                    packet.writeFloat(percentageZ);
                    packet.m_130077_(player.m_142081_());
                    world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)worldPlayer, packetId, packet));
                }
            });
        }
        HashSet ridersToRemove = new HashSet();
        ridingEntities.forEach(uuid -> {
            Player player = world.m_46003_(uuid);
            if (player != null) {
                boolean remove;
                if (player.m_5833_() || railwayData.railwayDataCoolDownModule.shouldDismount(player)) {
                    remove = true;
                } else if (doorOpen) {
                    Vec3 positionRotated = player.m_20182_().m_82492_(carX, carY, carZ).m_82524_(-carYaw).m_82496_(-carPitch);
                    remove = Math.abs(positionRotated.f_82481_) <= halfLength && (Math.abs(positionRotated.f_82479_) > halfWidth + 0.5 || Math.abs(positionRotated.f_82480_) > 10.0);
                } else {
                    remove = false;
                }
                if (remove) {
                    ridersToRemove.add(uuid);
                }
                railwayData.railwayDataCoolDownModule.updatePlayerRiding(player, routeId);
                ridingCallback.accept(player);
            }
        });
        if (!ridersToRemove.isEmpty()) {
            ridersToRemove.forEach(ridingEntities::remove);
        }
    }
}

