/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mtr.data.EnumHelper;
import mtr.data.NameColorDataBase;
import mtr.data.RailwayDataLoggingModule;
import mtr.data.TransportMode;
import mtr.packet.IPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;

public abstract class PacketTrainDataBase
implements IPacket {
    protected static <T extends NameColorDataBase, U extends ReentrantBlockableEventLoop<? extends Runnable>> void updateData(Set<T> dataSet, Map<Long, T> cacheMap, U minecraft, FriendlyByteBuf packet, PacketCallback packetCallback, BiFunction<Long, TransportMode, T> createDataWithId, BiConsumer<T, List<String>> dataCallback) {
        FriendlyByteBuf packetFullCopy = new FriendlyByteBuf(packet.copy());
        long id = packet.readLong();
        TransportMode transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.m_130136_(Short.MAX_VALUE));
        String key = packet.m_130136_(Short.MAX_VALUE);
        FriendlyByteBuf packetCopy = new FriendlyByteBuf(packet.copy());
        minecraft.execute(() -> {
            NameColorDataBase data = (NameColorDataBase)cacheMap.get(id);
            if (data == null) {
                if (createDataWithId != null) {
                    NameColorDataBase newData = (NameColorDataBase)createDataWithId.apply(id, transportMode);
                    dataSet.add(newData);
                    newData.update(key, packetCopy);
                    if (dataCallback != null) {
                        dataCallback.accept(newData, new ArrayList());
                    }
                }
            } else {
                List<Object> oldData = dataCallback == null ? new ArrayList() : RailwayDataLoggingModule.getData(data);
                data.update(key, packetCopy);
                if (dataCallback != null) {
                    dataCallback.accept(data, oldData);
                }
            }
            packetCallback.packetCallback(packetCopy, packetFullCopy);
        });
    }

    protected static <T extends NameColorDataBase, U extends ReentrantBlockableEventLoop<? extends Runnable>> void deleteData(Set<T> dataSet, Map<Long, T> cacheMap, U minecraft, FriendlyByteBuf packet, PacketCallback packetCallback, Consumer<T> dataCallback) {
        FriendlyByteBuf packetFullCopy = new FriendlyByteBuf(packet.copy());
        long id = packet.readLong();
        minecraft.execute(() -> {
            NameColorDataBase data = (NameColorDataBase)cacheMap.get(id);
            if (data != null) {
                if (dataCallback != null) {
                    dataCallback.accept(data);
                }
                dataSet.remove(data);
            }
            packetCallback.packetCallback(null, packetFullCopy);
        });
    }

    @FunctionalInterface
    protected static interface PacketCallback {
        public void packetCallback(FriendlyByteBuf var1, FriendlyByteBuf var2);
    }
}

