/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import mtr.MTRClient;
import mtr.block.BlockNode;
import mtr.block.BlockPlatform;
import mtr.block.BlockSignalLightBase;
import mtr.block.BlockSignalSemaphoreBase;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.IDrawing;
import mtr.client.ResourcePackCreatorProperties;
import mtr.data.IGui;
import mtr.data.Lift;
import mtr.data.LiftClient;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.Train;
import mtr.data.TrainClient;
import mtr.data.TransportMode;
import mtr.entity.EntitySeat;
import mtr.item.ItemNodeModifierBase;
import mtr.mappings.EntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelLift1;
import mtr.path.PathData;
import mtr.render.MoreRenderLayers;
import mtr.render.TrainRendererBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;

public class RenderTrains
extends EntityRendererMapper<EntitySeat>
implements IGui {
    public static int maxTrainRenderDistance;
    public static ResourcePackCreatorProperties creatorProperties;
    private static float lastRenderedTick;
    private static int prevPlatformCount;
    private static int prevSidingCount;
    private static UUID renderedUuid;
    public static final int PLAYER_RENDER_OFFSET = 1000;
    public static final Set<String> AVAILABLE_TEXTURES;
    public static final Set<String> UNAVAILABLE_TEXTURES;
    public static final int DETAIL_RADIUS = 32;
    public static final int DETAIL_RADIUS_SQUARED = 1024;
    public static final int LIFT_LIGHT_COLOR = -65536;
    private static final int MAX_RADIUS_REPLAY_MOD = 1024;
    private static final int TICKS_PER_SECOND = 20;
    private static final int DISMOUNT_PROGRESS_BAR_LENGTH = 30;
    private static final int TOTAL_RENDER_STAGES = 2;
    private static final List<List<Map<ResourceLocation, Set<BiConsumer<PoseStack, VertexConsumer>>>>> RENDERS;
    private static final List<List<Map<ResourceLocation, Set<BiConsumer<PoseStack, VertexConsumer>>>>> CURRENT_RENDERS;
    private static final ResourceLocation LIFT_TEXTURE;
    private static final ResourceLocation ARROW_TEXTURE;

    public RenderTrains(Object parameter) {
        super(parameter);
    }

    public void render(EntitySeat entity, float entityYaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int entityLight) {
        RenderTrains.render(entity, tickDelta, matrices, vertexConsumers);
    }

    public ResourceLocation getTextureLocation(EntitySeat entity) {
        return null;
    }

    public static void render(EntitySeat entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers) {
        int j;
        int i;
        boolean useAnnouncements;
        boolean alreadyRendered;
        boolean backupRendering;
        Minecraft client = Minecraft.m_91087_();
        boolean bl = backupRendering = entity == null;
        if (!backupRendering && MTRClient.isPehkui()) {
            return;
        }
        boolean bl2 = alreadyRendered = renderedUuid != null && (backupRendering || entity.m_142081_() != renderedUuid);
        if (backupRendering) {
            renderedUuid = null;
        }
        LocalPlayer player = client.f_91074_;
        ClientLevel world = client.f_91073_;
        if (alreadyRendered || player == null || world == null) {
            return;
        }
        if (!backupRendering) {
            renderedUuid = entity.m_142081_();
        }
        int renderDistanceChunks = UtilitiesClient.getRenderDistance();
        float lastFrameDuration = MTRClient.getLastFrameDuration();
        float newLastFrameDuration = client.m_91104_() || lastRenderedTick == MTRClient.getGameTick() ? 0.0f : lastFrameDuration;
        boolean bl3 = useAnnouncements = Config.useTTSAnnouncements() || Config.showAnnouncementMessages();
        if (Config.useDynamicFPS()) {
            if ((double)lastFrameDuration > 0.5) {
                maxTrainRenderDistance = Math.max(maxTrainRenderDistance - (maxTrainRenderDistance - 32) / 2, 32);
            } else if ((double)lastFrameDuration < 0.4) {
                maxTrainRenderDistance = Math.min(maxTrainRenderDistance + 1, renderDistanceChunks * (Config.trainRenderDistanceRatio() + 1));
            }
        } else {
            maxTrainRenderDistance = renderDistanceChunks * (Config.trainRenderDistanceRatio() + 1);
        }
        if (!backupRendering) {
            matrices.m_85849_();
            matrices.m_85836_();
            Vec3 cameraPosition = client.f_91063_.m_109153_().m_90583_();
            matrices.m_85837_(-cameraPosition.f_82479_, -cameraPosition.f_82480_, -cameraPosition.f_82481_);
        }
        matrices.m_85836_();
        TrainRendererBase.setupStaticInfo(matrices, vertexConsumers, entity, tickDelta);
        TrainRendererBase.setBatch(false);
        ClientData.TRAINS.forEach(arg_0 -> RenderTrains.lambda$render$4((Level)world, newLastFrameDuration, player, useAnnouncements, arg_0));
        if (!Config.hideTranslucentParts()) {
            TrainRendererBase.setBatch(true);
            ClientData.TRAINS.forEach(TrainClient::renderTranslucent);
        }
        ClientData.LIFTS.forEach(arg_0 -> RenderTrains.lambda$render$6((Level)world, matrices, vertexConsumers, newLastFrameDuration, arg_0));
        boolean renderColors = RenderTrains.isHoldingRailRelated((Player)player);
        int maxRailDistance = renderDistanceChunks * 16;
        HashMap renderedRailMap = new HashMap();
        ClientData.RAILS.forEach((arg_0, arg_1) -> RenderTrains.lambda$render$9(player, maxRailDistance, renderedRailMap, (Level)world, renderColors, matrices, vertexConsumers, arg_0, arg_1));
        matrices.m_85849_();
        if (lastRenderedTick != MTRClient.getGameTick()) {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < QueuedRenderLayer.values().length; ++j) {
                    CURRENT_RENDERS.get(i).get(j).clear();
                    CURRENT_RENDERS.get(i).get(j).putAll(RENDERS.get(i).get(j));
                    RENDERS.get(i).get(j).clear();
                }
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < QueuedRenderLayer.values().length; ++j) {
                QueuedRenderLayer queuedRenderLayer = QueuedRenderLayer.values()[j];
                CURRENT_RENDERS.get(i).get(j).forEach((key, value) -> {
                    VertexConsumer vertexConsumer = vertexConsumers.m_6299_(switch (queuedRenderLayer) {
                        case QueuedRenderLayer.LIGHT -> MoreRenderLayers.getLight(key, false);
                        case QueuedRenderLayer.LIGHT_TRANSLUCENT -> MoreRenderLayers.getLight(key, true);
                        case QueuedRenderLayer.INTERIOR -> MoreRenderLayers.getInterior(key);
                        default -> MoreRenderLayers.getExterior(key);
                    });
                    value.forEach(renderer -> renderer.accept(matrices, vertexConsumer));
                });
            }
        }
        if (prevPlatformCount != ClientData.PLATFORMS.size() || prevSidingCount != ClientData.SIDINGS.size()) {
            ClientData.DATA_CACHE.sync();
        }
        prevPlatformCount = ClientData.PLATFORMS.size();
        prevSidingCount = ClientData.SIDINGS.size();
        ClientData.DATA_CACHE.clearDataIfNeeded();
        lastRenderedTick = MTRClient.getGameTick();
    }

    public static boolean shouldNotRender(BlockPos pos, int maxDistance, Direction facing) {
        Entity camera = Minecraft.m_91087_().f_91075_;
        return RenderTrains.shouldNotRender(camera == null ? null : camera.m_20182_(), pos, maxDistance, facing);
    }

    public static void clearTextureAvailability() {
        AVAILABLE_TEXTURES.clear();
        UNAVAILABLE_TEXTURES.clear();
    }

    public static void renderLiftDisplay(PoseStack matrices, MultiBufferSource vertexConsumers, BlockPos pos, String floorNumber, Lift.LiftDirection liftDirection, float maxWidth, float height) {
        if (RenderTrains.shouldNotRender(pos, Math.min(16, maxTrainRenderDistance), null)) {
            return;
        }
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        IDrawing.drawStringWithFont(matrices, Minecraft.m_91087_().f_91062_, immediate, floorNumber, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.BOTTOM, 0.0f, height, maxWidth, -1.0f, 18.0f / maxWidth, -65536, false, 0xF000F0, null);
        immediate.m_109911_();
        if (liftDirection != Lift.LiftDirection.NONE) {
            IDrawing.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getLight(ARROW_TEXTURE, true)), -maxWidth / 6.0f, 0.0f, maxWidth / 3.0f, maxWidth / 3.0f, 0.0f, liftDirection == Lift.LiftDirection.UP ? 0.0f : 1.0f, 1.0f, liftDirection == Lift.LiftDirection.UP ? 1.0f : 0.0f, Direction.UP, -65536, 0xF000F0);
        }
    }

    public static boolean isHoldingRailRelated(Player player) {
        return Utilities.isHolding(player, item -> item instanceof ItemNodeModifierBase || Block.m_49814_((Item)item) instanceof BlockSignalLightBase || Block.m_49814_((Item)item) instanceof BlockNode || Block.m_49814_((Item)item) instanceof BlockSignalSemaphoreBase || Block.m_49814_((Item)item) instanceof BlockPlatform);
    }

    public static boolean showShiftProgressBar() {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        float shiftHoldingTicks = ClientData.getShiftHoldingTicks();
        if (shiftHoldingTicks > 0.0f && player != null) {
            int progressFilled = Mth.m_14045_((int)((int)(shiftHoldingTicks * 30.0f / 30.0f)), (int)0, (int)30);
            String progressBar = String.format("\u00a76%s\u00a77%s", StringUtils.repeat((char)'|', (int)progressFilled), StringUtils.repeat((char)'|', (int)(30 - progressFilled)));
            player.m_5661_((Component)Text.translatable("gui.mtr.dismount_hold", client.f_91066_.f_92090_.m_90863_(), progressBar), true);
            return false;
        }
        return true;
    }

    @Deprecated
    public static void scheduleRender(ResourceLocation resourceLocation, boolean priority, Function<ResourceLocation, RenderType> getVertexConsumer, BiConsumer<PoseStack, VertexConsumer> callback) {
        RenderTrains.scheduleRender(resourceLocation, priority, QueuedRenderLayer.EXTERIOR, callback);
    }

    public static void scheduleRender(ResourceLocation resourceLocation, boolean priority, QueuedRenderLayer queuedRenderLayer, BiConsumer<PoseStack, VertexConsumer> callback) {
        Map<ResourceLocation, Set<BiConsumer<PoseStack, VertexConsumer>>> map = RENDERS.get(priority ? 1 : 0).get(queuedRenderLayer.ordinal());
        if (!map.containsKey(resourceLocation)) {
            map.put(resourceLocation, new HashSet());
        }
        map.get(resourceLocation).add(callback);
    }

    public static String getInterchangeRouteNames(Station station, Route thisRoute, Route nextRoute) {
        String thisRouteSplit = thisRoute.name.split("\\|\\|")[0];
        String nextRouteSplit = nextRoute == null ? null : nextRoute.name.split("\\|\\|")[0];
        Map<Integer, ClientCache.ColorNameTuple> routesInStation = ClientData.DATA_CACHE.stationIdToRoutes.get(station.id);
        if (routesInStation != null) {
            List<String> interchangeRoutes = routesInStation.values().stream().filter(interchangeRoute -> {
                String routeName = interchangeRoute.name.split("\\|\\|")[0];
                return !routeName.equals(thisRouteSplit) && !routeName.equals(nextRouteSplit);
            }).map(interchangeRoute -> interchangeRoute.name).collect(Collectors.toList());
            return IGui.mergeStationsWithCommas(interchangeRoutes);
        }
        return "";
    }

    private static double maxDistanceXZ(Vec3 pos1, BlockPos pos2) {
        return Math.max(Math.abs(pos1.f_82479_ - (double)pos2.m_123341_()), Math.abs(pos1.f_82481_ - (double)pos2.m_123343_()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldNotRender(Vec3 cameraPos, BlockPos pos, int maxDistance, Direction facing) {
        double playerZOffset;
        double playerXOffset;
        boolean playerFacingAway = cameraPos == null || facing == null ? false : (facing.m_122434_() == Direction.Axis.X ? Math.signum(playerXOffset = cameraPos.f_82479_ - (double)pos.m_123341_() - 0.5) == (double)facing.m_122429_() && Math.abs(playerXOffset) >= 0.5 : Math.signum(playerZOffset = cameraPos.f_82481_ - (double)pos.m_123343_() - 0.5) == (double)facing.m_122431_() && Math.abs(playerZOffset) >= 0.5);
        if (cameraPos == null) return true;
        if (playerFacingAway) return true;
        double d = RenderTrains.maxDistanceXZ(cameraPos, pos);
        int n = MTRClient.isReplayMod() ? 1024 : maxDistance;
        if (!(d > (double)n)) return false;
        return true;
    }

    private static void renderRailStandard(Level world, Rail rail, float yOffset, boolean renderColors, float railWidth) {
        RenderTrains.renderRailStandard(world, rail, yOffset, renderColors, railWidth, renderColors && rail.railType == RailType.QUARTZ ? "mtr:textures/block/rail_preview.png" : "textures/block/rail.png", -1.0f, -1.0f, -1.0f, -1.0f);
    }

    private static void renderRailStandard(Level world, Rail rail, float yOffset, boolean renderColors, float railWidth, String texture, float u1, float v1, float u2, float v2) {
        int maxRailDistance = UtilitiesClient.getRenderDistance() * 16;
        rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
            BlockPos pos2 = new BlockPos(x1, y1, z1);
            if (RenderTrains.shouldNotRender(pos2, maxRailDistance, null)) {
                return;
            }
            int light2 = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, pos2), (int)world.m_45517_(LightLayer.SKY, pos2));
            if (rail.railType == RailType.NONE) {
                if (rail.transportMode != TransportMode.CABLE_CAR && renderColors) {
                    RenderTrains.scheduleRender(new ResourceLocation("mtr:textures/block/one_way_rail_arrow.png"), false, QueuedRenderLayer.EXTERIOR, (PoseStack matrices, VertexConsumer vertexConsumer) -> {
                        IDrawing.drawTexture(matrices, vertexConsumer, (float)x1, (float)y1 + yOffset, (float)z1, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x3, (float)y2 + yOffset, (float)z3, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, 0.0f, 0.25f, 1.0f, 0.75f, Direction.UP, -1, light2);
                        IDrawing.drawTexture(matrices, vertexConsumer, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x1, (float)y1 + yOffset, (float)z1, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, (float)x3, (float)y2 + yOffset, (float)z3, 0.0f, 0.25f, 1.0f, 0.75f, Direction.UP, -1, light2);
                    });
                }
            } else {
                float textureOffset = (float)((int)(x1 + z1) % 4) * 0.25f + (float)Config.trackTextureOffset() / 32.0f;
                int color = renderColors || !Config.hideSpecialRailColors() && rail.railType.hasSavedRail ? rail.railType.color : -1;
                RenderTrains.scheduleRender(new ResourceLocation(texture), false, QueuedRenderLayer.EXTERIOR, (PoseStack matrices, VertexConsumer vertexConsumer) -> {
                    IDrawing.drawTexture(matrices, vertexConsumer, (float)x1, (float)y1 + yOffset, (float)z1, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x3, (float)y2 + yOffset, (float)z3, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, u1 < 0.0f ? 0.0f : u1, v1 < 0.0f ? 0.1875f + textureOffset : v1, u2 < 0.0f ? 1.0f : u2, v2 < 0.0f ? 0.3125f + textureOffset : v2, Direction.UP, color, light2);
                    IDrawing.drawTexture(matrices, vertexConsumer, (float)x2, (float)y1 + yOffset + 0.003125f, (float)z2, (float)x1, (float)y1 + yOffset, (float)z1, (float)x4, (float)y2 + yOffset + 0.003125f, (float)z4, (float)x3, (float)y2 + yOffset, (float)z3, u1 < 0.0f ? 0.0f : u1, v1 < 0.0f ? 0.1875f + textureOffset : v1, u2 < 0.0f ? 1.0f : u2, v2 < 0.0f ? 0.3125f + textureOffset : v2, Direction.UP, color, light2);
                });
            }
        }, -railWidth, railWidth);
    }

    private static void renderSignalsStandard(Level world, PoseStack matrices, MultiBufferSource vertexConsumers, Rail rail, BlockPos startPos, BlockPos endPos) {
        int maxRailDistance = UtilitiesClient.getRenderDistance() * 16;
        List<SignalBlocks.SignalBlock> signalBlocks = ClientData.SIGNAL_BLOCKS.getSignalBlocksAtTrack(PathData.getRailProduct(startPos, endPos));
        float width = 1.0f / (float)DyeColor.values().length;
        for (int i = 0; i < signalBlocks.size(); ++i) {
            SignalBlocks.SignalBlock signalBlock = signalBlocks.get(i);
            boolean shouldGlow = signalBlock.isOccupied() && (int)Math.floor(MTRClient.getGameTick()) % 20 < 10;
            VertexConsumer vertexConsumer = shouldGlow ? vertexConsumers.m_6299_(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/block/white.png"), false)) : vertexConsumers.m_6299_(MoreRenderLayers.getExterior(new ResourceLocation("textures/block/white_wool.png")));
            float u1 = width * (float)i + 1.0f - width * (float)signalBlocks.size() / 2.0f;
            float u2 = u1 + width;
            int color = 0xFF000000 | signalBlock.color.m_41069_().f_76396_;
            rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                BlockPos pos2 = new BlockPos(x1, y1, z1);
                if (RenderTrains.shouldNotRender(pos2, maxRailDistance, null)) {
                    return;
                }
                int light2 = shouldGlow ? 0xF000F0 : LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, pos2), (int)world.m_45517_(LightLayer.SKY, pos2));
                IDrawing.drawTexture(matrices, vertexConsumer, (float)x1, (float)y1, (float)z1, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x3, (float)y2, (float)z3, (float)x4, (float)y2 + 0.003125f, (float)z4, u1, 0.0f, u2, 1.0f, Direction.UP, color, light2);
                IDrawing.drawTexture(matrices, vertexConsumer, (float)x4, (float)y2 + 0.003125f, (float)z4, (float)x3, (float)y2, (float)z3, (float)x2, (float)y1 + 0.003125f, (float)z2, (float)x1, (float)y1, (float)z1, u1, 0.0f, u2, 1.0f, Direction.UP, color, light2);
            }, u1 - 1.0f, u2 - 1.0f);
        }
    }

    private static Component getStationText(Station station, String textKey) {
        if (station != null) {
            return Text.literal(IGui.formatStationName(IGui.insertTranslation("gui.mtr." + textKey + "_station_cjk", "gui.mtr." + textKey + "_station", 1, IGui.textOrUntitled(station.name))));
        }
        return Text.literal("");
    }

    private static /* synthetic */ void lambda$render$9(LocalPlayer player, int maxRailDistance, Map renderedRailMap, Level world, boolean renderColors, PoseStack matrices, MultiBufferSource vertexConsumers, BlockPos startPos, Map railMap) {
        railMap.forEach((endPos, rail) -> {
            if (!RailwayData.isBetween(player.m_20185_(), startPos.m_123341_(), endPos.m_123341_(), maxRailDistance) || !RailwayData.isBetween(player.m_20189_(), startPos.m_123343_(), endPos.m_123343_(), maxRailDistance)) {
                return;
            }
            UUID railProduct = PathData.getRailProduct(startPos, endPos);
            if (renderedRailMap.containsKey(railProduct)) {
                if (renderedRailMap.get(railProduct) == rail.railType) {
                    return;
                }
            } else {
                renderedRailMap.put(railProduct, rail.railType);
            }
            switch (rail.transportMode) {
                case TRAIN: {
                    RenderTrains.renderRailStandard(world, rail, 0.065625f, renderColors, 1.0f);
                    if (!renderColors) break;
                    RenderTrains.renderSignalsStandard(world, matrices, vertexConsumers, rail, startPos, endPos);
                    break;
                }
                case BOAT: {
                    if (!renderColors) break;
                    RenderTrains.renderRailStandard(world, rail, 0.065625f, true, 0.5f);
                    RenderTrains.renderSignalsStandard(world, matrices, vertexConsumers, rail, startPos, endPos);
                    break;
                }
                case CABLE_CAR: {
                    if (rail.railType.hasSavedRail || rail.railType == RailType.CABLE_CAR_STATION) {
                        RenderTrains.renderRailStandard(world, rail, 0.253125f, renderColors, 0.25f, "mtr:textures/block/metal.png", 0.25f, 0.0f, 0.75f, 1.0f);
                    }
                    if (renderColors && !rail.railType.hasSavedRail) {
                        RenderTrains.renderRailStandard(world, rail, 0.503125f, true, 1.0f, "mtr:textures/block/one_way_rail_arrow.png", 0.0f, 0.75f, 1.0f, 0.25f);
                    }
                    if (rail.railType == RailType.NONE) break;
                    rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                        int r = renderColors ? rail.railType.color >> 16 & 0xFF : 0;
                        int g = renderColors ? rail.railType.color >> 8 & 0xFF : 0;
                        int b = renderColors ? rail.railType.color & 0xFF : 0;
                        IDrawing.drawLine(matrices, vertexConsumers, (float)x1, (float)y1 + 0.5f, (float)z1, (float)x3, (float)y2 + 0.5f, (float)z3, r, g, b);
                    }, 0.0f, 0.0f);
                    break;
                }
                case AIRPLANE: {
                    if (renderColors) {
                        RenderTrains.renderRailStandard(world, rail, 0.065625f, true, 1.0f);
                        RenderTrains.renderSignalsStandard(world, matrices, vertexConsumers, rail, startPos, endPos);
                        break;
                    }
                    RenderTrains.renderRailStandard(world, rail, 0.065625f, false, 0.25f, "textures/block/iron_block.png", 0.25f, 0.0f, 0.75f, 1.0f);
                }
            }
        });
    }

    private static /* synthetic */ void lambda$render$6(Level world, PoseStack matrices, MultiBufferSource vertexConsumers, float newLastFrameDuration, LiftClient lift) {
        lift.tickClient(world, (x, y, z, frontDoorValue, backDoorValue) -> {
            BlockPos posAverage = TrainRendererBase.applyAverageTransform(lift.getViewOffset(), x, y, z);
            if (posAverage == null) {
                return;
            }
            matrices.m_85837_(x, y, z);
            UtilitiesClient.rotateXDegrees(matrices, 180.0f);
            UtilitiesClient.rotateYDegrees(matrices, 180.0f + lift.facing.m_122435_());
            int light = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, posAverage), (int)world.m_45517_(LightLayer.SKY, posAverage));
            new ModelLift1(lift.liftHeight, lift.liftWidth, lift.liftDepth, lift.isDoubleSided).render(matrices, vertexConsumers, lift, LIFT_TEXTURE, light, frontDoorValue, backDoorValue, false, 0, 1, false, true, false, false, false);
            for (int i = 0; i < (lift.isDoubleSided ? 2 : 1); ++i) {
                UtilitiesClient.rotateYDegrees(matrices, 180.0f);
                matrices.m_85836_();
                matrices.m_85837_(0.875, -1.5, (double)((float)lift.liftDepth / 2.0f) - 0.25 - (double)0.003125f);
                RenderTrains.renderLiftDisplay(matrices, vertexConsumers, posAverage, ClientData.DATA_CACHE.requestLiftFloorText(lift.getCurrentFloorBlockPos())[0], lift.getLiftDirection(), 0.1875f, 0.3125f);
                matrices.m_85849_();
            }
            matrices.m_85849_();
        }, newLastFrameDuration);
    }

    private static /* synthetic */ void lambda$render$4(Level world, float newLastFrameDuration, LocalPlayer player, boolean useAnnouncements, TrainClient train) {
        train.simulateTrain(world, newLastFrameDuration, (speed, stopIndex, routeIds) -> {
            Route thisRoute = train.getThisRoute();
            Station thisStation = train.getThisStation();
            Station nextStation = train.getNextStation();
            Station lastStation = train.getLastStation();
            if (!(!RenderTrains.showShiftProgressBar() || train.isCurrentlyManual() && Train.isHoldingKey((Player)player))) {
                if (speed > 5.0f || thisRoute == null || thisStation == null || lastStation == null) {
                    player.m_5661_((Component)Text.translatable("gui.mtr.vehicle_speed", Float.valueOf(RailwayData.round(speed, 1)), Float.valueOf(RailwayData.round(speed * 3.6f, 1))), true);
                } else {
                    player.m_5661_(switch ((int)(System.currentTimeMillis() / 1000L % 3L)) {
                        default -> RenderTrains.getStationText(thisStation, "this");
                        case 1 -> {
                            if (nextStation == null) {
                                yield RenderTrains.getStationText(thisStation, "this");
                            }
                            yield RenderTrains.getStationText(nextStation, "next");
                        }
                        case 2 -> RenderTrains.getStationText(lastStation, "last_" + thisRoute.transportMode.toString().toLowerCase(Locale.ENGLISH));
                    }, true);
                }
            }
        }, (stopIndex, routeIds) -> {
            Route thisRoute = train.getThisRoute();
            Route nextRoute = train.getNextRoute();
            Station nextStation = train.getNextStation();
            Station lastStation = train.getLastStation();
            if (useAnnouncements && thisRoute != null && nextStation != null && !thisRoute.disableNextStationAnnouncements) {
                Station nextFinalStation;
                String nextRouteSplit;
                ArrayList<String> messages = new ArrayList<String>();
                boolean isLightRailRoute = thisRoute.isLightRailRoute;
                messages.add(IGui.insertTranslation(isLightRailRoute ? "gui.mtr.next_station_light_rail_announcement_cjk" : "gui.mtr.next_station_announcement_cjk", isLightRailRoute ? "gui.mtr.next_station_light_rail_announcement" : "gui.mtr.next_station_announcement", 1, nextStation.name));
                String mergedInterchangeRoutes = RenderTrains.getInterchangeRouteNames(nextStation, thisRoute, nextRoute);
                if (!mergedInterchangeRoutes.isEmpty()) {
                    messages.add(IGui.insertTranslation("gui.mtr.interchange_announcement_cjk", "gui.mtr.interchange_announcement", 1, mergedInterchangeRoutes));
                }
                ArrayList<String> connectingStationList = new ArrayList<String>();
                ((Set)ClientData.DATA_CACHE.stationIdToConnectingStations.get(nextStation)).forEach(connectingStation -> {
                    String connectingStationMergedInterchangeRoutes = RenderTrains.getInterchangeRouteNames(connectingStation, thisRoute, nextRoute);
                    if (!connectingStationMergedInterchangeRoutes.isEmpty()) {
                        connectingStationList.add(IGui.insertTranslation("gui.mtr.connecting_station_interchange_announcement_part_cjk", "gui.mtr.connecting_station_interchange_announcement_part", 2, connectingStationMergedInterchangeRoutes, connectingStation.name));
                    }
                });
                if (!connectingStationList.isEmpty()) {
                    messages.add(IGui.insertTranslation("gui.mtr.connecting_station_part_cjk", "gui.mtr.connecting_station_part", 1, IGui.mergeStationsWithCommas(connectingStationList)));
                }
                String thisRouteSplit = thisRoute.name.split("\\|\\|")[0];
                String string = nextRouteSplit = nextRoute == null ? null : nextRoute.name.split("\\|\\|")[0];
                if (lastStation != null && nextStation.id == lastStation.id && nextRoute != null && !nextRoute.platformIds.isEmpty() && !nextRouteSplit.equals(thisRouteSplit) && (nextFinalStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(nextRoute.getLastPlatformId())) != null) {
                    String modeString = thisRoute.transportMode.toString().toLowerCase(Locale.ENGLISH);
                    if (nextRoute.isLightRailRoute) {
                        messages.add(IGui.insertTranslation("gui.mtr.next_route_" + modeString + "_light_rail_announcement_cjk", "gui.mtr.next_route_" + modeString + "_light_rail_announcement", nextRoute.lightRailRouteNumber, 1, nextFinalStation.name.split("\\|\\|")[0]));
                    } else {
                        messages.add(IGui.insertTranslation("gui.mtr.next_route_" + modeString + "_announcement_cjk", "gui.mtr.next_route_" + modeString + "_announcement", 2, nextRouteSplit, nextFinalStation.name.split("\\|\\|")[0]));
                    }
                }
                IDrawing.narrateOrAnnounce(IGui.mergeStations(messages, "", " "));
            }
        }, (stopIndex, routeIds) -> {
            Route thisRoute = train.getThisRoute();
            Station lastStation = train.getLastStation();
            if (useAnnouncements && thisRoute != null && thisRoute.isLightRailRoute && lastStation != null) {
                IDrawing.narrateOrAnnounce(IGui.insertTranslation("gui.mtr.light_rail_route_announcement_cjk", "gui.mtr.light_rail_route_announcement", thisRoute.lightRailRouteNumber, 1, lastStation.name));
            }
        });
    }

    static {
        creatorProperties = new ResourcePackCreatorProperties();
        AVAILABLE_TEXTURES = new HashSet<String>();
        UNAVAILABLE_TEXTURES = new HashSet<String>();
        RENDERS = new ArrayList<List<Map<ResourceLocation, Set<BiConsumer<PoseStack, VertexConsumer>>>>>(2);
        CURRENT_RENDERS = new ArrayList<List<Map<ResourceLocation, Set<BiConsumer<PoseStack, VertexConsumer>>>>>(2);
        LIFT_TEXTURE = new ResourceLocation("mtr:textures/entity/lift_1.png");
        ARROW_TEXTURE = new ResourceLocation("mtr:textures/block/sign/lift_arrow.png");
        for (int i = 0; i < 2; ++i) {
            int renderStageCount = QueuedRenderLayer.values().length;
            ArrayList rendersList = new ArrayList(renderStageCount);
            ArrayList currentRendersList = new ArrayList(renderStageCount);
            for (int j = 0; j < renderStageCount; ++j) {
                rendersList.add(j, new HashMap());
                currentRendersList.add(j, new HashMap());
            }
            RENDERS.add(i, rendersList);
            CURRENT_RENDERS.add(i, currentRendersList);
        }
    }

    public static enum QueuedRenderLayer {
        LIGHT,
        LIGHT_TRANSLUCENT,
        INTERIOR,
        EXTERIOR;

    }
}

