/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import mtr.Icons;
import mtr.client.DoorAnimationType;
import mtr.client.IDrawing;
import mtr.client.IResourcePackCreatorProperties;
import mtr.data.DataConverter;
import mtr.data.EnumHelper;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.TransportMode;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelTrainBase;
import mtr.render.RenderTrains;
import mtr.screen.DashboardList;
import mtr.screen.ResourcePackCreatorOptionsScreen;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ResourcePackCreatorScreen
extends ScreenMapper
implements IResourcePackCreatorProperties,
IGui,
Icons {
    private int editingPartIndex = -1;
    private final Button buttonOptions = UtilitiesClient.newButton((Component)Text.translatable("menu.options", new Object[0]), button -> {
        if (this.f_96541_ != null) {
            UtilitiesClient.setScreen(this.f_96541_, new ResourcePackCreatorOptionsScreen(this));
        }
    });
    private final DashboardList availableModelPartsList = new DashboardList(null, null, null, null, this::onAdd, null, null, () -> "", text -> {});
    private final DashboardList usedModelPartsList = new DashboardList(null, null, this::onEdit, null, null, this::onDelete, null, () -> "", text -> {});
    private final WidgetShorterSlider sliderCars = new WidgetShorterSlider(0, 0, 31, value -> {
        cars = value + 1;
        this.updateControls(true);
        return Text.translatable("gui.mtr.vehicle_cars", cars).getString();
    }, null);
    private final WidgetShorterSlider sliderBrightness = new WidgetShorterSlider(0, 0, 100, value -> {
        brightness = value;
        this.updateControls(true);
        return Text.translatable("gui.mtr.vehicle_brightness", brightness).getString();
    }, null);
    private final Button buttonToggleTrainDirection = UtilitiesClient.newButton(button -> {
        head1IsFront = !head1IsFront;
        this.updateControls(true);
    });
    private final Button buttonDoorLeft = UtilitiesClient.newButton(button -> {
        openingLeft = !openingLeft;
        this.updateControls(true);
    });
    private final Button buttonDoorRight = UtilitiesClient.newButton(button -> {
        openingRight = !openingRight;
        this.updateControls(true);
    });
    private final Button buttonTransportMode = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editTransportMode();
        this.updateControls(true);
    });
    private final WidgetShorterSlider sliderLength = new WidgetShorterSlider(0, 0, 31, value -> {
        RenderTrains.creatorProperties.editLength(value + 1);
        this.updateControls(true);
        return Text.translatable("gui.mtr.vehicle_length", value + 1).getString();
    }, null);
    private final WidgetShorterSlider sliderWidth = new WidgetShorterSlider(0, 0, 7, value -> {
        RenderTrains.creatorProperties.editWidth(value + 1);
        this.updateControls(true);
        return Text.translatable("gui.mtr.vehicle_width", value + 1).getString();
    }, null);
    private final WidgetShorterSlider sliderDoorMax = new WidgetShorterSlider(0, 0, 31, value -> {
        RenderTrains.creatorProperties.editDoorMax(value + 1);
        this.updateControls(true);
        return Text.translatable("gui.mtr.vehicle_door_max", value + 1).getString();
    }, null);
    private final Button buttonDoorAnimationType = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editDoorAnimationType();
        this.updateControls(true);
    });
    private final Button buttonPartStage = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editPartRenderStage(this.editingPartIndex);
        this.updateControls(true);
    });
    private final WidgetBetterCheckbox checkboxPartMirror = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.part_mirror", new Object[0]), checked -> {
        RenderTrains.creatorProperties.editPartMirror(this.editingPartIndex, checked);
        this.updateControls(true);
    });
    private final WidgetBetterCheckbox checkboxPartSkipRenderingIfTooFar = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.part_skip_rendering_if_too_far", new Object[0]), checked -> {
        RenderTrains.creatorProperties.editPartSkipRenderingIfTooFar(this.editingPartIndex, checked);
        this.updateControls(true);
    });
    private final Button buttonPartDoorOffset = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editPartDoorOffset(this.editingPartIndex);
        this.updateControls(true);
    });
    private final Button buttonPartRenderCondition = UtilitiesClient.newButton(button -> {
        RenderTrains.creatorProperties.editPartRenderCondition(this.editingPartIndex);
        this.updateControls(true);
    });
    private final WidgetBetterTextField textFieldPositions = new WidgetBetterTextField("[^\\d.,\\[\\]\\- ]", "[0,0]", Integer.MAX_VALUE);
    private final WidgetBetterTextField textFieldWhitelistedCars = new WidgetBetterTextField("[^%\\d,+\\- ]", "5,-4,%3,%2+1", Integer.MAX_VALUE);
    private final WidgetBetterTextField textFieldBlacklistedCars = new WidgetBetterTextField("[^%\\d,+\\- ]", "5,-4,%3,%2+1", Integer.MAX_VALUE);
    private final Button buttonDone = UtilitiesClient.newButton((Component)Text.translatable("gui.done", new Object[0]), button -> {
        this.editingPartIndex = -1;
        this.updateControls(true);
    });
    private static int guiCounter;
    private static boolean hideGui;
    private static float translation;
    private static float yaw;
    private static float roll;
    private static float scale;
    private static int cars;
    private static int brightness;
    private static boolean head1IsFront;
    private static float doorLeftValue;
    private static float doorRightValue;
    private static boolean openingLeft;
    private static boolean openingRight;
    private static final int MIN_SCALE = 1;
    private static final float MOUSE_SCALE = 0.005f;

    public ResourcePackCreatorScreen() {
        super((Component)Text.literal(""));
    }

    protected void m_7856_() {
        super.m_7856_();
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonOptions, 0, this.f_96544_ - 20, 144);
        this.availableModelPartsList.x = 0;
        this.availableModelPartsList.y = 20;
        this.availableModelPartsList.width = 144;
        this.availableModelPartsList.height = this.f_96544_ - 40;
        this.usedModelPartsList.y = 90;
        this.usedModelPartsList.width = 144;
        this.usedModelPartsList.height = this.f_96544_ - 90;
        int textWidth1 = Math.max(this.f_96547_.m_92852_((FormattedText)Text.translatable("gui.mtr.vehicle_cars", 88)), this.f_96547_.m_92852_((FormattedText)Text.translatable("gui.mtr.vehicle_brightness", 888)));
        int remainingWidth = this.f_96543_ - 288 - 16;
        UtilitiesClient.setWidgetX((AbstractWidget)this.sliderCars, 152);
        UtilitiesClient.setWidgetY((AbstractWidget)this.sliderCars, this.f_96544_ - 8 - 60);
        this.sliderCars.m_93674_(remainingWidth - 6 - textWidth1);
        this.sliderCars.setHeight(10);
        this.sliderCars.setValue(-1);
        UtilitiesClient.setWidgetX((AbstractWidget)this.sliderBrightness, 152);
        UtilitiesClient.setWidgetY((AbstractWidget)this.sliderBrightness, this.f_96544_ - 8 - 50);
        this.sliderBrightness.m_93674_(remainingWidth - 6 - textWidth1);
        this.sliderBrightness.setHeight(10);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonToggleTrainDirection, 152, this.f_96544_ - 8 - 40, remainingWidth);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDoorLeft, 152, this.f_96544_ - 8 - 20, remainingWidth / 2);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDoorRight, 152 + remainingWidth / 2, this.f_96544_ - 8 - 20, remainingWidth / 2);
        int xStart = this.f_96543_ - 144;
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonTransportMode, xStart, 0, 144);
        MutableComponent lengthText = Text.translatable("gui.mtr.vehicle_length", 88);
        MutableComponent widthText = Text.translatable("gui.mtr.vehicle_width", 88);
        MutableComponent doorMaxText = Text.translatable("gui.mtr.vehicle_door_max", 88);
        int textWidth2 = Math.max(this.f_96547_.m_92852_((FormattedText)lengthText), Math.max(this.f_96547_.m_92852_((FormattedText)widthText), this.f_96547_.m_92852_((FormattedText)doorMaxText))) + 12;
        UtilitiesClient.setWidgetX((AbstractWidget)this.sliderLength, xStart);
        UtilitiesClient.setWidgetY((AbstractWidget)this.sliderLength, 20);
        this.sliderLength.m_93674_(144 - textWidth2);
        this.sliderLength.setHeight(10);
        this.sliderLength.setValue(RenderTrains.creatorProperties.getLength() - 1);
        UtilitiesClient.setWidgetX((AbstractWidget)this.sliderWidth, xStart);
        UtilitiesClient.setWidgetY((AbstractWidget)this.sliderWidth, 30);
        this.sliderWidth.m_93674_(144 - textWidth2);
        this.sliderWidth.setHeight(10);
        this.sliderWidth.setValue(RenderTrains.creatorProperties.getWidth() - 1);
        UtilitiesClient.setWidgetX((AbstractWidget)this.sliderDoorMax, xStart);
        UtilitiesClient.setWidgetY((AbstractWidget)this.sliderDoorMax, 40);
        this.sliderDoorMax.m_93674_(144 - textWidth2);
        this.sliderDoorMax.setHeight(10);
        this.sliderDoorMax.setValue(RenderTrains.creatorProperties.getDoorMax() - 1);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDoorAnimationType, xStart, 50, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonPartStage, xStart, 0, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.checkboxPartMirror, xStart, 20, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.checkboxPartSkipRenderingIfTooFar, xStart, 40, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonPartDoorOffset, xStart, 60, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonPartRenderCondition, xStart, 80, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldPositions, this.f_96543_, 116, 140);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldWhitelistedCars, this.f_96543_, 154, 140);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldBlacklistedCars, this.f_96543_, 192, 140);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDone, xStart, this.f_96544_ - 20, 144);
        this.textFieldPositions.m_94151_(text -> {
            RenderTrains.creatorProperties.editPartPositions(this.editingPartIndex, this.textFieldPositions.m_94155_());
            this.updateControls(false);
        });
        this.textFieldWhitelistedCars.m_94151_(text -> {
            RenderTrains.creatorProperties.editPartWhitelistedCars(this.editingPartIndex, this.textFieldWhitelistedCars.m_94155_());
            this.updateControls(false);
        });
        this.textFieldBlacklistedCars.m_94151_(text -> {
            RenderTrains.creatorProperties.editPartBlacklistedCars(this.editingPartIndex, this.textFieldBlacklistedCars.m_94155_());
            this.updateControls(false);
        });
        this.updateControls(true);
        this.addDrawableChild(this.buttonOptions);
        this.availableModelPartsList.init(this::addDrawableChild);
        this.usedModelPartsList.init(this::addDrawableChild);
        this.addDrawableChild(this.sliderCars);
        this.addDrawableChild(this.sliderBrightness);
        this.addDrawableChild(this.buttonToggleTrainDirection);
        this.addDrawableChild(this.buttonDoorLeft);
        this.addDrawableChild(this.buttonDoorRight);
        this.addDrawableChild(this.buttonTransportMode);
        this.addDrawableChild(this.sliderLength);
        this.addDrawableChild(this.sliderWidth);
        this.addDrawableChild(this.sliderDoorMax);
        this.addDrawableChild(this.buttonDoorAnimationType);
        this.addDrawableChild(this.buttonPartStage);
        this.addDrawableChild(this.checkboxPartMirror);
        this.addDrawableChild(this.checkboxPartSkipRenderingIfTooFar);
        this.addDrawableChild(this.buttonPartDoorOffset);
        this.addDrawableChild(this.buttonPartRenderCondition);
        this.addDrawableChild(this.textFieldPositions);
        this.addDrawableChild(this.textFieldWhitelistedCars);
        this.addDrawableChild(this.textFieldBlacklistedCars);
        this.addDrawableChild(this.buttonDone);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            if (guiCounter == 0 && this.f_96541_ != null) {
                hideGui = this.f_96541_.f_91066_.f_92062_;
                Gui.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)-16777216);
            }
            Gui.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)144, (int)this.f_96544_, (int)-15592942);
            Gui.m_93172_((PoseStack)matrices, (int)(this.f_96543_ - 144), (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)-15592942);
            this.availableModelPartsList.render(matrices, this.f_96547_);
            this.usedModelPartsList.render(matrices, this.f_96547_);
            super.m_6305_(matrices, mouseX, mouseY, delta);
            ResourcePackCreatorScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.available_model_parts", new Object[0]), (int)72, (int)6, (int)-1);
            ResourcePackCreatorScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.used_model_parts", new Object[0]), (int)(72 + this.usedModelPartsList.x), (int)76, (int)-1);
            ResourcePackCreatorScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.part_positions", new Object[0]), (int)(72 + UtilitiesClient.getWidgetX((AbstractWidget)this.textFieldPositions) - 2), (int)106, (int)-1);
            ResourcePackCreatorScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.part_whitelisted_cars", new Object[0]), (int)(72 + UtilitiesClient.getWidgetX((AbstractWidget)this.textFieldWhitelistedCars) - 2), (int)144, (int)-1);
            ResourcePackCreatorScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.part_blacklisted_cars", new Object[0]), (int)(72 + UtilitiesClient.getWidgetX((AbstractWidget)this.textFieldBlacklistedCars) - 2), (int)182, (int)-1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        guiCounter = 2;
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.availableModelPartsList.mouseMoved(mouseX, mouseY);
        this.usedModelPartsList.mouseMoved(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (mouseX >= 144.0 && mouseX < (double)(this.f_96543_ - 144)) {
            scale = Math.max(scale - (float)amount, 1.0f);
            float bound = (float)(cars * RenderTrains.creatorProperties.getLength()) / 2.0f;
            translation = Mth.m_14036_((float)translation, (float)(-bound), (float)bound);
        }
        this.availableModelPartsList.mouseScrolled(mouseX, mouseY, amount);
        this.usedModelPartsList.mouseScrolled(mouseX, mouseY, amount);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseX >= 144.0 && mouseX < (double)(this.f_96543_ - 144) && mouseY < (double)(this.f_96544_ - 8 - 60)) {
            if (button == 0) {
                Vec3 movement = new Vec3(0.0, deltaY * (double)0.005f * (double)scale, deltaX * (double)0.005f * (double)scale).m_82524_(yaw).m_82535_(roll);
                float bound = (float)(cars * RenderTrains.creatorProperties.getLength()) / 2.0f;
                translation = Mth.m_14036_((float)(translation - (float)movement.f_82481_), (float)(-bound), (float)bound);
            } else {
                roll = (float)((double)roll - (double)((float)deltaY * 0.005f * scale) * Math.cos(yaw -= (float)deltaX * 0.005f * scale));
            }
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_96624_() {
        this.availableModelPartsList.tick();
        this.usedModelPartsList.tick();
        this.textFieldPositions.m_94120_();
        this.textFieldWhitelistedCars.m_94120_();
        this.textFieldBlacklistedCars.m_94120_();
        float maxTime = EnumHelper.valueOf(DoorAnimationType.STANDARD, (String)RenderTrains.creatorProperties.getDoorAnimationType()).maxTime;
        float increment = 0.015625f;
        if (openingLeft) {
            if (doorLeftValue < maxTime) {
                doorLeftValue = Math.min(maxTime, doorLeftValue + 0.015625f);
            }
        } else if (doorLeftValue > 0.0f) {
            doorLeftValue = Math.max(0.0f, doorLeftValue - 0.015625f);
        }
        if (openingRight) {
            if (doorRightValue < maxTime) {
                doorRightValue = Math.min(maxTime, doorRightValue + 0.015625f);
            }
        } else if (doorRightValue > 0.0f) {
            doorRightValue = Math.max(0.0f, doorRightValue - 0.015625f);
        }
    }

    private List<DataConverter> updatePartsList(JsonArray jsonArray, Function<JsonObject, Integer> color, Function<JsonObject, String> extraText) {
        ArrayList<DataConverter> listData = new ArrayList<DataConverter>();
        if (jsonArray.size() > 0) {
            try {
                jsonArray.forEach(jsonElement -> {
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    String name = jsonObject.get("name").getAsString();
                    listData.add(new DataConverter(extraText == null ? name : ((String)extraText.apply(jsonObject)).replace("%s", name), 0xFF000000 | (color == null ? 0 : (Integer)color.apply(jsonObject))));
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return listData;
    }

    private void updateControls(boolean formatTextFields) {
        int sliderDoorMaxValue;
        int sliderWidthValue;
        this.availableModelPartsList.setData(this.updatePartsList(RenderTrains.creatorProperties.getModelPartsArray(), null, null), false, false, false, false, true, false);
        JsonArray partsArray = RenderTrains.creatorProperties.getPropertiesPartsArray();
        this.usedModelPartsList.setData(this.updatePartsList(partsArray, ResourcePackCreatorScreen::getColor, ResourcePackCreatorScreen::getName), false, false, true, false, false, true);
        String transportModeString = RenderTrains.creatorProperties.getTransportMode();
        this.buttonTransportMode.m_93666_((Component)Text.translatable("gui.mtr.transport_mode_" + transportModeString.toLowerCase(Locale.ENGLISH), new Object[0]));
        cars = Mth.m_14045_((int)cars, (int)1, (int)Math.min(32, EnumHelper.valueOf(TransportMode.TRAIN, (String)transportModeString).maxLength));
        this.buttonDoorAnimationType.m_93666_((Component)Text.translatable("gui.mtr.door_animation_type_" + RenderTrains.creatorProperties.getDoorAnimationType().toLowerCase(Locale.ENGLISH), new Object[0]));
        int sliderCarsValue = cars - 1;
        if (sliderCarsValue != this.sliderCars.getIntValue()) {
            this.sliderCars.setValue(sliderCarsValue);
        }
        if (brightness != this.sliderBrightness.getIntValue()) {
            this.sliderBrightness.setValue(brightness);
        }
        this.buttonToggleTrainDirection.m_93666_((Component)Text.translatable("gui.mtr.vehicle_direction_" + (head1IsFront ? "forwards" : "backwards"), new Object[0]));
        this.buttonDoorLeft.m_93666_((Component)Text.literal(openingLeft ? "\u25b6|\u25c0" : "\u25c0|\u25b6").m_130946_(" ").m_7220_((Component)Text.translatable("gui.mtr.left", new Object[0])));
        this.buttonDoorRight.m_93666_((Component)Text.literal(openingRight ? "\u25b6|\u25c0" : "\u25c0|\u25b6").m_130946_(" ").m_7220_((Component)Text.translatable("gui.mtr.right", new Object[0])));
        int sliderLengthValue = RenderTrains.creatorProperties.getLength() - 1;
        if (sliderLengthValue != this.sliderLength.getIntValue()) {
            this.sliderLength.setValue(sliderLengthValue);
        }
        if ((sliderWidthValue = RenderTrains.creatorProperties.getWidth() - 1) != this.sliderWidth.getIntValue()) {
            this.sliderWidth.setValue(sliderWidthValue);
        }
        if ((sliderDoorMaxValue = RenderTrains.creatorProperties.getDoorMax() - 1) != this.sliderDoorMax.getIntValue()) {
            this.sliderDoorMax.setValue(sliderDoorMaxValue);
        }
        if (this.editingPartIndex >= 0 && this.editingPartIndex < partsArray.size()) {
            this.buttonTransportMode.f_93624_ = false;
            this.sliderLength.f_93624_ = false;
            this.sliderWidth.f_93624_ = false;
            this.sliderDoorMax.f_93624_ = false;
            this.buttonDoorAnimationType.f_93624_ = false;
            this.buttonPartStage.f_93624_ = true;
            this.checkboxPartMirror.f_93624_ = true;
            this.checkboxPartSkipRenderingIfTooFar.f_93624_ = true;
            this.buttonPartDoorOffset.f_93624_ = true;
            this.buttonPartRenderCondition.f_93624_ = true;
            UtilitiesClient.setWidgetX((AbstractWidget)this.textFieldPositions, this.f_96543_ - 144 + 2);
            UtilitiesClient.setWidgetX((AbstractWidget)this.textFieldWhitelistedCars, this.f_96543_ - 144 + 2);
            UtilitiesClient.setWidgetX((AbstractWidget)this.textFieldBlacklistedCars, this.f_96543_ - 144 + 2);
            this.buttonDone.f_93624_ = true;
            this.usedModelPartsList.x = this.f_96543_;
            JsonObject partObject = partsArray.get(this.editingPartIndex).getAsJsonObject();
            this.buttonPartStage.m_93666_((Component)Text.translatable("gui.mtr.part_stage_" + partObject.get("stage").getAsString().toLowerCase(Locale.ENGLISH), new Object[0]));
            this.checkboxPartMirror.setChecked(partObject.get("mirror").getAsBoolean());
            this.checkboxPartSkipRenderingIfTooFar.setChecked(partObject.get("skip_rendering_if_too_far").getAsBoolean());
            this.buttonPartDoorOffset.m_93666_((Component)Text.translatable("gui.mtr.part_door_offset_" + partObject.get("door_offset").getAsString().toLowerCase(Locale.ENGLISH), new Object[0]));
            this.buttonPartRenderCondition.m_93666_((Component)Text.translatable("gui.mtr.part_render_condition_" + partObject.get("render_condition").getAsString().toLowerCase(Locale.ENGLISH), new Object[0]));
            if (formatTextFields) {
                StringBuilder positionsString = new StringBuilder();
                JsonArray positionsArray = partObject.getAsJsonArray("positions");
                for (int i = 0; i < positionsArray.size(); ++i) {
                    try {
                        JsonArray positionArray = positionsArray.get(i).getAsJsonArray();
                        positionsString.append("[").append(positionArray.get(0).getAsFloat()).append(",").append(positionArray.get(1).getAsFloat()).append("],");
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.textFieldPositions.m_94144_(positionsString.toString().replace(".0,", ",").replace(".0]", "]"));
                this.textFieldWhitelistedCars.m_94144_(partObject.get("whitelisted_cars").toString());
                this.textFieldBlacklistedCars.m_94144_(partObject.get("blacklisted_cars").toString());
            }
        } else {
            this.buttonTransportMode.f_93624_ = true;
            this.sliderLength.f_93624_ = true;
            this.sliderWidth.f_93624_ = true;
            this.sliderDoorMax.f_93624_ = true;
            this.buttonDoorAnimationType.f_93624_ = true;
            this.buttonPartStage.f_93624_ = false;
            this.checkboxPartMirror.f_93624_ = false;
            this.checkboxPartSkipRenderingIfTooFar.f_93624_ = false;
            this.buttonPartDoorOffset.f_93624_ = false;
            this.buttonPartRenderCondition.f_93624_ = false;
            UtilitiesClient.setWidgetX((AbstractWidget)this.textFieldPositions, this.f_96543_ + 2);
            UtilitiesClient.setWidgetX((AbstractWidget)this.textFieldWhitelistedCars, this.f_96543_ + 2);
            UtilitiesClient.setWidgetX((AbstractWidget)this.textFieldBlacklistedCars, this.f_96543_ + 2);
            this.buttonDone.f_93624_ = false;
            this.usedModelPartsList.x = this.f_96543_ - 144;
        }
    }

    private void onAdd(NameColorDataBase data, int index) {
        RenderTrains.creatorProperties.addPart(data.name);
        this.updateControls(true);
    }

    private void onEdit(NameColorDataBase data, int index) {
        this.editingPartIndex = index;
        this.updateControls(true);
    }

    private void onDelete(NameColorDataBase data, int index) {
        RenderTrains.creatorProperties.removePart(index);
        this.editingPartIndex = -1;
        this.updateControls(true);
    }

    public static void render(PoseStack matrices) {
        if (guiCounter > 0) {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.f_91066_.f_92062_ = --guiCounter != 0 || hideGui;
            matrices.m_85836_();
            MultiBufferSource.BufferSource immediate = minecraft.m_91269_().m_110104_();
            IDrawing.drawTexture(matrices, immediate.m_6299_(RenderType.m_110451_()), -2.1474836E9f, 2.1474836E9f, -256.0f, 2.1474836E9f, -2.1474836E9f, -256.0f, Direction.UP, -16777216, 0);
            immediate.m_109911_();
            matrices.m_85837_(0.0, 0.0, (double)(-scale));
            UtilitiesClient.rotateYDegrees(matrices, 90.0f);
            UtilitiesClient.rotateXDegrees(matrices, 180.0f);
            UtilitiesClient.rotateY(matrices, yaw);
            UtilitiesClient.rotateZ(matrices, roll);
            int light = LightTexture.m_109885_((int)0, (int)((int)Math.round((double)brightness / 100.0 * 15.0)));
            for (int i = 0; i < cars; ++i) {
                matrices.m_85836_();
                matrices.m_85837_(0.0, 0.0, (double)(((float)i - (float)(cars - 1) / 2.0f) * (float)(RenderTrains.creatorProperties.getLength() + 1) + translation));
                RenderTrains.creatorProperties.render(matrices, i, cars, head1IsFront, doorLeftValue, doorRightValue, openingRight || openingLeft, light);
                matrices.m_85849_();
            }
            matrices.m_85849_();
        }
    }

    private static int getColor(JsonObject jsonObject) {
        ModelTrainBase.RenderStage renderStage = EnumHelper.valueOf(ModelTrainBase.RenderStage.EXTERIOR, jsonObject.get("stage").getAsString());
        switch (renderStage) {
            case EXTERIOR: {
                return 6405455;
            }
            case INTERIOR: {
                return 15022389;
            }
            case INTERIOR_TRANSLUCENT: {
                return 16485376;
            }
            case LIGHTS: {
                return 15914496;
            }
            case ALWAYS_ON_LIGHTS: {
                return 2001125;
            }
        }
        return 0;
    }

    private static String getName(JsonObject jsonObject) {
        boolean mirror = jsonObject.get("mirror").getAsBoolean();
        int positionCount = jsonObject.getAsJsonArray("positions").size();
        return (mirror ? "*" : "") + "%s (" + positionCount + "x)";
    }

    static {
        scale = 10.0f;
        brightness = 50;
        head1IsFront = true;
        doorLeftValue = 0.0f;
        doorRightValue = 0.0f;
        openingLeft = false;
        openingRight = false;
    }
}

