/*
 * Decompiled with CFR 0.152.
 */
package mtr.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.RailwayDataRouteFinderModule;
import mtr.data.Route;
import mtr.data.Station;
import mtr.libraries.javax.servlet.AsyncContext;
import mtr.libraries.javax.servlet.http.HttpServlet;
import mtr.libraries.javax.servlet.http.HttpServletRequest;
import mtr.libraries.javax.servlet.http.HttpServletResponse;
import mtr.servlet.IServletHandler;
import mtr.servlet.Webserver;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RouteFinderServletHandler
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(-1L);
        Webserver.callback.accept(() -> {
            RailwayData railwayData;
            ArrayList<String> errors = new ArrayList<String>();
            String parameterStartPlayer = request.getParameter("startPlayer");
            String parameterEndPlayer = request.getParameter("endPlayer");
            String parameterStartStation = request.getParameter("startStation");
            String parameterEndStation = request.getParameter("endStation");
            String parameterStartPos = request.getParameter("startPos");
            String parameterEndPos = request.getParameter("endPos");
            int maxTickTime = 40;
            try {
                maxTickTime = Integer.parseInt(request.getParameter("maxTickTime"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Level world = RouteFinderServletHandler.getWorldFromParameter(request.getParameter("dimension"), errors);
            if (world != null && (railwayData = RailwayData.getInstance(world)) != null) {
                PositionInfo startPositionInfo = RouteFinderServletHandler.getPosition(world, railwayData, parameterStartPlayer, parameterStartStation, parameterStartPos, true, errors);
                PositionInfo endPositionInfo = RouteFinderServletHandler.getPosition(world, railwayData, parameterEndPlayer, parameterEndStation, parameterEndPos, false, errors);
                if (startPositionInfo != null && endPositionInfo != null && errors.isEmpty() && !railwayData.railwayDataRouteFinderModule.findRoute(startPositionInfo.pos, endPositionInfo.pos, maxTickTime, (dataList, duration) -> {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.add("start", (JsonElement)startPositionInfo.toJsonObject());
                    jsonObject.add("end", (JsonElement)endPositionInfo.toJsonObject());
                    jsonObject.addProperty("response", (Number)duration);
                    JsonArray jsonArrayData = new JsonArray();
                    for (RailwayDataRouteFinderModule.RouteFinderData data : dataList) {
                        PositionInfo positionInfo = new PositionInfo(data.pos, railwayData, null, null, false);
                        JsonObject jsonObjectData = positionInfo.toJsonObject();
                        jsonObjectData.addProperty("duration", (Number)data.duration);
                        Route route = railwayData.dataCache.routeIdMap.get(data.routeId);
                        if (route != null) {
                            JsonObject jsonObjectRoute = new JsonObject();
                            jsonObjectRoute.addProperty("wait", (Number)data.waitingTime);
                            jsonObjectRoute.addProperty("color", (Number)route.color);
                            jsonObjectRoute.addProperty("name", route.name);
                            jsonObjectRoute.addProperty("number", route.isLightRailRoute ? route.lightRailRouteNumber : "");
                            jsonObjectRoute.addProperty("type", IServletHandler.createRouteKey(route.transportMode, route.routeType));
                            jsonObjectRoute.addProperty("circular", route.circularState == Route.CircularState.NONE ? "" : (route.circularState == Route.CircularState.CLOCKWISE ? "cw" : "ccw"));
                            JsonArray jsonArrayRouteStations = new JsonArray();
                            data.stationIds.forEach(stationId -> jsonArrayRouteStations.add(String.valueOf(stationId)));
                            jsonObjectRoute.add("stations", (JsonElement)jsonArrayRouteStations);
                            jsonObjectData.add("route", (JsonElement)jsonObjectRoute);
                        }
                        jsonArrayData.add((JsonElement)jsonObjectData);
                        if (!endPositionInfo.isStationParameter || positionInfo.station != endPositionInfo.station) continue;
                        break;
                    }
                    jsonObject.add("directions", (JsonElement)jsonArrayData);
                    IServletHandler.sendResponse(response, asyncContext, jsonObject.toString());
                })) {
                    errors.add("Too many requests! Please try again.");
                }
            }
            if (!errors.isEmpty()) {
                JsonObject jsonObject = new JsonObject();
                JsonArray jsonArray = new JsonArray();
                errors.forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
                jsonObject.add("errors", (JsonElement)jsonArray);
                IServletHandler.sendResponse(response, asyncContext, jsonObject.toString());
            }
        });
    }

    private static Level getWorldFromParameter(String parameterDimension, List<String> errors) {
        block5: {
            if (parameterDimension == null) {
                errors.add("The 'dimension' parameter must be defined.");
            } else {
                List<Level> worlds = Webserver.getWorlds.get();
                try {
                    return worlds.get(Integer.parseInt(parameterDimension));
                }
                catch (Exception exception) {
                    for (Level world : worlds) {
                        ResourceLocation dimensionLocation = world.m_46472_().m_135782_();
                        if (!parameterDimension.equalsIgnoreCase(dimensionLocation.toString()) && !parameterDimension.equalsIgnoreCase(dimensionLocation.m_135815_())) continue;
                        return world;
                    }
                    if (worlds.size() <= 1) break block5;
                    errors.add(String.format("The 'dimension' parameter must be a world index (0-%s) or a valid world ID (such as %s).", worlds.size() - 1, worlds.get(0).m_46472_().m_135782_().toString()));
                }
            }
        }
        return null;
    }

    private static PositionInfo getPosition(Level world, RailwayData railwayData, String parameterPlayer, String parameterStation, String parameterPos, boolean isStart, List<String> errors) {
        if (parameterPlayer != null) {
            for (Player player : world.m_6907_()) {
                String playerName = player.m_7755_().getString();
                if (!playerName.equalsIgnoreCase(parameterPlayer)) continue;
                return new PositionInfo(player.m_142538_(), railwayData, null, playerName, false);
            }
            errors.add(String.format("The player '%s' is not online or in the specified dimension.", parameterPlayer));
        } else if (parameterStation != null) {
            try {
                Station station3 = railwayData.dataCache.stationIdMap.get(Long.parseLong(parameterStation));
                return new PositionInfo(station3.getCenter(), railwayData, station3, null, true);
            }
            catch (Exception station3) {
                try {
                    for (Station station2 : railwayData.stations) {
                        List<String> stationNameSplit = Arrays.asList(station2.name.toLowerCase(Locale.ENGLISH).split("\\|"));
                        if (!Arrays.stream(parameterStation.toLowerCase(Locale.ENGLISH).split("\\|")).allMatch(stationNameSplit::contains)) continue;
                        return new PositionInfo(station2.getCenter(), railwayData, station2, null, true);
                    }
                }
                catch (Exception station3) {
                    // empty catch block
                }
                errors.add(String.format("The station '%s' does not exist in the specified dimension.", parameterStation));
            }
        } else if (parameterPos != null) {
            try {
                String[] coordinates = parameterPos.split(",");
                return new PositionInfo(new BlockPos(Double.parseDouble(coordinates[0]), Double.parseDouble(coordinates[1]), Double.parseDouble(coordinates[2])), railwayData, null, null, false);
            }
            catch (Exception coordinates) {
                errors.add(String.format("The block position '%s' is not formatted correctly.", parameterPos));
            }
        } else {
            String key = isStart ? "start" : "end";
            errors.add(String.format("One of '%sPlayer', '%sStation', or '%sPos' must be defined.", key, key, key));
        }
        return null;
    }

    private static class PositionInfo {
        private final BlockPos pos;
        private final Station station;
        private final String playerName;
        private final Platform platform;
        private final boolean isStationParameter;

        private PositionInfo(BlockPos pos, RailwayData railwayData, Station station, String playerName, boolean isStationParameter) {
            this.pos = pos;
            this.station = station == null ? RailwayData.getStation(railwayData.stations, railwayData.dataCache, pos) : station;
            this.playerName = playerName;
            this.platform = railwayData.dataCache.platformIdMap.get(RailwayData.getClosePlatformId(railwayData.platforms, railwayData.dataCache, pos));
            this.isStationParameter = isStationParameter;
        }

        private JsonObject toJsonObject() {
            JsonObject jsonObject = new JsonObject();
            JsonArray jsonArrayPos = new JsonArray();
            jsonArrayPos.add((Number)this.pos.m_123341_());
            jsonArrayPos.add((Number)this.pos.m_123342_());
            jsonArrayPos.add((Number)this.pos.m_123343_());
            jsonObject.add("pos", (JsonElement)jsonArrayPos);
            if (this.station != null) {
                JsonObject jsonObjectStation = new JsonObject();
                jsonObjectStation.addProperty("name", this.station.name);
                jsonObjectStation.addProperty("id", String.valueOf(this.station.id));
                jsonObject.add("station", (JsonElement)jsonObjectStation);
            }
            if (this.platform != null) {
                jsonObject.addProperty("platform", this.platform.name);
            }
            if (this.playerName != null) {
                jsonObject.addProperty("player", this.playerName);
            }
            return jsonObject;
        }
    }
}

