/*
 * Decompiled with CFR 0.152.
 */
package mtr.sound.bve;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.sound.bve.ConfigFile;
import mtr.sound.bve.MotorData4;
import mtr.sound.bve.MotorData5;
import mtr.sound.bve.MotorDataBase;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.IOUtils;

public class BveTrainSoundConfig {
    public final String baseName;
    public final String audioBaseName;
    public final ConfigFile soundCfg;
    public final MotorDataBase motorData;

    public BveTrainSoundConfig(ResourceManager manager, String baseName) {
        ResourceLocation baseLocation = new ResourceLocation((String)(baseName.contains(":") ? baseName : "mtr:" + baseName));
        this.baseName = baseLocation.toString();
        String configBaseName = baseLocation.m_135827_() + ":sounds/" + baseLocation.m_135815_();
        this.audioBaseName = baseLocation.m_135827_() + ":" + baseLocation.m_135815_() + "_";
        this.soundCfg = new ConfigFile(BveTrainSoundConfig.readResource(manager, new ResourceLocation(configBaseName + "/sound.cfg")), this);
        this.motorData = this.soundCfg.motorNoiseDataType == 4 ? new MotorData4(manager, configBaseName) : new MotorData5(manager, configBaseName);
    }

    public static String readResource(ResourceManager manager, ResourceLocation location) {
        try {
            List<Resource> resources = UtilitiesClient.getResources(manager, location);
            if (resources.size() < 1) {
                return "";
            }
            return IOUtils.toString((InputStream)Utilities.getInputStream(resources.get(0)), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }
}

