/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.forge;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import mcp.mobius.waila.api.Accessor;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import snownee.jade.Jade;
import snownee.jade.JadeCommonConfig;
import snownee.jade.VanillaPlugin;

public class InventoryProvider
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    public static final InventoryProvider INSTANCE = new InventoryProvider();
    public static final Set<String> INVENTORY_IGNORE = Collections.synchronizedSet(Sets.newHashSet());

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(VanillaPlugin.INVENTORY) || accessor.getBlockEntity() == null || accessor.getBlockEntity() instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        InventoryProvider.append(tooltip, accessor);
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor) {
        if (accessor.getServerData().m_128471_("Loot")) {
            tooltip.add((Component)new TranslatableComponent("jade.not_generated"), VanillaPlugin.INVENTORY);
            return;
        }
        if (accessor.getServerData().m_128471_("Locked")) {
            tooltip.add((Component)new TranslatableComponent("jade.locked"), VanillaPlugin.INVENTORY);
            return;
        }
        if (accessor.getServerData().m_128441_("jadeHandler")) {
            ItemStack stack;
            ItemStack stack2;
            ItemStackHandler itemHandler = new ItemStackHandler();
            itemHandler.deserializeNBT(accessor.getServerData().m_128469_("jadeHandler"));
            int drawnCount = 0;
            int realSize = 0;
            for (int i = 0; i < itemHandler.getSlots() && !(stack2 = itemHandler.getStackInSlot(i)).m_41619_(); ++i) {
                ++realSize;
            }
            boolean showName = realSize < 5;
            IElementHelper helper = tooltip.getElementHelper();
            ArrayList elements = Lists.newArrayList();
            for (int i = 0; i < itemHandler.getSlots() && !(stack = itemHandler.getStackInSlot(i)).m_41619_(); ++i) {
                if (i > 0 && (showName || drawnCount >= JadeCommonConfig.inventoryShowItemPreLine)) {
                    tooltip.add(elements);
                    elements.clear();
                    drawnCount = 0;
                }
                if (showName) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41764_(1);
                    elements.add(Jade.smallItem(helper, copy).tag(VanillaPlugin.INVENTORY));
                    elements.add(helper.text((Component)new TextComponent(Integer.toString(stack.m_41613_())).m_130946_("\u00d7 ").m_7220_(stack.m_41786_())).tag(VanillaPlugin.INVENTORY).message(null));
                } else {
                    elements.add(helper.item(stack).tag(VanillaPlugin.INVENTORY));
                }
                ++drawnCount;
            }
            if (!elements.isEmpty()) {
                tooltip.add(elements);
            }
        }
    }

    @Override
    public void appendServerData(CompoundTag tag, ServerPlayer player, Level world, BlockEntity te, boolean showDetails) {
        int size;
        if (te == null || JadeCommonConfig.shouldIgnoreTE(tag.m_128461_("id")) || te instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        int n = size = showDetails ? JadeCommonConfig.inventoryDetailedShowAmount : JadeCommonConfig.inventoryNormalShowAmount;
        if (size == 0) {
            return;
        }
        if (te instanceof RandomizableContainerBlockEntity && ((RandomizableContainerBlockEntity)te).f_59605_ != null) {
            tag.m_128379_("Loot", true);
            return;
        }
        if (!JadeCommonConfig.bypassLockedContainer && !player.m_7500_() && !player.m_5833_() && te instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity lockableBlockEntity = (BaseContainerBlockEntity)te;
            if (lockableBlockEntity.f_58621_ != LockCode.f_19102_) {
                tag.m_128379_("Locked", true);
                return;
            }
        }
        IItemHandler itemHandler = null;
        LazyOptional optional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (optional.isPresent()) {
            itemHandler = (IItemHandler)optional.orElse(null);
        } else if (te instanceof Container) {
            itemHandler = new InvWrapper((Container)te);
        } else if (te instanceof EnderChestBlockEntity) {
            itemHandler = new InvWrapper((Container)player.m_36327_());
        }
        InventoryProvider.putInvData(tag, itemHandler, size, 0);
    }

    public static void putInvData(CompoundTag tag, IItemHandler itemHandler, int size, int start) {
        if (itemHandler == null || size == 0) {
            return;
        }
        ItemStackHandler mergedHandler = new ItemStackHandler(size);
        boolean empty = true;
        int max = Math.min(itemHandler.getSlots(), start + size * 3);
        block0: for (int i = start; i < max; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.m_41782_() && stack.m_41783_().m_128441_("CustomModelData")) {
                for (String key : stack.m_41783_().m_128431_()) {
                    if (!key.toLowerCase(Locale.ENGLISH).endsWith("clear") || !stack.m_41783_().m_128471_(key)) continue;
                    continue block0;
                }
            }
            if (stack.m_41619_()) continue;
            empty = false;
            ItemHandlerHelper.insertItemStacked((IItemHandler)mergedHandler, (ItemStack)stack.m_41777_(), (boolean)false);
            if (!mergedHandler.getStackInSlot(size - 1).m_41619_()) break;
        }
        if (!empty) {
            tag.m_128365_("jadeHandler", (Tag)mergedHandler.serializeNBT());
        }
    }
}

