/*
 * Decompiled with CFR 0.152.
 */
package com.pam.pamhc2trees.worldgen.sapling;

import com.mojang.serialization.Codec;
import com.pam.pamhc2trees.config.ChanceConfig;
import com.pam.pamhc2trees.config.DimensionConfig;
import com.pam.pamhc2trees.config.EnableConfig;
import com.pam.pamhc2trees.init.BlockRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WarmLogFruitTreeFeatureSapling
extends Feature<NoneFeatureConfiguration> {
    public WarmLogFruitTreeFeatureSapling(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)pContext.m_159778_();
        WorldGenLevel world = pContext.m_159774_();
        ChunkGenerator generator = pContext.m_159775_();
        Random random = pContext.m_159776_();
        BlockPos pos = pContext.m_159777_();
        return this.place(config, world, generator, random, pos);
    }

    public boolean place(NoneFeatureConfiguration config, WorldGenLevel world, ChunkGenerator generator, Random random, BlockPos pos) {
        if (random.nextInt((Integer)ChanceConfig.warmfruittree_chance.get()) != 0 || ((List)DimensionConfig.blacklist.get()).contains(world.m_6042_().m_63969_().toString()) || !((List)DimensionConfig.whitelist.get()).contains(world.m_6042_().m_63969_().toString())) {
            return false;
        }
        if (this.isValidGround(world.m_8055_(pos.m_7495_()), (BlockGetter)world, pos) && world.m_8055_(pos).m_60767_().m_76336_()) {
            int type = random.nextInt(2) + 1;
            WarmLogFruitTreeFeatureSapling.generateTree(world, pos, random, type);
            return true;
        }
        return false;
    }

    private boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Block block = state.m_60734_();
        return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50546_ || block == Blocks.f_50599_;
    }

    public static void generateTree(WorldGenLevel world, BlockPos pos, Random random, int verify) {
        BlockState trunk = WarmLogFruitTreeFeatureSapling.getTrunk(verify);
        BlockState leaves = WarmLogFruitTreeFeatureSapling.getLeaves(verify);
        BlockState fruit = WarmLogFruitTreeFeatureSapling.getFruit(verify, random);
        world.m_7731_(pos.m_6630_(0), fruit, 3);
        world.m_7731_(pos.m_6630_(1), fruit, 3);
        world.m_7731_(pos.m_6630_(2), fruit, 3);
        world.m_7731_(pos.m_6630_(3), fruit, 3);
        world.m_7731_(pos.m_6630_(4), fruit, 3);
        if (world.m_8055_(pos.m_6630_(4).m_142127_().m_142127_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(4).m_142127_().m_142127_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(4).m_142128_().m_142128_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(4).m_142128_().m_142128_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(4).m_142126_().m_142126_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(4).m_142126_().m_142126_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(4).m_142125_().m_142125_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(4).m_142125_().m_142125_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5)).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5), trunk, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142127_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142127_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142127_().m_142127_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142127_().m_142127_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142127_().m_142126_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142127_().m_142126_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142127_().m_142125_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142127_().m_142125_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142128_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142128_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142128_().m_142128_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142128_().m_142128_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142128_().m_142126_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142128_().m_142126_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142128_().m_142125_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142128_().m_142125_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142126_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142126_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142126_().m_142126_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142126_().m_142126_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142125_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142125_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(5).m_142125_().m_142125_()).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(5).m_142125_().m_142125_(), leaves, 3);
        }
        if (world.m_8055_(pos.m_6630_(6)).m_60767_().m_76336_()) {
            world.m_7731_(pos.m_6630_(6), leaves, 3);
        }
    }

    private static BlockState getLeaves(int verify) {
        return (BlockState)Blocks.f_50053_.m_49966_().m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1));
    }

    private static BlockState getTrunk(int verify) {
        return Blocks.f_50002_.m_49966_();
    }

    private static BlockState getFruit(int verify, Random random) {
        int i = 0;
        switch (verify) {
            case 1: {
                if (EnableConfig.cinnamon_worldgen != null) {
                    return (BlockState)((Block)BlockRegistry.pamcinnamon.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(i));
                }
            }
            case 2: {
                if (EnableConfig.paperbark_worldgen != null) {
                    return (BlockState)((Block)BlockRegistry.pampaperbark.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(i));
                }
            }
            case 3: {
                if (EnableConfig.rubber_worldgen == null) break;
                return (BlockState)((Block)BlockRegistry.pamrubber.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(i));
            }
        }
        return (BlockState)((Block)BlockRegistry.pamalmond.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(i));
    }
}

