/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;

public class FileGenerator {
    private static final Path OUTPUT_PATH = Paths.get(System.getProperty("user.home"), new String[0]).resolve("desktop/generated");
    private static final Path INPUT_PATH = Paths.get(System.getProperty("user.home"), new String[0]).resolve("desktop/input.json");

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Not enough arguments");
            return;
        }
        String fileName = args[0];
        int range = Integer.parseInt(args[1]);
        String jsonString = String.join((CharSequence)"\n", Files.readAllLines(INPUT_PATH));
        FileUtils.cleanDirectory((File)OUTPUT_PATH.toFile());
        Files.createDirectories(OUTPUT_PATH, new FileAttribute[0]);
        for (int i = 0; i < range; ++i) {
            Files.write(OUTPUT_PATH.resolve(FileGenerator.formatString(fileName, i) + ".json"), FileGenerator.formatString(jsonString, i).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
    }

    private static String formatString(String string, int index) {
        String[] stringSplit = string.replace("%i", String.valueOf(index)).split("%");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringSplit.length; ++i) {
            if (i % 2 == 1) {
                String[] argumentSplit = stringSplit[i].split("\\+");
                String result = String.valueOf(Float.parseFloat(argumentSplit[0]) * (float)index + (argumentSplit.length > 1 ? Float.parseFloat(argumentSplit[1]) : 0.0f));
                stringBuilder.append(result.endsWith(".0") ? result.substring(0, result.length() - 2) : result);
                continue;
            }
            stringBuilder.append(stringSplit[i]);
        }
        return stringBuilder.toString();
    }
}

