/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.BlockEntityTypes;
import mtr.block.BlockLiftTrack;
import mtr.block.IBlock;
import mtr.data.RailwayData;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockLiftTrackFloor
extends BlockLiftTrack
implements EntityBlockMapper {
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof TileEntityLiftTrackFloor) {
                ((TileEntityLiftTrackFloor)entity).syncData();
                PacketTrainDataGuiServer.openLiftTrackFloorScreenS2C((ServerPlayer)player, pos);
            }
        });
    }

    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityLiftTrackFloor(pos, state);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        RailwayData railwayData;
        if (!world.f_46443_ && (railwayData = RailwayData.getInstance(world)) != null) {
            railwayData.removeLiftFloorTrack(pos);
            PacketTrainDataGuiServer.removeLiftFloorTrackS2C(world, pos);
        }
    }

    public static class TileEntityLiftTrackFloor
    extends BlockEntityClientSerializableMapper {
        private String floorNumber = "1";
        private String floorDescription = "";
        private boolean shouldDing;
        private static final String KEY_FLOOR_NUMBER = "floor_number";
        private static final String KEY_FLOOR_DESCRIPTION = "floor_description";
        private static final String KEY_SHOULD_DING = "should_ding";

        public TileEntityLiftTrackFloor(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.LIFT_TRACK_FLOOR_1_TILE_ENTITY.get(), pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.floorNumber = compoundTag.m_128461_(KEY_FLOOR_NUMBER);
            this.floorDescription = compoundTag.m_128461_(KEY_FLOOR_DESCRIPTION);
            this.shouldDing = compoundTag.m_128471_(KEY_SHOULD_DING);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128359_(KEY_FLOOR_NUMBER, this.floorNumber);
            compoundTag.m_128359_(KEY_FLOOR_DESCRIPTION, this.floorDescription);
            compoundTag.m_128379_(KEY_SHOULD_DING, this.shouldDing);
        }

        public void setData(String floorNumber, String floorDescription, boolean shouldDing) {
            this.floorNumber = floorNumber;
            this.floorDescription = floorDescription;
            this.shouldDing = shouldDing;
            this.m_6596_();
            this.syncData();
        }

        public String getFloorNumber() {
            return this.floorNumber;
        }

        public String getFloorDescription() {
            return this.floorDescription;
        }

        public boolean getShouldDing() {
            return this.shouldDing;
        }
    }
}

