/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPSDAPGGlassEndBase;
import mtr.block.IBlock;
import mtr.data.IGui;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockPSDAPGDoorBase
extends BlockPSDAPGBase
implements EntityBlockMapper {
    public static final int MAX_OPEN_VALUE = 32;
    public static final BooleanProperty END = BooleanProperty.m_61465_((String)"end");
    public static final BooleanProperty UNLOCKED = BooleanProperty.m_61465_((String)"unlocked");
    public static final BooleanProperty TEMP = BooleanProperty.m_61465_((String)"temp");

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (IBlock.getSideDirection(state) == direction && !newState.m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState superState = super.m_7417_(state, direction, newState, world, pos, posFrom);
        if (superState.m_60734_() == Blocks.f_50016_) {
            return superState;
        }
        boolean end = world.m_8055_(pos.m_142300_(IBlock.getSideDirection(state).m_122424_())).m_60734_() instanceof BlockPSDAPGGlassEndBase;
        return (BlockState)superState.m_61124_((Property)END, (Comparable)Boolean.valueOf(end));
    }

    @Override
    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos offsetPos = pos;
        if (IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER) {
            offsetPos = offsetPos.m_7495_();
        }
        if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            offsetPos = offsetPos.m_142300_(IBlock.getSideDirection(state));
        }
        IBlock.onBreakCreative(world, player, offsetPos);
        super.m_5707_(world, pos, state, player);
    }

    @Override
    public void tick(BlockState state, ServerLevel world, BlockPos pos) {
        BlockEntity entity = world.m_7702_(pos);
        if (((Boolean)IBlock.getStatePropertySafe(state, UNLOCKED)).booleanValue() && entity instanceof TileEntityPSDAPGDoorBase) {
            ((TileEntityPSDAPGDoorBase)entity).setOpen(0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            boolean unlocked = (Boolean)IBlock.getStatePropertySafe(state, UNLOCKED);
            for (int y = -1; y <= 1; ++y) {
                BlockState scanState = world.m_8055_(pos.m_6630_(y));
                if (!state.m_60713_(scanState.m_60734_())) continue;
                BlockPSDAPGDoorBase.lockDoor(world, pos.m_6630_(y), scanState, !unlocked);
            }
            player.m_5661_((Component)(!unlocked ? Text.translatable("gui.mtr.psd_apg_door_unlocked", new Object[0]) : Text.translatable("gui.mtr.psd_apg_door_locked", new Object[0])), true);
        });
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext collisionContext) {
        BlockEntity entity = world.m_7702_(pos);
        return entity instanceof TileEntityPSDAPGDoorBase && ((TileEntityPSDAPGDoorBase)entity).isOpen() ? Shapes.m_83040_() : super.m_5939_(state, world, pos, collisionContext);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{END, f_54117_, HALF, SIDE, TEMP, UNLOCKED});
    }

    private static void lockDoor(Level world, BlockPos pos, BlockState state, boolean unlocked) {
        BlockState toggled;
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        BlockPos leftPos = pos.m_142300_(facing.m_122428_());
        BlockPos rightPos = pos.m_142300_(facing.m_122427_());
        BlockState leftState = world.m_8055_(leftPos);
        BlockState rightState = world.m_8055_(rightPos);
        if (leftState.m_60713_(state.m_60734_())) {
            toggled = (BlockState)leftState.m_61124_((Property)UNLOCKED, (Comparable)Boolean.valueOf(unlocked));
            world.m_46597_(leftPos, toggled);
        }
        if (rightState.m_60713_(state.m_60734_())) {
            toggled = (BlockState)rightState.m_61124_((Property)UNLOCKED, (Comparable)Boolean.valueOf(unlocked));
            world.m_46597_(rightPos, toggled);
        }
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)UNLOCKED, (Comparable)Boolean.valueOf(unlocked)));
    }

    public static abstract class TileEntityPSDAPGDoorBase
    extends BlockEntityClientSerializableMapper
    implements IGui {
        private int open;
        private float openClient;
        private boolean temp = true;
        private static final String KEY_OPEN = "open";
        private static final String KEY_TEMP = "temp";

        public TileEntityPSDAPGDoorBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.open = compoundTag.m_128451_(KEY_OPEN);
            this.temp = compoundTag.m_128471_(KEY_TEMP);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128405_(KEY_OPEN, this.open);
            compoundTag.m_128379_(KEY_TEMP, this.temp);
            if (this.temp && this.f_58857_ != null) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)TEMP, (Comparable)Boolean.valueOf(false)));
                this.temp = false;
            }
        }

        public AABB getRenderBoundingBox() {
            return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public void setOpen(int open) {
            if (open != this.open) {
                this.open = open;
                this.m_6596_();
                this.syncData();
                if (open == 1 && this.f_58857_ != null) {
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)TEMP, (Comparable)Boolean.valueOf(false)));
                }
            }
        }

        public float getOpen(float lastFrameDuration) {
            float change = lastFrameDuration * 0.95f;
            this.openClient = Math.abs((float)this.open - 0.1f - this.openClient) < change ? (float)this.open - 0.1f : (this.openClient < (float)this.open ? (this.openClient += change) : (this.openClient -= change));
            return this.openClient / 32.0f;
        }

        public boolean isOpen() {
            return this.open > 0;
        }
    }
}

