/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockDirectionalDoubleBlockBase;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockRouteSignBase
extends BlockDirectionalDoubleBlockBase
implements EntityBlockMapper,
IBlock {
    public static final IntegerProperty ARROW_DIRECTION = IntegerProperty.m_61631_((String)"propagate_property", (int)0, (int)3);

    public BlockRouteSignBase() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60953_(state -> 15).m_60955_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult hit) {
        double y = hit.m_82450_().f_82480_;
        boolean isUpper = IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER;
        return IBlock.checkHoldingBrush(world, player, () -> {
            if (isUpper && y - Math.floor(y) > 0.8125) {
                world.m_46597_(pos, (BlockState)state.m_61122_((Property)ARROW_DIRECTION));
                this.propagate(world, pos, Direction.DOWN, (Property)ARROW_DIRECTION, 1);
            } else {
                BlockEntity entity = world.m_7702_(pos.m_6625_(isUpper ? 1 : 0));
                if (entity instanceof TileEntityRouteSignBase) {
                    PacketTrainDataGuiServer.openRailwaySignScreenS2C((ServerPlayer)player, entity.m_58899_());
                }
            }
        });
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, HALF, ARROW_DIRECTION});
    }

    public static abstract class TileEntityRouteSignBase
    extends BlockEntityClientSerializableMapper {
        private long platformId;
        private static final String KEY_PLATFORM_ID = "platform_id";

        public TileEntityRouteSignBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.platformId = compoundTag.m_128454_(KEY_PLATFORM_ID);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128356_(KEY_PLATFORM_ID, this.platformId);
        }

        public void setPlatformId(long platformId) {
            this.platformId = platformId;
            this.m_6596_();
            this.syncData();
        }

        public long getPlatformId() {
            return this.platformId;
        }
    }
}

