/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.net.URLEncoder;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mtr.block.BlockLiftTrackFloor;
import mtr.client.Config;
import mtr.client.RouteMapGenerator;
import mtr.data.AreaBase;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.LiftClient;
import mtr.data.LiftServer;
import mtr.data.Platform;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.Siding;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.mappings.Utilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientCache
extends DataCache
implements IGui {
    private Font font;
    private Font fontCjk;
    public final Map<Long, Map<Integer, ColorNameTuple>> stationIdToRoutes = new HashMap<Long, Map<Integer, ColorNameTuple>>();
    private final Set<LiftClient> liftsClient;
    public final Map<Long, LiftClient> liftsClientIdMap = new HashMap<Long, LiftClient>();
    private final Map<TransportMode, Map<BlockPos, List<Platform>>> posToPlatforms = new HashMap<TransportMode, Map<BlockPos, List<Platform>>>();
    private final Map<TransportMode, Map<BlockPos, List<Siding>>> posToSidings = new HashMap<TransportMode, Map<BlockPos, List<Siding>>>();
    private final Map<Long, Map<Long, Platform>> stationIdToPlatforms = new HashMap<Long, Map<Long, Platform>>();
    private final Map<Long, Map<Long, Siding>> depotIdToSidings = new HashMap<Long, Map<Long, Siding>>();
    private final Map<Long, List<PlatformRouteDetails>> platformIdToRoutes = new HashMap<Long, List<PlatformRouteDetails>>();
    private final List<Long> clearStationIdToPlatforms = new ArrayList<Long>();
    private final List<Long> clearDepotIdToSidings = new ArrayList<Long>();
    private final List<Long> clearPlatformIdToRoutes = new ArrayList<Long>();
    private final Object2ObjectLinkedOpenHashMap<String, DynamicResource> dynamicResources = new Object2ObjectLinkedOpenHashMap();
    private final ObjectLinkedOpenHashSet<String> resourcesToRefresh = new ObjectLinkedOpenHashSet();
    private final List<Runnable> resourceRegistryQueue = new ArrayList<Runnable>();
    public static final float LINE_HEIGHT_MULTIPLIER = 1.25f;
    private static final ResourceLocation DEFAULT_BLACK_RESOURCE = new ResourceLocation("mtr", "textures/block/black.png");
    private static final ResourceLocation DEFAULT_WHITE_RESOURCE = new ResourceLocation("mtr", "textures/block/white.png");
    private static final ResourceLocation DEFAULT_TRANSPARENT_RESOURCE = new ResourceLocation("mtr", "textures/block/transparent.png");

    public ClientCache(Set<Station> stations, Set<Platform> platforms, Set<Siding> sidings, Set<Route> routes, Set<Depot> depots, Set<LiftClient> lifts) {
        super(stations, platforms, sidings, routes, depots, new HashSet<LiftServer>());
        for (TransportMode transportMode : TransportMode.values()) {
            this.posToPlatforms.put(transportMode, new HashMap());
            this.posToSidings.put(transportMode, new HashMap());
        }
        this.liftsClient = lifts;
    }

    @Override
    protected void syncAdditional() {
        this.syncLiftIds();
        for (TransportMode transportMode : TransportMode.values()) {
            ClientCache.mapPosToSavedRails(this.posToPlatforms.get((Object)transportMode), this.platforms, transportMode);
            ClientCache.mapPosToSavedRails(this.posToSidings.get((Object)transportMode), this.sidings, transportMode);
        }
        this.stationIdToRoutes.clear();
        this.routes.forEach(route -> {
            if (!route.isHidden) {
                route.platformIds.forEach(platformId -> {
                    Station station = (Station)this.platformIdToStation.get(platformId.platformId);
                    if (station != null) {
                        if (!this.stationIdToRoutes.containsKey(station.id)) {
                            this.stationIdToRoutes.put(station.id, new HashMap());
                        }
                        this.stationIdToRoutes.get(station.id).put(route.color, new ColorNameTuple(route.color, route.name.split("\\|\\|")[0]));
                    }
                });
            }
        });
        this.stationIdToPlatforms.keySet().forEach(id -> {
            if (!this.clearStationIdToPlatforms.contains(id)) {
                this.clearStationIdToPlatforms.add((Long)id);
            }
        });
        this.depotIdToSidings.keySet().forEach(id -> {
            if (!this.clearDepotIdToSidings.contains(id)) {
                this.clearDepotIdToSidings.add((Long)id);
            }
        });
        this.platformIdToRoutes.keySet().forEach(id -> {
            if (!this.clearPlatformIdToRoutes.contains(id)) {
                this.clearPlatformIdToRoutes.add((Long)id);
            }
        });
    }

    public void resetFonts() {
        this.font = null;
        this.fontCjk = null;
        this.refreshDynamicResources();
    }

    public void refreshDynamicResources() {
        System.out.println("Refreshing dynamic resources");
        this.resourcesToRefresh.addAll((Collection)this.dynamicResources.keySet());
    }

    public void syncLiftIds() {
        ClientCache.mapIds(this.liftsClientIdMap, this.liftsClient);
    }

    public Map<Long, Platform> requestStationIdToPlatforms(long stationId) {
        if (!this.stationIdToPlatforms.containsKey(stationId)) {
            Station station = (Station)this.stationIdMap.get(stationId);
            if (station != null) {
                this.stationIdToPlatforms.put(stationId, ClientCache.areaIdToSavedRails(station, this.platforms));
            } else {
                this.stationIdToPlatforms.put(stationId, new HashMap());
            }
        }
        return this.stationIdToPlatforms.get(stationId);
    }

    public Map<Long, Siding> requestDepotIdToSidings(long depotId) {
        if (!this.depotIdToSidings.containsKey(depotId)) {
            Depot depot = (Depot)this.depotIdMap.get(depotId);
            if (depot != null) {
                this.depotIdToSidings.put(depotId, ClientCache.areaIdToSavedRails(depot, this.sidings));
            } else {
                this.depotIdToSidings.put(depotId, new HashMap());
            }
        }
        return this.depotIdToSidings.get(depotId);
    }

    public List<PlatformRouteDetails> requestPlatformIdToRoutes(long platformId) {
        if (!this.platformIdToRoutes.containsKey(platformId)) {
            this.platformIdToRoutes.put(platformId, this.routes.stream().map(route -> {
                int index = route.getPlatformIdIndex(platformId);
                if (index < 0) {
                    return null;
                }
                List<PlatformRouteDetails.StationDetails> stationDetails = route.platformIds.stream().map(platformId2 -> {
                    Station station = (Station)this.platformIdToStation.get(platformId2.platformId);
                    if (station == null || !this.stationIdToRoutes.containsKey(station.id)) {
                        return new PlatformRouteDetails.StationDetails("", new ArrayList<ColorNameTuple>());
                    }
                    return new PlatformRouteDetails.StationDetails(station.name, this.stationIdToRoutes.get(station.id).values().stream().filter(colorNameTuple -> colorNameTuple.color != route.color).collect(Collectors.toList()));
                }).collect(Collectors.toList());
                return new PlatformRouteDetails(route.name.split("\\|\\|")[0], route.color, route.circularState, index, stationDetails);
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return this.platformIdToRoutes.get(platformId);
    }

    public String[] requestLiftFloorText(BlockPos pos) {
        BlockEntity blockEntity;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        String[] text = new String[]{"", ""};
        if (world != null && pos != null && (blockEntity = world.m_7702_(pos)) instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor) {
            text[0] = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).getFloorNumber();
            text[1] = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity).getFloorDescription();
        }
        return text;
    }

    public Set<Station> getConnectingStationsIncludingThisOne(Station station) {
        HashSet<Station> stationsToCheck = new HashSet<Station>();
        stationsToCheck.add(station);
        if (this.stationIdToConnectingStations.containsKey(station)) {
            stationsToCheck.addAll((Collection)this.stationIdToConnectingStations.get(station));
        }
        return stationsToCheck;
    }

    public Map<Integer, ColorNameTuple> getAllRoutesIncludingConnectingStations(Station station) {
        HashMap<Integer, ColorNameTuple> routeMap = new HashMap<Integer, ColorNameTuple>();
        this.getConnectingStationsIncludingThisOne(station).forEach(checkStation -> {
            if (this.stationIdToRoutes.containsKey(checkStation.id)) {
                routeMap.putAll(this.stationIdToRoutes.get(checkStation.id));
            }
        });
        return routeMap;
    }

    public String getFormattedRouteDestination(Route route, int currentStationIndex, String circularMarker) {
        try {
            String customDestination = route.getDestination(currentStationIndex);
            if (customDestination != null) {
                return customDestination;
            }
            if (route.circularState == Route.CircularState.NONE) {
                return ((Station)this.platformIdToStation.get((Object)Long.valueOf((long)route.getLastPlatformId()))).name;
            }
            boolean isVia = false;
            String text = "";
            for (int i = currentStationIndex + 1; i < route.platformIds.size() - 1; ++i) {
                if (this.stationIdToRoutes.get(((Station)this.platformIdToStation.get((Object)Long.valueOf((long)route.platformIds.get((int)i).platformId))).id).size() <= 1) continue;
                text = ((Station)this.platformIdToStation.get((Object)Long.valueOf((long)route.platformIds.get((int)i).platformId))).name;
                isVia = true;
                break;
            }
            if (!isVia) {
                text = ((Station)this.platformIdToStation.get((Object)Long.valueOf((long)route.getLastPlatformId()))).name;
            }
            String translationString = String.format("%s_%s", route.circularState == Route.CircularState.CLOCKWISE ? "clockwise" : "anticlockwise", isVia ? "via" : "to");
            return circularMarker + IGui.insertTranslation("gui.mtr." + translationString + "_cjk", "gui.mtr." + translationString, 1, text);
        }
        catch (Exception ignored) {
            return "";
        }
    }

    public DynamicResource getPixelatedText(String text, int textColor, int maxWidth, boolean fullPixel) {
        return this.getResource(String.format("pixelated_text_%s_%s_%s_%s", text, textColor, maxWidth, fullPixel), () -> RouteMapGenerator.generatePixelatedText(text, textColor, maxWidth, fullPixel), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getColorStrip(long platformId) {
        return this.getResource(String.format("color_%s", platformId), () -> RouteMapGenerator.generateColorStrip(platformId), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationName(String stationName, float aspectRatio) {
        return this.getResource(String.format("station_name_%s_%s", stationName, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateStationName(stationName, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getTallStationName(int textColor, String stationName, int stationColor, float aspectRatio) {
        return this.getResource(String.format("tall_station_name_%s_%s_%s_%s", textColor, stationName, stationColor, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateTallStationName(textColor, stationName, stationColor, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationNameEntrance(int textColor, String stationName, float aspectRatio) {
        return this.getResource(String.format("station_name_entrance_%s_%s_%s", textColor, stationName, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateStationNameEntrance(textColor, stationName, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getSingleRowStationName(long platformId, float aspectRatio) {
        return this.getResource(String.format("single_row_station_name_%s_%s", platformId, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateSingleRowStationName(platformId, aspectRatio), DefaultRenderingColor.WHITE);
    }

    public DynamicResource getSignText(String text, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, int backgroundColor, int textColor) {
        return this.getResource(String.format("sign_text_%s_%s_%s_%s_%s", new Object[]{text, horizontalAlignment, Float.valueOf(paddingScale), backgroundColor, textColor}), () -> RouteMapGenerator.generateSignText(text, horizontalAlignment, paddingScale, backgroundColor, textColor), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getLiftPanelDisplay(String originalText, int textColor) {
        return this.getResource(String.format("lift_panel_display_%s", originalText), () -> RouteMapGenerator.generateLiftPanel(originalText, textColor), DefaultRenderingColor.BLACK);
    }

    public DynamicResource getExitSignLetter(String exitLetter, String exitNumber, int backgroundColor) {
        return this.getResource(String.format("exit_sign_letter_%s_%s", exitLetter, exitNumber), () -> RouteMapGenerator.generateExitSignLetter(exitLetter, exitNumber, backgroundColor), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getRouteSquare(int color, String routeName, IGui.HorizontalAlignment horizontalAlignment) {
        return this.getResource(String.format("route_square_%s_%s_%s", new Object[]{color, routeName, horizontalAlignment}), () -> RouteMapGenerator.generateRouteSquare(color, routeName, horizontalAlignment), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getDirectionArrow(long platformId, boolean hasLeft, boolean hasRight, IGui.HorizontalAlignment horizontalAlignment, boolean showToString, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        return this.getResource(String.format("direction_arrow_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s", new Object[]{platformId, hasLeft, hasRight, horizontalAlignment, showToString, Float.valueOf(paddingScale), Float.valueOf(aspectRatio), backgroundColor, textColor, transparentColor}), () -> RouteMapGenerator.generateDirectionArrow(platformId, hasLeft, hasRight, horizontalAlignment, showToString, paddingScale, aspectRatio, backgroundColor, textColor, transparentColor), transparentColor == 0 && backgroundColor == -1 ? DefaultRenderingColor.WHITE : DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getRouteMap(long platformId, boolean vertical, boolean flip, float aspectRatio, boolean transparentWhite) {
        return this.getResource(String.format("route_map_%s_%s_%s_%s_%s", platformId, vertical, flip, Float.valueOf(aspectRatio), transparentWhite), () -> RouteMapGenerator.generateRouteMap(platformId, vertical, flip, aspectRatio, transparentWhite), transparentWhite ? DefaultRenderingColor.TRANSPARENT : DefaultRenderingColor.WHITE);
    }

    public byte[] getTextPixels(String text, int[] dimensions, int fontSizeCjk, int fontSize) {
        return this.getTextPixels(text, dimensions, Integer.MAX_VALUE, (int)((float)Math.max(fontSizeCjk, fontSize) * 1.25f), fontSizeCjk, fontSize, 0, null);
    }

    public byte[] getTextPixels(String text, int[] dimensions, int maxWidth, int maxHeight, int fontSizeCjk, int fontSize, int padding, IGui.HorizontalAlignment horizontalAlignment) {
        String[] tempTextSplit;
        if (maxWidth <= 0) {
            dimensions[0] = 0;
            dimensions[1] = 0;
            return new byte[0];
        }
        boolean oneRow = horizontalAlignment == null;
        String[] defaultTextSplit = IGui.textOrUntitled(text).split("\\|");
        String[] textSplit = Config.languageOptions() == 0 ? defaultTextSplit : ((tempTextSplit = (String[])Arrays.stream(IGui.textOrUntitled(text).split("\\|")).filter(textPart -> IGui.isCjk(textPart) == (Config.languageOptions() == 1)).toArray(String[]::new)).length == 0 ? defaultTextSplit : tempTextSplit);
        AttributedString[] attributedStrings = new AttributedString[textSplit.length];
        int[] textWidths = new int[textSplit.length];
        int[] fontSizes = new int[textSplit.length];
        FontRenderContext context = new FontRenderContext(new AffineTransform(), false, false);
        int width = 0;
        int height = 0;
        for (int index = 0; index < textSplit.length; ++index) {
            int newFontSize = IGui.isCjk(textSplit[index]) || this.font.canDisplayUpTo(textSplit[index]) >= 0 ? fontSizeCjk : fontSize;
            attributedStrings[index] = new AttributedString(textSplit[index]);
            fontSizes[index] = newFontSize;
            Font fontSized = this.font.deriveFont(0, newFontSize);
            Font fontCjkSized = this.fontCjk.deriveFont(0, newFontSize);
            for (int characterIndex = 0; characterIndex < textSplit[index].length(); ++characterIndex) {
                Font newFont;
                char character = textSplit[index].charAt(characterIndex);
                if (fontSized.canDisplay(character)) {
                    newFont = fontSized;
                } else if (fontCjkSized.canDisplay(character)) {
                    newFont = fontCjkSized;
                } else {
                    Font defaultFont = null;
                    for (Font testFont : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                        if (!testFont.canDisplay(character)) continue;
                        defaultFont = testFont;
                        break;
                    }
                    newFont = (defaultFont == null ? new Font(null) : defaultFont).deriveFont(0, newFontSize);
                }
                int n = index;
                textWidths[n] = textWidths[n] + newFont.getStringBounds((String)textSplit[index].substring((int)characterIndex, (int)(characterIndex + 1)), (FontRenderContext)context).getBounds().width;
                attributedStrings[index].addAttribute(TextAttribute.FONT, newFont, characterIndex, characterIndex + 1);
            }
            if (oneRow) {
                if (index > 0) {
                    width += padding;
                }
                width += textWidths[index];
                height = Math.max(height, (int)((float)fontSizes[index] * 1.25f));
                continue;
            }
            width = Math.max(width, Math.min(maxWidth, textWidths[index]));
            height = (int)((float)height + (float)fontSizes[index] * 1.25f);
        }
        int textOffset = 0;
        int imageHeight = Math.min(height, maxHeight);
        BufferedImage image = new BufferedImage(width + (oneRow ? 0 : padding * 2), imageHeight + (oneRow ? 0 : padding * 2), 10);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (int index = 0; index < textSplit.length; ++index) {
            if (oneRow) {
                graphics2D.drawString(attributedStrings[index].getIterator(), (float)textOffset, (float)height / 1.25f);
                textOffset += textWidths[index] + padding;
                continue;
            }
            float scaleY = (float)imageHeight / (float)height;
            float textWidth = Math.min((float)maxWidth, (float)textWidths[index] * scaleY);
            float scaleX = textWidth / (float)textWidths[index];
            AffineTransform stretch = new AffineTransform();
            stretch.concatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
            graphics2D.setTransform(stretch);
            graphics2D.drawString(attributedStrings[index].getIterator(), horizontalAlignment.getOffset(0.0f, textWidth - (float)width) / scaleY + (float)padding / scaleX, (float)(textOffset + fontSizes[index]) + (float)padding / scaleY);
            textOffset = (int)((float)textOffset + (float)fontSizes[index] * 1.25f);
        }
        dimensions[0] = width + (oneRow ? 0 : padding * 2);
        dimensions[1] = imageHeight + (oneRow ? 0 : padding * 2);
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        graphics2D.dispose();
        image.flush();
        return pixels;
    }

    public void clearDataIfNeeded() {
        if (!this.clearStationIdToPlatforms.isEmpty()) {
            this.stationIdToPlatforms.remove(this.clearStationIdToPlatforms.remove(0));
        }
        if (!this.clearDepotIdToSidings.isEmpty()) {
            this.depotIdToSidings.remove(this.clearDepotIdToSidings.remove(0));
        }
        if (!this.clearPlatformIdToRoutes.isEmpty()) {
            this.platformIdToRoutes.remove(this.clearPlatformIdToRoutes.remove(0));
        }
    }

    public Map<BlockPos, List<Platform>> getPosToPlatforms(TransportMode transportMode) {
        return this.posToPlatforms.get((Object)transportMode);
    }

    public Map<BlockPos, List<Siding>> getPosToSidings(TransportMode transportMode) {
        return this.posToSidings.get((Object)transportMode);
    }

    private DynamicResource getResource(String key, Supplier<NativeImage> supplier, DefaultRenderingColor defaultRenderingColor) {
        Runnable runnable;
        Minecraft minecraftClient = Minecraft.m_91087_();
        if (this.font == null || this.fontCjk == null) {
            ResourceManager resourceManager = minecraftClient.m_91098_();
            try {
                this.font = Font.createFont(0, Utilities.getInputStream(resourceManager.m_142591_(new ResourceLocation("mtr", "font/noto-sans-semibold.ttf"))));
                this.fontCjk = Font.createFont(0, Utilities.getInputStream(resourceManager.m_142591_(new ResourceLocation("mtr", "font/noto-serif-cjk-tc-semibold.ttf"))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.resourceRegistryQueue.isEmpty() && (runnable = this.resourceRegistryQueue.remove(0)) != null) {
            runnable.run();
        }
        boolean needsRefresh = this.resourcesToRefresh.contains((Object)key);
        DynamicResource dynamicResource = (DynamicResource)this.dynamicResources.get((Object)key);
        if (dynamicResource != null && !needsRefresh) {
            return dynamicResource;
        }
        RouteMapGenerator.setConstants();
        CompletableFuture.supplyAsync(supplier).thenAccept(nativeImage -> this.resourceRegistryQueue.add(() -> {
            DynamicResource dynamicResourceNew;
            DynamicResource staticTextureProviderOld = (DynamicResource)this.dynamicResources.get((Object)key);
            if (staticTextureProviderOld != null) {
                staticTextureProviderOld.remove();
            }
            if (nativeImage == null) {
                dynamicResourceNew = defaultRenderingColor.dynamicResource;
            } else {
                DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
                String newKey = key;
                try {
                    newKey = URLEncoder.encode(key, "UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ResourceLocation resourceLocation = new ResourceLocation("mtr", "dynamic_texture_" + newKey.toLowerCase(Locale.ENGLISH).replaceAll("[^0-9a-z_]", "_"));
                minecraftClient.m_91097_().m_118495_(resourceLocation, (AbstractTexture)dynamicTexture);
                dynamicResourceNew = new DynamicResource(resourceLocation, dynamicTexture);
            }
            this.dynamicResources.put((Object)key, (Object)dynamicResourceNew);
        }));
        if (needsRefresh) {
            this.resourcesToRefresh.remove((Object)key);
        }
        if (dynamicResource == null) {
            this.dynamicResources.put((Object)key, (Object)defaultRenderingColor.dynamicResource);
            return defaultRenderingColor.dynamicResource;
        }
        return dynamicResource;
    }

    private static <U extends AreaBase, V extends SavedRailBase> Map<Long, V> areaIdToSavedRails(U area, Set<V> savedRails) {
        HashMap savedRailMap = new HashMap();
        savedRails.forEach(savedRail -> {
            BlockPos pos = savedRail.getMidPos();
            if (area.isTransportMode(savedRail.transportMode) && area.inArea(pos.m_123341_(), pos.m_123343_())) {
                savedRailMap.put(savedRail.id, savedRail);
            }
        });
        return savedRailMap;
    }

    private static <U extends SavedRailBase> void mapPosToSavedRails(Map<BlockPos, List<U>> posToSavedRails, Set<U> savedRails, TransportMode transportMode) {
        posToSavedRails.clear();
        savedRails.forEach(savedRail -> {
            if (savedRail.isTransportMode(transportMode)) {
                BlockPos pos = savedRail.getMidPos(true);
                if (!posToSavedRails.containsKey(pos)) {
                    posToSavedRails.put(pos, new ArrayList());
                }
                ((List)posToSavedRails.get(pos)).add(savedRail);
            }
        });
    }

    private static enum DefaultRenderingColor {
        BLACK(DEFAULT_BLACK_RESOURCE),
        WHITE(DEFAULT_WHITE_RESOURCE),
        TRANSPARENT(DEFAULT_TRANSPARENT_RESOURCE);

        private final DynamicResource dynamicResource;

        private DefaultRenderingColor(ResourceLocation resourceLocation) {
            this.dynamicResource = new DynamicResource(resourceLocation, null);
        }
    }

    public static class DynamicResource {
        public final int width;
        public final int height;
        public final ResourceLocation resourceLocation;

        private DynamicResource(ResourceLocation resourceLocation, DynamicTexture dynamicTexture) {
            this.resourceLocation = resourceLocation;
            if (dynamicTexture != null) {
                NativeImage nativeImage = dynamicTexture.m_117991_();
                if (nativeImage != null) {
                    this.width = nativeImage.m_84982_();
                    this.height = nativeImage.m_85084_();
                } else {
                    this.width = 16;
                    this.height = 16;
                }
            } else {
                this.width = 16;
                this.height = 16;
            }
        }

        private void remove() {
            if (!(this.resourceLocation.equals((Object)DEFAULT_BLACK_RESOURCE) || this.resourceLocation.equals((Object)DEFAULT_WHITE_RESOURCE) || this.resourceLocation.equals((Object)DEFAULT_TRANSPARENT_RESOURCE))) {
                TextureManager textureManager = Minecraft.m_91087_().m_91097_();
                textureManager.m_118513_(this.resourceLocation);
                AbstractTexture abstractTexture = textureManager.m_118506_(this.resourceLocation);
                if (abstractTexture != null) {
                    abstractTexture.m_117964_();
                    abstractTexture.close();
                }
            }
        }
    }

    public static class PlatformRouteDetails {
        public final String routeName;
        public final int routeColor;
        public final Route.CircularState circularState;
        public final int currentStationIndex;
        public final List<StationDetails> stationDetails;

        public PlatformRouteDetails(String routeName, int routeColor, Route.CircularState circularState, int currentStationIndex, List<StationDetails> stationDetails) {
            this.routeName = routeName;
            this.routeColor = routeColor;
            this.circularState = circularState;
            this.currentStationIndex = currentStationIndex;
            this.stationDetails = stationDetails;
        }

        public static class StationDetails {
            public final String stationName;
            public final List<ColorNameTuple> interchangeRoutes;

            public StationDetails(String stationName, List<ColorNameTuple> interchangeRoutes) {
                this.stationName = stationName;
                this.interchangeRoutes = interchangeRoutes;
            }
        }
    }

    public static class ColorNameTuple {
        public final int color;
        public final String name;

        public ColorNameTuple(int color, String name) {
            this.color = color;
            this.name = name;
        }
    }
}

