/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.function.Consumer;
import mtr.data.SavedRailBase;
import mtr.data.TransportMode;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.msgpack.value.Value;

public final class Platform
extends SavedRailBase {
    private static final String KEY_DWELL_TIME = "dwell_time";

    public Platform(long id, TransportMode transportMode, BlockPos pos1, BlockPos pos2) {
        super(id, transportMode, pos1, pos2);
    }

    public Platform(TransportMode transportMode, BlockPos pos1, BlockPos pos2) {
        super(transportMode, pos1, pos2);
    }

    public Platform(Map<String, Value> map) {
        super(map);
    }

    @Deprecated
    public Platform(CompoundTag compoundTag) {
        super(compoundTag);
    }

    public Platform(FriendlyByteBuf packet) {
        super(packet);
    }

    @Override
    public void update(String key, FriendlyByteBuf packet) {
        if (KEY_DWELL_TIME.equals(key)) {
            this.name = packet.m_130136_(Short.MAX_VALUE);
            this.color = packet.readInt();
            this.dwellTime = packet.readInt();
            this.dwellTime = this.transportMode.continuousMovement ? 1 : this.dwellTime;
        } else {
            super.update(key, packet);
        }
    }

    public void setDwellTime(int newDwellTime, Consumer<FriendlyByteBuf> sendPacket) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.m_130070_(this.transportMode.toString());
        packet.m_130070_(KEY_DWELL_TIME);
        packet.m_130070_(this.name);
        packet.writeInt(this.color);
        this.writeDwellTimePacket(packet, newDwellTime);
        sendPacket.accept(packet);
    }
}

