/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.Text;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class TicketSystem {
    public static final String BALANCE_OBJECTIVE = "mtr_balance";
    private static final String ENTRY_ZONE_OBJECTIVE = "mtr_entry_zone";
    private static final int BASE_FARE = 2;
    private static final int ZONE_FARE = 1;
    private static final int EVASION_FINE = 500;

    public static EnumTicketBarrierOpen passThrough(Level world, BlockPos pos, Player player, boolean isEntrance, boolean isExit, SoundEvent entrySound, SoundEvent entrySoundConcessionary, SoundEvent exitSound, SoundEvent exitSoundConcessionary, SoundEvent failSound, boolean remindIfNoRecord) {
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return EnumTicketBarrierOpen.CLOSED;
        }
        Station station = RailwayData.getStation(railwayData.stations, railwayData.dataCache, pos);
        if (station == null) {
            return EnumTicketBarrierOpen.CLOSED;
        }
        TicketSystem.addObjectivesIfMissing(world);
        Score balanceScore = TicketSystem.getPlayerScore(world, player, BALANCE_OBJECTIVE);
        Score entryZoneScore = TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_OBJECTIVE);
        boolean isEntering = isEntrance && isExit ? entryZoneScore.m_83400_() == 0 : isEntrance;
        boolean canOpen = isEntering ? TicketSystem.onEnter(station, player, balanceScore, entryZoneScore, remindIfNoRecord) : TicketSystem.onExit(station, player, balanceScore, entryZoneScore, remindIfNoRecord);
        if (canOpen) {
            world.m_5594_(null, pos, TicketSystem.isConcessionary(player) ? (isEntering ? entrySoundConcessionary : exitSoundConcessionary) : (isEntering ? entrySound : exitSound), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (failSound != null) {
            world.m_5594_(null, pos, failSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return canOpen ? (TicketSystem.isConcessionary(player) ? EnumTicketBarrierOpen.OPEN_CONCESSIONARY : EnumTicketBarrierOpen.OPEN) : EnumTicketBarrierOpen.CLOSED;
    }

    public static void addObjectivesIfMissing(Level world) {
        try {
            world.m_6188_().m_83436_(BALANCE_OBJECTIVE, ObjectiveCriteria.f_83588_, (Component)Text.literal("Balance"), ObjectiveCriteria.RenderType.INTEGER);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            world.m_6188_().m_83436_(ENTRY_ZONE_OBJECTIVE, ObjectiveCriteria.f_83588_, (Component)Text.literal("Entry Zone"), ObjectiveCriteria.RenderType.INTEGER);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Score getPlayerScore(Level world, Player player, String objectiveName) {
        return world.m_6188_().m_83471_(player.m_36316_().getName(), world.m_6188_().m_83477_(objectiveName));
    }

    private static boolean onEnter(Station station, Player player, Score balanceScore, Score entryZoneScore, boolean remindIfNoRecord) {
        int entryZone = entryZoneScore.m_83400_();
        if (entryZone != 0) {
            if (remindIfNoRecord) {
                player.m_5661_((Component)Text.translatable("gui.mtr.already_entered", new Object[0]), true);
                return false;
            }
            entryZoneScore.m_83402_(0);
            balanceScore.m_83393_(-500);
        }
        if (balanceScore.m_83400_() >= 0) {
            entryZoneScore.m_83402_(TicketSystem.encodeZone(station.zone));
            player.m_5661_((Component)Text.translatable("gui.mtr.enter_barrier", String.format("%s (%s)", station.name.replace('|', ' '), station.zone), balanceScore.m_83400_()), true);
            return true;
        }
        player.m_5661_((Component)Text.translatable("gui.mtr.insufficient_balance", balanceScore.m_83400_()), true);
        return false;
    }

    private static boolean onExit(Station station, Player player, Score balanceScore, Score entryZoneScore, boolean remindIfNoRecord) {
        int finalFare;
        int entryZone = entryZoneScore.m_83400_();
        int fare = 2 + 1 * Math.abs(station.zone - TicketSystem.decodeZone(entryZone));
        int n = entryZone != 0 ? (TicketSystem.isConcessionary(player) ? (int)Math.ceil((float)fare / 2.0f) : fare) : (finalFare = 500);
        if (entryZone == 0 && remindIfNoRecord) {
            player.m_5661_((Component)Text.translatable("gui.mtr.already_exited", new Object[0]), true);
            return false;
        }
        entryZoneScore.m_83402_(0);
        balanceScore.m_83393_(-finalFare);
        player.m_5661_((Component)Text.translatable("gui.mtr.exit_barrier", String.format("%s (%s)", station.name.replace('|', ' '), station.zone), finalFare, balanceScore.m_83400_()), true);
        return true;
    }

    private static boolean isConcessionary(Player player) {
        return player.m_7500_();
    }

    private static int encodeZone(int zone) {
        return zone >= 0 ? zone + 1 : zone;
    }

    private static int decodeZone(int zone) {
        return zone > 0 ? zone - 1 : zone;
    }

    public static enum EnumTicketBarrierOpen implements StringRepresentable
    {
        CLOSED("closed"),
        OPEN("open"),
        OPEN_CONCESSIONARY("open_concessionary");

        private final String name;

        private EnumTicketBarrierOpen(String nameIn) {
            this.name = nameIn;
        }

        public String m_7912_() {
            return this.name;
        }

        public boolean isOpen() {
            return this != CLOSED;
        }
    }
}

