/*
 * Decompiled with CFR 0.152.
 */
package mtr.mappings;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import java.io.File;
import java.io.IOException;
import java.util.List;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;

public interface UtilitiesClient {
    public static void beginDrawingRectangle(BufferBuilder buffer) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
    }

    public static void finishDrawingRectangle() {
    }

    public static void beginDrawingTexture(ResourceLocation textureId) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureId);
    }

    public static void setScreen(Minecraft client, ScreenMapper screen) {
        client.m_91152_((Screen)screen);
    }

    public static EntityModel<Minecart> getMinecartModel() {
        return new MinecartModel(MinecartModel.m_170738_().m_171564_());
    }

    public static EntityModel<Boat> getBoatModel() {
        return new BoatModel(BoatModel.m_170463_().m_171564_());
    }

    public static void setPacketCoordinates(Entity entity, double x, double y, double z) {
        entity.m_20167_(x, y, z);
    }

    public static float getPacketYaw(ClientboundAddEntityPacket packet) {
        return (float)packet.m_131507_() * 360.0f / 256.0f;
    }

    public static int getRenderDistance() {
        return Minecraft.m_91087_().f_91066_.f_92106_;
    }

    public static List<Resource> getResources(ResourceManager resourceManager, ResourceLocation resourceLocation) throws IOException {
        return resourceManager.m_7396_(resourceLocation);
    }

    public static boolean hasResource(ResourceLocation resourceLocation) {
        return Minecraft.m_91087_().m_91098_().m_7165_(resourceLocation);
    }

    public static boolean isHovered(AbstractWidget widget) {
        return widget.m_198029_();
    }

    public static File getResourcePackDirectory(Minecraft minecraft) {
        return minecraft.m_91101_();
    }

    public static Button newButton(Button.OnPress onPress) {
        return UtilitiesClient.newButton((Component)Text.literal(""), onPress);
    }

    public static Button newButton(Component component, Button.OnPress onPress) {
        return new Button(0, 0, 0, 20, component, onPress);
    }

    public static Button newButton(int height, Component component, Button.OnPress onPress) {
        return new Button(0, 0, 0, height, component, onPress);
    }

    public static int getWidgetX(AbstractWidget widget) {
        return widget.f_93620_;
    }

    public static void setWidgetX(AbstractWidget widget, int x) {
        widget.f_93620_ = x;
    }

    public static void setWidgetY(AbstractWidget widget, int y) {
        widget.f_93621_ = y;
    }

    public static int getWidgetY(AbstractWidget widget) {
        return widget.f_93621_;
    }

    public static void rotateX(PoseStack matrices, float angle) {
        matrices.m_85845_(Vector3f.f_122223_.m_122270_(angle));
    }

    public static void rotateXDegrees(PoseStack matrices, float angle) {
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(angle));
    }

    public static void rotateY(PoseStack matrices, float angle) {
        matrices.m_85845_(Vector3f.f_122225_.m_122270_(angle));
    }

    public static void rotateYDegrees(PoseStack matrices, float angle) {
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(angle));
    }

    public static void rotateZ(PoseStack matrices, float angle) {
        matrices.m_85845_(Vector3f.f_122227_.m_122270_(angle));
    }

    public static void rotateZDegrees(PoseStack matrices, float angle) {
        matrices.m_85845_(Vector3f.f_122227_.m_122240_(angle));
    }
}

