/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.MTRClient;
import mtr.block.BlockAPGGlass;
import mtr.block.BlockAPGGlassEnd;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.IBlock;
import mtr.block.ITripleBlock;
import mtr.data.IGui;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.ModelDataWrapper;
import mtr.mappings.ModelMapper;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;

public class RenderPSDAPGDoor<T extends BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IBlock {
    private final int type;
    private static final ModelSingleCube MODEL_PSD = new ModelSingleCube(36, 18, 0, 0, 0, 16, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_LEFT_1 = new ModelSingleCube(20, 18, 0, 0, 0, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_RIGHT_1 = new ModelSingleCube(20, 18, 8, 0, 0, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_LEFT_2 = new ModelSingleCube(20, 18, 8, 0, 2, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_RIGHT_2 = new ModelSingleCube(20, 18, 0, 0, 2, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_LIGHT_LEFT = new ModelSingleCube(16, 16, 0, -1, 5, 1, 1, 1);
    private static final ModelSingleCube MODEL_PSD_LIGHT_RIGHT = new ModelSingleCube(16, 16, 15, -1, 5, 1, 1, 1);
    private static final ModelSingleCube MODEL_APG_TOP = new ModelSingleCube(34, 9, 0, 8, 1, 16, 8, 1);
    private static final ModelAPGDoorBottom MODEL_APG_BOTTOM = new ModelAPGDoorBottom();
    private static final ModelAPGDoorLight MODEL_APG_LIGHT = new ModelAPGDoorLight();
    private static final ModelSingleCube MODEL_APG_DOOR_LOCKED = new ModelSingleCube(6, 6, 5, 10, 1, 6, 6, 0);
    private static final ModelSingleCube MODEL_PSD_DOOR_LOCKED = new ModelSingleCube(6, 6, 5, 6, 1, 6, 6, 0);
    private static final ModelSingleCube MODEL_LIFT_LEFT = new ModelSingleCube(28, 18, 0, 0, 0, 12, 16, 2);
    private static final ModelSingleCube MODEL_LIFT_RIGHT = new ModelSingleCube(28, 18, 4, 0, 0, 12, 16, 2);

    public RenderPSDAPGDoor(BlockEntityRenderDispatcher dispatcher, int type) {
        super(dispatcher);
        this.type = type;
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        if (((Boolean)IBlock.getStatePropertySafe((BlockGetter)world, pos, BlockPSDAPGDoorBase.TEMP)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockGetter)world, pos, BlockPSDAPGDoorBase.f_54117_);
        boolean side = IBlock.getStatePropertySafe((BlockGetter)world, pos, BlockPSDAPGDoorBase.SIDE) == IBlock.EnumSide.RIGHT;
        boolean half = IBlock.getStatePropertySafe((BlockGetter)world, pos, BlockPSDAPGDoorBase.HALF) == DoubleBlockHalf.UPPER;
        boolean end = (Boolean)IBlock.getStatePropertySafe((BlockGetter)world, pos, BlockPSDAPGDoorBase.END);
        boolean unlocked = (Boolean)IBlock.getStatePropertySafe((BlockGetter)world, pos, BlockPSDAPGDoorBase.UNLOCKED);
        float open = Math.min(((BlockPSDAPGDoorBase.TileEntityPSDAPGDoorBase)entity).getOpen(MTRClient.getLastFrameDuration()), this.type >= 3 ? 0.75f : 1.0f);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations();
        storedMatrixTransformations.add(matricesNew -> {
            matricesNew.m_85837_(0.5 + (double)entity.m_58899_().m_123341_(), (double)entity.m_58899_().m_123342_(), 0.5 + (double)entity.m_58899_().m_123343_());
            UtilitiesClient.rotateYDegrees(matricesNew, -facing.m_122435_());
            UtilitiesClient.rotateXDegrees(matricesNew, 180.0f);
        });
        StoredMatrixTransformations storedMatrixTransformationsLight = storedMatrixTransformations.copy();
        switch (this.type) {
            case 0: 
            case 1: {
                if (half) {
                    RenderTrains.scheduleRender(new ResourceLocation(String.format("mtr:textures/block/light_%s.png", open > 0.0f ? "on" : "off")), false, open > 0.0f ? RenderTrains.QueuedRenderLayer.LIGHT : RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                        storedMatrixTransformationsLight.transform((PoseStack)matricesNew);
                        (side ? MODEL_PSD_LIGHT_RIGHT : MODEL_PSD_LIGHT_LEFT).m_7695_((PoseStack)matricesNew, (VertexConsumer)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        matricesNew.m_85849_();
                    });
                }
                if (!end) break;
                RenderTrains.scheduleRender(new ResourceLocation(String.format("mtr:textures/block/psd_door_end_%s_%s_2_%s.png", half ? "top" : "bottom", side ? "right" : "left", this.type == 1 ? "2" : "1")), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformationsLight.transform((PoseStack)matricesNew);
                    matricesNew.m_85837_((double)(open / 2.0f * (float)(side ? -1 : 1)), 0.0, 0.0);
                    (side ? MODEL_PSD_END_RIGHT_2 : MODEL_PSD_END_LEFT_2).m_7695_((PoseStack)matricesNew, (VertexConsumer)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.m_85849_();
                });
                break;
            }
            case 2: {
                Block block;
                if (!half || !((block = world.m_8055_(pos.m_142300_(side ? facing.m_122427_() : facing.m_122428_())).m_60734_()) instanceof BlockAPGGlass) && !(block instanceof BlockAPGGlassEnd)) break;
                RenderTrains.scheduleRender(new ResourceLocation(String.format("mtr:textures/block/apg_door_light_%s.png", open > 0.0f ? "on" : "off")), false, open > 0.0f ? RenderTrains.QueuedRenderLayer.LIGHT_TRANSLUCENT : RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformationsLight.transform((PoseStack)matricesNew);
                    matricesNew.m_85837_(side ? -0.515625 : 0.515625, 0.0, 0.0);
                    matricesNew.m_85841_(0.5f, 1.0f, 1.0f);
                    MODEL_APG_LIGHT.m_7695_((PoseStack)matricesNew, (VertexConsumer)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.m_85849_();
                });
            }
        }
        storedMatrixTransformations.add(matricesNew -> matricesNew.m_85837_((double)(open * (float)(side ? -1 : 1)), 0.0, 0.0));
        switch (this.type) {
            case 0: 
            case 1: {
                if (end) {
                    RenderTrains.scheduleRender(new ResourceLocation(String.format("mtr:textures/block/psd_door_end_%s_%s_1_%s.png", half ? "top" : "bottom", side ? "right" : "left", this.type == 1 ? "2" : "1")), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                        storedMatrixTransformations.transform((PoseStack)matricesNew);
                        (side ? MODEL_PSD_END_RIGHT_1 : MODEL_PSD_END_LEFT_1).m_7695_((PoseStack)matricesNew, (VertexConsumer)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        matricesNew.m_85849_();
                    });
                } else {
                    RenderTrains.scheduleRender(new ResourceLocation(String.format("mtr:textures/block/psd_door_%s_%s_%s.png", half ? "top" : "bottom", side ? "right" : "left", this.type == 1 ? "2" : "1")), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                        storedMatrixTransformations.transform((PoseStack)matricesNew);
                        MODEL_PSD.m_7695_((PoseStack)matricesNew, (VertexConsumer)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        matricesNew.m_85849_();
                    });
                }
                if (!half || unlocked) break;
                RenderTrains.scheduleRender(new ResourceLocation("mtr:textures/block/sign/door_not_in_use.png"), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((PoseStack)matricesNew);
                    if (end) {
                        matricesNew.m_85837_(side ? 0.25 : -0.25, 0.0, 0.0);
                    }
                    MODEL_PSD_DOOR_LOCKED.m_7695_((PoseStack)matricesNew, (VertexConsumer)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.m_85849_();
                });
                break;
            }
            case 2: {
                RenderTrains.scheduleRender(new ResourceLocation(String.format("mtr:textures/block/apg_door_%s_%s.png", half ? "top" : "bottom", side ? "right" : "left")), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((PoseStack)matricesNew);
                    (half ? MODEL_APG_TOP : MODEL_APG_BOTTOM).m_7695_(matricesNew, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.m_85849_();
                });
                if (!half || unlocked) break;
                RenderTrains.scheduleRender(new ResourceLocation("mtr:textures/block/sign/door_not_in_use.png"), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((PoseStack)matricesNew);
                    MODEL_APG_DOOR_LOCKED.m_7695_((PoseStack)matricesNew, (VertexConsumer)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.m_85849_();
                });
                break;
            }
            case 4: {
                if (((Boolean)IBlock.getStatePropertySafe((BlockGetter)world, pos, ITripleBlock.ODD)).booleanValue()) break;
                storedMatrixTransformations.add(matricesNew -> matricesNew.m_85837_(side ? 0.5 : -0.5, 0.0, 0.0));
            }
            case 3: {
                RenderTrains.scheduleRender(new ResourceLocation(String.format("mtr:textures/block/lift_door_%s_%s_1.png", half ? "top" : "bottom", side ? "right" : "left")), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((PoseStack)matricesNew);
                    (side ? MODEL_LIFT_RIGHT : MODEL_LIFT_LEFT).m_7695_((PoseStack)matricesNew, (VertexConsumer)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.m_85849_();
                });
                if (!half || unlocked) break;
                RenderTrains.scheduleRender(new ResourceLocation("mtr:textures/block/sign/door_not_in_use.png"), false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((PoseStack)matricesNew);
                    matricesNew.m_85837_(side ? 0.125 : -0.125, 0.0, 0.0);
                    MODEL_PSD_DOOR_LOCKED.m_7695_((PoseStack)matricesNew, (VertexConsumer)vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    matricesNew.m_85849_();
                });
            }
        }
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    private static class ModelSingleCube
    extends EntityModel<Entity> {
        private final ModelMapper cube;

        private ModelSingleCube(int textureWidth, int textureHeight, int x, int y, int z, int length, int height, int depth) {
            ModelDataWrapper modelDataWrapper = new ModelDataWrapper((Model)this, textureWidth, textureHeight);
            this.cube = new ModelMapper(modelDataWrapper);
            this.cube.texOffs(0, 0).addBox(x - 8, y - 16, z - 8, length, height, depth, 0.0f, false);
            modelDataWrapper.setModelPart(textureWidth, textureHeight);
            this.cube.setModelPart();
        }

        public void m_7695_(PoseStack matrices, VertexConsumer vertices, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.cube.render(matrices, vertices, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void m_6973_(Entity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }

    private static class ModelAPGDoorBottom
    extends EntityModel<Entity> {
        private final ModelMapper bone;

        private ModelAPGDoorBottom() {
            int textureWidth = 34;
            int textureHeight = 27;
            ModelDataWrapper modelDataWrapper = new ModelDataWrapper((Model)this, 34, 27);
            this.bone = new ModelMapper(modelDataWrapper);
            this.bone.texOffs(0, 0).addBox(-8.0f, -16.0f, -7.0f, 16, 16, 1, 0.0f, false);
            this.bone.texOffs(0, 17).addBox(-8.0f, -6.0f, -8.0f, 16, 6, 1, 0.0f, false);
            ModelMapper cube_r1 = new ModelMapper(modelDataWrapper);
            cube_r1.setPos(0.0f, -6.0f, -8.0f);
            this.bone.addChild(cube_r1);
            cube_r1.setRotationAngle(-0.7854f, 0.0f, 0.0f);
            cube_r1.texOffs(0, 24).addBox(-8.0f, -2.0f, 0.0f, 16, 2, 1, 0.0f, false);
            modelDataWrapper.setModelPart(34, 27);
            this.bone.setModelPart();
        }

        public void m_7695_(PoseStack matrices, VertexConsumer vertices, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.bone.render(matrices, vertices, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void m_6973_(Entity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }

    private static class ModelAPGDoorLight
    extends EntityModel<Entity> {
        private final ModelMapper bone;

        private ModelAPGDoorLight() {
            int textureWidth = 8;
            int textureHeight = 8;
            ModelDataWrapper modelDataWrapper = new ModelDataWrapper((Model)this, 8, 8);
            this.bone = new ModelMapper(modelDataWrapper);
            this.bone.texOffs(0, 4).addBox(-0.5f, -9.0f, -7.0f, 1, 1, 3, 0.05f, false);
            ModelMapper cube_r1 = new ModelMapper(modelDataWrapper);
            cube_r1.setPos(0.0f, -9.05f, -4.95f);
            this.bone.addChild(cube_r1);
            cube_r1.setRotationAngle(0.3927f, 0.0f, 0.0f);
            cube_r1.texOffs(0, 0).addBox(-0.5f, 0.05f, -3.05f, 1, 1, 3, 0.05f, false);
            modelDataWrapper.setModelPart(8, 8);
            this.bone.setModelPart();
        }

        public void m_7695_(PoseStack matrices, VertexConsumer vertices, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.bone.render(matrices, vertices, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void m_6973_(Entity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }
}

