/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import mtr.block.BlockPSDTop;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class RenderRouteBase<T extends BlockPSDTop.TileEntityRouteBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IBlock {
    protected final float topPadding;
    protected final float bottomPadding;
    protected final float sidePadding;
    private final float z;
    private final boolean transparentWhite;
    private final Property<Integer> arrowDirectionProperty;

    public RenderRouteBase(BlockEntityRenderDispatcher dispatcher, float z, float topPadding, float bottomPadding, float sidePadding, boolean transparentWhite, Property<Integer> arrowDirectionProperty) {
        super(dispatcher);
        this.z = z / 16.0f;
        this.topPadding = topPadding / 16.0f;
        this.bottomPadding = bottomPadding / 16.0f;
        this.sidePadding = sidePadding / 16.0f;
        this.transparentWhite = transparentWhite;
        this.arrowDirectionProperty = arrowDirectionProperty;
    }

    public final void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        long platformId;
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, HorizontalDirectionalBlock.f_54117_);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations();
        storedMatrixTransformations.add(matricesNew -> {
            matricesNew.m_85837_(0.5 + (double)entity.m_58899_().m_123341_(), (double)entity.m_58899_().m_123342_(), 0.5 + (double)entity.m_58899_().m_123343_());
            UtilitiesClient.rotateYDegrees(matricesNew, -facing.m_122435_());
        });
        this.renderAdditionalUnmodified(storedMatrixTransformations.copy(), state, facing, light);
        if (!RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null) && (platformId = ((BlockPSDTop.TileEntityRouteBase)((Object)entity)).getPlatformId(ClientData.PLATFORMS, ClientData.DATA_CACHE)) != 0L) {
            storedMatrixTransformations.add(matricesNew -> {
                matricesNew.m_85837_(0.0, 1.0, 0.0);
                UtilitiesClient.rotateZDegrees(matricesNew, 180.0f);
                matricesNew.m_85837_(-0.5, (double)(-this.getAdditionalOffset(state)), (double)this.z);
            });
            int leftBlocks = this.getTextureNumber((BlockGetter)world, pos, facing, true);
            int rightBlocks = this.getTextureNumber((BlockGetter)world, pos, facing, false);
            int color = RenderRouteBase.getShadingColor(facing, -1);
            RenderType renderType = this.getRenderType((BlockGetter)world, pos.m_5484_(facing.m_122428_(), leftBlocks), state);
            if ((renderType == RenderType.ARROW || renderType == RenderType.ROUTE) && IBlock.getStatePropertySafe(state, SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
                float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
                float height = 1.0f - this.topPadding - this.bottomPadding;
                int arrowDirection = IBlock.getStatePropertySafe(state, this.arrowDirectionProperty);
                ResourceLocation resourceLocation = renderType == RenderType.ARROW ? ClientData.DATA_CACHE.getDirectionArrow((long)platformId, (boolean)((arrowDirection & 1) > 0 ? true : false), (boolean)((arrowDirection & 2) > 0 ? true : false), (IGui.HorizontalAlignment)IGui.HorizontalAlignment.CENTER, (boolean)true, (float)0.25f, (float)(width / height), (int)-1, (int)-16777216, (int)(this.transparentWhite ? -1 : 0)).resourceLocation : ClientData.DATA_CACHE.getRouteMap((long)platformId, (boolean)false, (boolean)(arrowDirection == 2 ? true : false), (float)(width / height), (boolean)this.transparentWhite).resourceLocation;
                RenderTrains.scheduleRender(resourceLocation, false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((PoseStack)matricesNew);
                    IDrawing.drawTexture(matricesNew, vertexConsumer, leftBlocks == 0 ? this.sidePadding : 0.0f, this.topPadding, 0.0f, 1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f), 1.0f - this.bottomPadding, 0.0f, ((float)leftBlocks - (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width, 0.0f, (width - (float)rightBlocks + (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width, 1.0f, facing.m_122424_(), color, light);
                    matricesNew.m_85849_();
                });
            }
            this.renderAdditional(storedMatrixTransformations, platformId, state, leftBlocks, rightBlocks, facing.m_122424_(), color, light);
        }
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    protected void renderAdditionalUnmodified(StoredMatrixTransformations storedMatrixTransformations, BlockState state, Direction facing, int light) {
    }

    protected float getAdditionalOffset(BlockState state) {
        return 0.0f;
    }

    protected boolean isLeft(BlockState state) {
        return IBlock.getStatePropertySafe(state, SIDE_EXTENDED) == IBlock.EnumSide.LEFT;
    }

    protected boolean isRight(BlockState state) {
        return IBlock.getStatePropertySafe(state, SIDE_EXTENDED) == IBlock.EnumSide.RIGHT;
    }

    protected abstract RenderType getRenderType(BlockGetter var1, BlockPos var2, BlockState var3);

    protected abstract void renderAdditional(StoredMatrixTransformations var1, long var2, BlockState var4, int var5, int var6, Direction var7, int var8, int var9);

    private int getTextureNumber(BlockGetter world, BlockPos pos, Direction facing, boolean searchLeft) {
        BlockState state;
        int number = 0;
        Block thisBlock = world.m_8055_(pos).m_60734_();
        while ((state = world.m_8055_(pos.m_5484_(searchLeft ? facing.m_122428_() : facing.m_122427_(), number))).m_60734_() == thisBlock) {
            boolean isLeft = this.isLeft(state);
            boolean isRight = this.isRight(state);
            if (number != 0 && !(searchLeft ? !isRight : !isLeft)) break;
            ++number;
            if (!(searchLeft ? isLeft : isRight)) continue;
            break;
        }
        return number - 1;
    }

    public static int getShadingColor(Direction facing, int grayscaleColorByte) {
        int colorByte = Math.round((float)(grayscaleColorByte & 0xFF) * (facing.m_122434_() == Direction.Axis.X ? 0.75f : 1.0f));
        return 0xFF000000 | (colorByte << 16) + (colorByte << 8) + colorByte;
    }

    protected static enum RenderType {
        ARROW,
        ROUTE,
        NONE;

    }
}

